/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.platform.win32.EnvVars;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.IOException;
import java.util.Properties;

public class WinEnvVars {
    public static void set(String key, String value) throws IOException {
        EnvVars.setWinNT(key, value, false);
    }

    public static void setUserSpecific(String key, String value) throws IOException {
        EnvVars.setWinNT(key, value, true);
    }

    public static String getenv(String key) {
        return Misc.getenv(key);
    }

    public static Properties getenv() {
        return Misc.getenv();
    }

    public static String getFromRegistry(String key, boolean userSpecific) throws IOException {
        return EnvVars.getWinNT(key, userSpecific);
    }

    public static void appendToPath(String value) throws IOException {
        String previousPath = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", "PATH").toString();
        EnvVars.setWinNT("PATH", previousPath + ";" + value, false);
    }

    public static void prependToPath(String value) throws IOException {
        String previousPath = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", "PATH").toString();
        EnvVars.setWinNT("PATH", value + ";" + previousPath, false);
    }

    public static void appendToUserPath(String value) throws IOException {
        String previousPath = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "Environment", "PATH").toString();
        EnvVars.setWinNT("PATH", previousPath + ";" + value, true);
    }

    public static void prependToUserPath(String value) throws IOException {
        Object userPath = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "Environment", "PATH");
        String newUserPath = userPath == null ? value : value + ";" + userPath.toString();
        EnvVars.setWinNT("PATH", newUserPath, true);
    }
}

