/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import org.apache.commons.math.linear.RealMatrixImpl;

public class QuadraticFitter
implements CurveFitter {
    private static QuadraticFitter \u0102;

    private QuadraticFitter() {
    }

    public static QuadraticFitter getInstance() {
        if (\u0102 == null) {
            \u0102 = new QuadraticFitter();
        }
        return \u0102;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        int n2 = chartModel.getPointCount();
        assert (n2 > 0) : "Can't perform a regression on a model containing no points!";
        double d2 = this.\u0101(chartModel, 1, 0);
        double d3 = this.\u0101(chartModel, 2, 0);
        double d4 = this.\u0101(chartModel, 3, 0);
        double d5 = this.\u0101(chartModel, 4, 0);
        double d6 = this.\u0101(chartModel, 0, 1);
        double d7 = this.\u0101(chartModel, 1, 1);
        double d8 = this.\u0101(chartModel, 2, 1);
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl((double[][])new double[][]{{n2, d2, d3}, {d2, d3, d4}, {d3, d4, d5}});
        double[] dArray = new double[]{d6, d7, d8};
        double[] dArray2 = realMatrixImpl.solve(dArray);
        return new Polynomial(dArray2);
    }

    @Override
    public DefaultChartModel createModel(Polynomial polynomial, Range<?> range, int n2) {
        return this.createModel((String)null, polynomial, (Range)range, n2);
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        for (Double d2 : doubleArray) {
            double d3 = polynomial.eval(d2);
            defaultChartModel.addPoint((double)d2, d3);
        }
        return defaultChartModel;
    }

    @Override
    public DefaultChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n2) {
        double d2 = range.minimum();
        double d3 = range.maximum();
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        double d4 = (d3 - d2) / (double)(n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = d2 + (double)i2 * d4;
            double d6 = polynomial.eval(d5);
            defaultChartModel.addPoint(d5, d6);
        }
        return defaultChartModel;
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n2) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, (Range)range, n2);
    }

    private double \u0101(ChartModel chartModel, int n2, int n3) {
        double d2 = 0.0;
        for (Chartable chartable : chartModel) {
            d2 += Math.pow(chartable.getX().position(), n2) * Math.pow(chartable.getY().position(), n3);
        }
        return d2;
    }
}

