/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.jdbc.kv.RoutableConnection;
import com.vertica.jdbc.kv.RoutableConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class RoutableConnectionList {
    String node;
    List<RoutableConnection> avail;
    int numOpen;
    Properties connProps;
    long lastFailureTime;
    RoutableConnectionPool pool;

    RoutableConnectionList(RoutableConnectionPool routableConnectionPool, String string, Properties properties) {
        this.pool = routableConnectionPool;
        this.node = string;
        this.avail = new LinkedList<RoutableConnection>();
        this.connProps = properties;
    }

    RoutableConnection checkout() {
        if (!this.avail.isEmpty()) {
            RoutableConnection routableConnection = this.avail.remove(0);
            ++routableConnection.numCheckouts;
            routableConnection.checkoutStart = System.currentTimeMillis();
            ++this.pool.activeCheckouts;
            return routableConnection;
        }
        return null;
    }

    void checkin(RoutableConnection routableConnection) throws SQLException {
        this.pool.checkoutTime = System.currentTimeMillis() - routableConnection.checkoutStart;
        if (this.pool.getMaxConnectionsUses() > 0 && routableConnection.numCheckouts >= this.pool.getMaxConnectionsUses()) {
            this.remove(routableConnection);
        } else {
            this.avail.add(routableConnection);
        }
    }

    RoutableConnection construct() {
        if (this.numOpen < this.pool.getMaxConnectionsPerNode()) {
            long l = System.currentTimeMillis() - this.lastFailureTime;
            if (this.lastFailureTime > 0L && l < this.pool.getNodeDownWaitTimeMs()) {
                if (this.pool.log.isEnabled()) {
                    this.pool.log.logInfo("Connection to node " + this.node + " failed " + l + " ms ago. Assumming node is still unavailable.");
                }
                return null;
            }
            try {
                long l2;
                long l3 = System.currentTimeMillis();
                Properties properties = (Properties)this.connProps.clone();
                String string = this.connProps.getProperty("sessionlabel") + "-pool" + this.pool.connCounter.getAndIncrement();
                properties.setProperty("sessionlabel", string);
                this.pool.log.logDebug("Opening new connection to node " + this.node);
                Connection connection = this.pool.driver.connect("jdbc:vertica", properties);
                RoutableConnection routableConnection = new RoutableConnection(this.node, connection);
                routableConnection.checkoutStart = l2 = System.currentTimeMillis();
                this.pool.createTime += l2 - l3;
                ++this.pool.totalOpens;
                ++this.numOpen;
                this.lastFailureTime = 0L;
                return routableConnection;
            }
            catch (SQLException sQLException) {
                this.lastFailureTime = System.currentTimeMillis();
                this.pool.log.logError("Failed to open new connection to node " + this.node, sQLException);
                return null;
            }
        }
        if (this.pool.log.isEnabled()) {
            this.pool.log.logDebug("Node " + this.node + " has reached per node connection limit (" + this.pool.getMaxConnectionsPerNode() + ")");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean consume(boolean bl) throws SQLException {
        if (!this.avail.isEmpty()) {
            RoutableConnection routableConnection = this.avail.remove(0);
            --this.numOpen;
            try {
                routableConnection.conn.close();
            }
            catch (SQLException sQLException) {
                this.pool.log.logError("Error closing connection to node " + this.node, sQLException);
                if (bl) {
                    throw sQLException;
                }
            }
            finally {
                ++this.pool.totalCloses;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(RoutableConnection routableConnection) throws SQLException {
        --this.numOpen;
        try {
            routableConnection.conn.close();
        }
        finally {
            ++this.pool.totalCloses;
        }
    }

    Connection getPrivateConnection() throws SQLException {
        return this.pool.driver.connect("jdbc:vertica", this.connProps);
    }
}

