/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final Pattern DURATION_PATTERN = Pattern.compile("([0-9]+)([^0-9]+)");
    public static final String suffixesShort = "ms/s/m/h/d/w";
    public static final String suffixesLong = "milliseconds/seconds/minutes/hours/days/weeks";
    private Long amount;
    private Scale scale;

    public Duration(long amount, Scale scale) {
        this.amount = amount;
        this.scale = scale;
    }

    public Duration(String duration) {
        if (duration.equals("0")) {
            duration = duration + "ms";
        }
        Matcher matcher = DURATION_PATTERN.matcher(duration);
        Preconditions.checkArgument(matcher.matches(), "Invalid duration '%s'. Durations must end in a time unit suffix. Allowed suffixes are ms/s/m/h/d/w (milliseconds/seconds/minutes/hours/days/weeks).", duration);
        this.amount = Long.parseLong(matcher.group(1));
        this.scale = Scale.fromString(matcher.group(2));
    }

    public long asSeconds() {
        return this.scale.convertToScale(this.amount, Scale.SECONDS);
    }

    public long asMilliSeconds() {
        return this.scale.convertToScale(this.amount, Scale.MILLISECONDS);
    }

    public long asMicroSeconds() {
        return this.asMilliSeconds() * 1000L;
    }

    public static enum Scale {
        MILLISECONDS(1L, "ms"),
        SECONDS(Scale.MILLISECONDS.value * 1000L, "s"),
        MINUTES(Scale.SECONDS.value * 60L, "m"),
        HOURS(Scale.MINUTES.value * 60L, "h"),
        DAYS(Scale.HOURS.value * 24L, "d"),
        WEEKS(Scale.DAYS.value * 7L, "w");

        private long value;
        private String suffix;

        private Scale(long value, String suffix) {
            this.value = value;
            this.suffix = suffix;
        }

        public static Scale fromString(String s) {
            String suffix = s.toLowerCase();
            for (Scale scale : Scale.values()) {
                if (!scale.suffix.equals(suffix)) continue;
                return scale;
            }
            throw new IllegalArgumentException("Invalid duration suffix '" + suffix + "'. Allowed suffixes are " + Duration.suffixesShort + " (" + Duration.suffixesLong + ").");
        }

        public Long convertToScale(Long amount, Scale targetScale) {
            return amount * this.value / targetScale.value;
        }
    }
}

