/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.metadata;

import com.ibm.db2.cmx.internal.core.Request;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.metadata.DataBean;
import com.ibm.db2.cmx.internal.metadata.DataBeanBaseStatistic;
import com.ibm.db2.cmx.internal.monitor.MonitorAgent;
import com.ibm.db2.cmx.internal.monitor.MonitorAgentImpl;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataBeanStatementExecution
extends DataBeanBaseStatistic {
    private static Logger logger__ = Log.getCMXClientLogger();
    public static final int SQLHASH = 0;
    public static final int MONITORID = 1;
    public static final int STATIC = 2;
    public static final int KEYLESS = 3;
    public static final String STAT_PKG = "SYSSTAT";
    public String sql_;
    private String truncatedSql_;
    public Object[] wasData_;
    public int validRoutineId_ = 0;
    private String sqlHashString_;
    private String monitorIdString_;
    public String staticIdString_;
    private String metadataCorrelator_ = null;
    public String db2PackagePath_ = null;
    public String db2Collection_ = null;
    public String procedureName_ = null;
    public static final int METADATA_PACKAGE = 0;
    public static final int METADATA_CONTOKEN = 1;
    public static final int METADATA_SECTION = 2;
    private int keyType_ = 0;
    private static ThreadLocal<StatementDescriptorImpl> dataLayerToMonitorTransporter_ = new ThreadLocal();
    public boolean hasDataLayerCorrelator_ = false;
    private Set<String> staticCollections_ = null;
    public MonitorAgentImpl monitorAgent_ = null;
    private int maxBytesUsedforHash_ = 0;

    public DataBeanStatementExecution(MonitorAgent monitorAgent, int n2) {
        this.monitorAgent_ = (MonitorAgentImpl)monitorAgent;
        this.maxBytesUsedforHash_ = n2;
        StatementDescriptorImpl statementDescriptorImpl = dataLayerToMonitorTransporter_.get();
        if (statementDescriptorImpl != null) {
            if (statementDescriptorImpl.cachedMetaDataCorrelator_ != null) {
                this.metadataCorrelator_ = statementDescriptorImpl.cachedMetaDataCorrelator_;
            } else {
                statementDescriptorImpl.cachedMetaDataCorrelator_ = this.metadataCorrelator_ = DataBeanStatementExecution.getMetadataCorrelatorString(statementDescriptorImpl.getPackageName(), DataBeanStatementExecution.getTimestampString(statementDescriptorImpl.getConsistencyToken()), statementDescriptorImpl.getId());
            }
            this.hasDataLayerCorrelator_ = true;
            dataLayerToMonitorTransporter_.set(null);
        }
    }

    public DataBeanStatementExecution(DataBeanStatementExecution dataBeanStatementExecution) {
        this.metadataCorrelator_ = dataBeanStatementExecution.getMetadataCorrelator();
        this.hasDataLayerCorrelator_ = dataBeanStatementExecution.hasDataLayerCorrelator_;
        this.monitorAgent_ = dataBeanStatementExecution.monitorAgent_;
        this.maxBytesUsedforHash_ = dataBeanStatementExecution.maxBytesUsedforHash_;
    }

    public void setDriverData(Object[] objectArray) {
        int n2 = 0;
        boolean bl2 = false;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, this, "setDriverData", Arrays.deepToString(objectArray));
        }
        this.sql_ = (String)objectArray[0];
        this.driverTimings_ = (long[])objectArray[1];
        n2 = objectArray.length;
        if (n2 >= 10) {
            CharSequence charSequence;
            this.uowSeq_ = (Long)objectArray[3];
            if (n2 >= 13 && objectArray[12] != null && objectArray[9] != null && objectArray[9].equals(STAT_PKG)) {
                this.procedureName_ = (String)objectArray[12];
                bl2 = true;
            }
            if (objectArray[4] != null) {
                this.monitorIdString_ = Request.getHexString((byte[])objectArray[4], true);
                if (null != this.monitorIdString_) {
                    this.keyType_ = 1;
                    if (bl2) {
                        charSequence = this.getRoutineId(objectArray[4]);
                        boolean bl3 = true;
                        int n3 = this.monitorAgent_.getServerVersion();
                        if (n3 > 0 && n3 < 7) {
                            bl3 = false;
                        }
                        if (charSequence != null && bl3) {
                            this.validRoutineId_ = 1;
                        }
                    }
                } else {
                    this.keyType_ = 3;
                }
            } else if (this.monitorAgent_.monitorIdRequired_) {
                this.keyType_ = 3;
            }
            if (this.sql_ != null && bl2 && this.validRoutineId_ == 0) {
                this.keyType_ = 3;
            }
            this.srvnam_ = (String)objectArray[5];
            this.prdid_ = (String)objectArray[6];
            this.crrtkn_ = (String)objectArray[7];
            if (objectArray[8] != null && !bl2) {
                this.db2Collection_ = objectArray[8].toString();
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(objectArray[9]);
                ((StringBuilder)charSequence).append(':');
                ((StringBuilder)charSequence).append(DataBeanStatementExecution.getTimestampString((byte[])objectArray[10]));
                ((StringBuilder)charSequence).append(':');
                ((StringBuilder)charSequence).append(objectArray[11]);
                this.staticIdString_ = ((StringBuilder)charSequence).toString();
                if (this.keyType_ != 1) {
                    this.keyType_ = 2;
                }
            }
        }
    }

    private String getRoutineId(Object object) {
        byte[] byArray = (byte[])object;
        String string = null;
        if (byArray.length >= 32) {
            byte[] byArray2 = new byte[8];
            int n2 = 24;
            for (int i10 = 0; n2 < 32 && i10 < 8; ++n2, ++i10) {
                byArray2[i10] = byArray[n2];
            }
            string = Request.getHexString(byArray2, true);
        }
        return string;
    }

    private String getSqlHash() {
        if (this.sqlHashString_ == null) {
            this.sqlHashString_ = Long.toString(this.monitorAgent_.hashCodeFowler(this.sql_, this.maxBytesUsedforHash_));
            if (!this.monitorAgent_.sendFullSQL_) {
                this.sql_ = null;
            }
        }
        return this.sqlHashString_;
    }

    public int getServerKeyType() {
        return this.keyType_;
    }

    public String getServerKey() {
        int n2 = 0;
        switch (this.keyType_) {
            case 0: {
                return this.getSqlHash();
            }
            case 2: {
                return this.staticIdString_;
            }
            case 1: {
                return this.monitorIdString_;
            }
            case 3: {
                if (this.truncatedSql_ == null && this.sql_ != null) {
                    n2 = this.getTruncateLength();
                    this.truncatedSql_ = this.sql_.substring(0, n2);
                }
                return this.truncatedSql_;
            }
        }
        return null;
    }

    private int getTruncateLength() {
        int n2 = 100;
        int n3 = 0;
        int n4 = this.sql_.length();
        if (this.procedureName_ != null) {
            for (int i10 = 5; i10 < n4 && this.sql_.charAt(i10) == ' '; ++i10) {
                ++n3;
            }
            n3 += 5 + this.procedureName_.length();
            if (n4 < n2) {
                n2 = n4;
            } else if (n3 > n2) {
                n2 = n3;
            }
        } else if (n4 < n2) {
            n2 = n4;
        }
        return n2;
    }

    public boolean statementTimerStarted() {
        return this.startTime_ > 0L;
    }

    public JSONArray toJSON_DSM() {
        JSONArray jSONArray = new JSONArray();
        if (this.getServerKeyType() == 1) {
            jSONArray.add(this.getServerKey());
        } else {
            jSONArray.add((Object)null);
        }
        jSONArray.add(this.authid_);
        jSONArray.add((Object)this.aggregatedClientInfoCacheIndex_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.applicationElapsedTimeForQueriesIncludingDriverTime_);
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 0));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 1));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 2));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 3));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 4));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 5));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 6));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 7));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 8));
        jSONArray.add((Object)this.numRowsReturned_);
        jSONArray.add((Object)this.aggregatedNumExecutions_);
        jSONArray.add((Object)this.firstNegativeSqlCode_);
        jSONArray.add((Object)this.aggregatedNumNegativeSqlCodes_);
        return jSONArray;
    }

    public JSONArray toJSONv1() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)Long.parseLong(this.getSqlHash()));
        jSONArray.add(this.authid_);
        jSONArray.add((Object)this.aggregatedClientInfoCacheIndex_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.applicationElapsedTimeForQueriesIncludingDriverTime_);
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 0));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 1));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 2));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 3));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 4));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 5));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 6));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 7));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 8));
        jSONArray.add((Object)this.numRowsReturned_);
        jSONArray.add((Object)this.aggregatedNumExecutions_);
        jSONArray.add((Object)this.firstNegativeSqlCode_);
        jSONArray.add((Object)this.aggregatedNumNegativeSqlCodes_);
        return jSONArray;
    }

    public JSONArray toJSONv2() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)this.getServerKeyType());
        jSONArray.add(this.getServerKey());
        jSONArray.add(Configuration.isLicensed__ ? this.metadataCorrelator_ : null);
        jSONArray.add(this.authid_);
        jSONArray.add((Object)this.aggregatedClientInfoCacheIndex_);
        jSONArray.add(this.srvnam_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.applicationElapsedTimeForQueriesIncludingDriverTime_);
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 0));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 1));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 2));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 3));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 4));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 5));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 6));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 7));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 8));
        jSONArray.add((Object)this.numRowsReturned_);
        jSONArray.add((Object)this.aggregatedNumExecutions_);
        jSONArray.add((Object)this.firstNegativeSqlCode_);
        jSONArray.add((Object)this.aggregatedNumNegativeSqlCodes_);
        jSONArray.add(this.getStaticCollectionsString());
        return jSONArray;
    }

    public JSONArray toJSONv3() {
        JSONArray jSONArray = this.toJSONv2();
        jSONArray.add((Object)this.aggregatedEUOWClientInfoCacheIndex_);
        jSONArray.add((Object)this.aggregatedEUOWSettingsCacheIndex_);
        jSONArray.add((Object)(this.staticIdString_ == null ? 0 : 1));
        if (this.monitorAgent_.sendFullSQL_) {
            jSONArray.add(this.sql_);
        }
        return jSONArray;
    }

    public JSONArray toJSONv7() {
        JSONArray jSONArray = this.toJSONv3();
        jSONArray.add((Object)this.validRoutineId_);
        return jSONArray;
    }

    public JSONArray toJSON(int n2) {
        switch (n2) {
            case 1: {
                return this.toJSONv1();
            }
            case 2: {
                return this.toJSONv2();
            }
            case 3: {
                return this.toJSONv3();
            }
            case 4: {
                return this.toJSONv3();
            }
            case 5: {
                return this.toJSONv3();
            }
            case 6: {
                return this.toJSONv3();
            }
        }
        return this.toJSONv7();
    }

    public String getKey(int n2) {
        if (n2 < 2) {
            return this.getSqlHash();
        }
        String string = this.getServerKey();
        if (this.metadataCorrelator_ != null) {
            string = this.metadataCorrelator_ + string;
        }
        if (this.srvnam_ != null) {
            string = this.srvnam_ + string;
        }
        return string;
    }

    public static String getMetadataCorrelatorString(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(string2);
        stringBuilder.append(':');
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static void setMetadataCorrelatorForLayerTransport(StatementDescriptorImpl statementDescriptorImpl) {
        dataLayerToMonitorTransporter_.set(statementDescriptorImpl);
    }

    public void setMetadataCorrelatorString(String string) {
        this.metadataCorrelator_ = string;
    }

    public String getMetadataCorrelator() {
        return this.metadataCorrelator_;
    }

    private static String getTimestampString(byte[] byArray) {
        return StatementDescriptorImpl.getTimestampAsString(StatementDescriptorImpl.bytesToTimestamp(byArray));
    }

    @Override
    public void prepareForAggregation() {
        super.prepareForAggregation();
        this.addToStaticCollectionsIfStatic(this);
    }

    public void aggregate(DataBeanStatementExecution dataBeanStatementExecution) {
        super.aggregate(dataBeanStatementExecution);
        this.addToStaticCollectionsIfStatic(dataBeanStatementExecution);
    }

    private void addToStaticCollectionsIfStatic(DataBeanStatementExecution dataBeanStatementExecution) {
        if (dataBeanStatementExecution.staticIdString_ != null) {
            if (this.staticCollections_ == null) {
                this.staticCollections_ = new HashSet<String>();
            }
            this.staticCollections_.add(dataBeanStatementExecution.db2Collection_);
            if (dataBeanStatementExecution.db2PackagePath_ != null) {
                this.addCollectionsFromCurrentPackagePath();
            }
        }
    }

    void addCollectionsFromCurrentPackagePath() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.db2PackagePath_, " \t\n\r\f,");
        while (stringTokenizer.hasMoreTokens()) {
            this.staticCollections_.add(stringTokenizer.nextToken());
        }
    }

    private String getStaticCollectionsString() {
        if (this.staticCollections_ == null) {
            return null;
        }
        Iterator<String> iterator = this.staticCollections_.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            if (bl2) {
                stringBuilder.append(',');
            } else {
                bl2 = true;
            }
            stringBuilder.append((Object)iterator.next());
        }
        return stringBuilder.toString();
    }
}

