-- Copyright (c) DbVis Software AB. All Rights Reserved.
SELECT 
    cu.customer_id                   AS ID,
    cu.first_name||' '||cu.last_name AS name,
    a.address                        AS address,
    a.postal_code                    AS zip_code,
    a.phone                          AS phone,
    city.city                        AS city,
    country.country                  AS country,
    DECODE(cu.active, 1,'active','') AS notes,
    cu.store_id                      AS SID
FROM 
    customer cu 
JOIN 
    address a 
ON 
    cu.address_id = a.address_id 
JOIN 
    city 
ON 
    a.city_id = city.city_id
JOIN 
    country 
ON 
    city.country_id = country.country_id;