/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIStream;

public class XTIProcessor {
    private boolean interleave = false;

    public void setInterleavingMode(boolean bl) {
        this.interleave = bl;
    }

    public XTIStream createXTIStream(Blob blob) throws XTIException {
        XTIStream xTIStream = new XTIStream();
        try {
            xTIStream.setBlob(blob);
            xTIStream.setInterleaving(this.interleave);
        }
        catch (IOException iOException) {
            throw new XTIException(iOException.getMessage());
        }
        return xTIStream;
    }

    public XTIStream createXTIStream(InputStream inputStream) throws XTIException {
        XTIStream xTIStream = new XTIStream();
        xTIStream.setInputStream(inputStream);
        xTIStream.setInterleaving(this.interleave);
        return xTIStream;
    }

    public XTIStream createXTIStream(OutputStream outputStream) throws XTIException {
        XTIStream xTIStream = new XTIStream();
        xTIStream.setOutputStream(outputStream);
        xTIStream.setInterleaving(this.interleave);
        return xTIStream;
    }

    public XTIStream createXTIStream(File file) throws XTIException {
        XTIStream xTIStream = new XTIStream();
        try {
            xTIStream.setFile(file);
            xTIStream.setInterleaving(this.interleave);
        }
        catch (IOException iOException) {
            throw new XTIException(iOException.getMessage());
        }
        return xTIStream;
    }

    public XTIStream createXTIStream(byte[] byArray) throws XTIException {
        XTIStream xTIStream = new XTIStream();
        xTIStream.setByteArray(byArray);
        xTIStream.setInterleaving(this.interleave);
        return xTIStream;
    }

    public XTIStream createXTIStream() throws XTIException {
        XTIStream xTIStream = new XTIStream();
        xTIStream.setInterleaving(this.interleave);
        return xTIStream;
    }
}

