/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableRowMarginSupport
extends AbstractRowMarginSupport {
    protected JTable _table;
    private TableModelListener \u0109;
    private PropertyChangeListener \u010a;

    public TableRowMarginSupport(JTable jTable, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._table = jTable;
    }

    public JTable getTable() {
        return this._table;
    }

    @Override
    public int getRowCount() {
        return this._table.getRowCount();
    }

    @Override
    public void scrollTo(int n2, int n3, boolean bl) {
        if (bl) {
            this._table.getSelectionModel().setSelectionInterval(Math.min(n2, n3), Math.max(n2, n3));
        }
        this._table.scrollRectToVisible(this._table.getCellRect(n3, 0, false));
    }

    @Override
    public int getRowHeight(int n2) {
        return this._table.getRowHeight(n2);
    }

    @Override
    public int positionToRow(int n2) {
        int n3 = this.getViewPosition();
        Point point = new Point(0, n3 + n2);
        if (this._table instanceof CellSpanTable) {
            return ((CellSpanTable)this._table).originalRowAtPoint(point);
        }
        return this._table.rowAtPoint(point);
    }

    @Override
    public int rowToPosition(int n2) {
        Rectangle rectangle = this._table instanceof CellSpanTable ? ((CellSpanTable)this._table).originalGetCellRect(n2, 0, false) : this._table.getCellRect(n2, 0, false);
        int n3 = this.getViewPosition();
        return rectangle.y - n3;
    }

    @Override
    public int getBaselineAdjustment() {
        return -1;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this.\u0109 == null) {
                this.\u0109 = new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        modelChangedCallback.modelChanged(tableModelEvent);
                    }
                };
            }
            if (this.\u010a == null) {
                this.\u010a = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof TableModel) {
                            ((TableModel)object2).removeTableModelListener(TableRowMarginSupport.this.\u0109);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof TableModel) {
                            ((TableModel)object).addTableModelListener(TableRowMarginSupport.this.\u0109);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._table.addPropertyChangeListener("model", this.\u010a);
            this._table.getModel().addTableModelListener(this.\u0109);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this.\u010a != null) {
            this._table.removePropertyChangeListener("model", this.\u010a);
        }
        if (this.\u0109 != null) {
            this._table.getModel().removeTableModelListener(this.\u0109);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

