/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.XMenu;
import de.javasoft.swing.XMenuBar;
import de.javasoft.swing.plaf.XMenuUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicXMenuUI
extends XMenuUI
implements PropertyChangeListener {
    protected XMenu xMenu;
    protected AbstractButton menuButton;
    private MouseAdapter mouseHandler;
    private static MenuElement[] menuPath;
    private static ChangeListener menuChangeListener;

    static {
        final MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        FocusManager.getCurrentManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("focusedWindow".equals(propertyChangeEvent.getPropertyName())) {
                    menuSelectionManager.clearSelectedPath();
                }
            }
        });
        menuChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MenuElement menuElement;
                if (menuSelectionManager.getSelectedPath().length == 0 && menuPath != null) {
                    menuSelectionManager.setSelectedPath(menuPath);
                } else if (menuSelectionManager.getSelectedPath().length == 1 && menuPath != null && (menuElement = menuSelectionManager.getSelectedPath()[0]) instanceof Component && SwingUtilities.getAncestorOfClass(XMenuBar.class, (Component)((Object)menuElement)) != null) {
                    MenuElement[] menuElementArray = new MenuElement[menuPath.length + 1];
                    int n = 0;
                    while (n < menuPath.length) {
                        menuElementArray[n] = menuPath[n];
                        ++n;
                    }
                    menuElementArray[menuElementArray.length - 1] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        };
        menuSelectionManager.addChangeListener(menuChangeListener);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicXMenuUI();
    }

    public void installUI(JComponent jComponent) {
        this.xMenu = (XMenu)jComponent;
        if (!(this.xMenu.getMenuLayout() instanceof BorderLayout)) {
            this.xMenu.setMenuLayout(new BorderLayout());
        }
        super.installUI(jComponent);
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults(jComponent);
        this.uninstallListeners(jComponent);
        this.uninstallKeyboardActions();
    }

    protected void installDefaults(JComponent jComponent) {
        this.xMenu.getActionMap().put("selectMenu", new SelectMenuAction());
        this.xMenu.setBorderPainted(true);
        if (this.xMenu.getBorder() == null || this.xMenu.getBorder() instanceof UIResource) {
            this.xMenu.setBorder(WidgetUtils.createOrientationAwareEmptyBorder(SyntheticaLookAndFeel.getInsets("XMenu.insets", (Component)this.xMenu, false), true));
        }
        if (this.xMenu.getMenuButton() == null) {
            this.menuButton = this.createMenuButton();
            this.xMenu.setMenuButton(this.menuButton);
        } else {
            this.menuButton = this.xMenu.getMenuButton();
            this.menuButton.updateUI();
        }
        this.xMenu.addPropertyChangeListener(this);
        if (this.xMenu.animationEnabledIsUIResource()) {
            this.xMenu.setAnimationEnabled(SyntheticaLookAndFeel.getBoolean("XMenu.animation.enabled", this.xMenu, true), true);
        }
    }

    protected void uninstallDefaults(JComponent jComponent) {
        this.xMenu.removePropertyChangeListener(this);
    }

    protected void installListeners(JComponent jComponent) {
        jComponent.addMouseListener(this.getMouseHandler());
    }

    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removeMouseListener(this.getMouseHandler());
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    public static void dispose() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        menuSelectionManager.removeChangeListener(menuChangeListener);
        menuSelectionManager.clearSelectedPath();
        menuPath = null;
    }

    private MouseAdapter getMouseHandler() {
        if (this.mouseHandler == null) {
            this.mouseHandler = this.createMouseHandler();
        }
        return this.mouseHandler;
    }

    protected MouseAdapter createMouseHandler() {
        this.mouseHandler = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    BasicXMenuUI.this.xMenu.getModel().setRollover(true);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    BasicXMenuUI.this.xMenu.getModel().setRollover(false);
                }
                BasicXMenuUI.this.xMenu.getModel().setArmed(false);
                BasicXMenuUI.this.xMenu.getModel().setPressed(false);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    BasicXMenuUI.this.selectMenu(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                BasicXMenuUI.this.xMenu.getModel().setArmed(true);
                BasicXMenuUI.this.xMenu.getModel().setPressed(true);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                BasicXMenuUI.this.xMenu.getModel().setArmed(false);
                BasicXMenuUI.this.xMenu.getModel().setPressed(false);
            }
        };
        return this.mouseHandler;
    }

    protected AbstractButton createMenuButton() {
        JButton jButton = new JButton(this.xMenu.getText()){

            protected void paintComponent(Graphics graphics) {
                BasicXMenuUI.this.paintButtonBackground(BasicXMenuUI.this.xMenu, BasicXMenuUI.this.xMenu.isSelected(), graphics, 0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(graphics);
            }

            public boolean hasFocus() {
                return false;
            }

            public void updateUI() {
                super.updateUI();
                this.setForeground(BasicXMenuUI.this.xMenu.getForeground());
                this.setFont(BasicXMenuUI.this.xMenu.getFont());
                this.setBorder(WidgetUtils.createOrientationAwareEmptyBorder(SyntheticaLookAndFeel.getInsets("XMenu.menuButton.insets", (Component)BasicXMenuUI.this.xMenu, new Insets(4, 4, 4, 4)), true));
            }
        };
        jButton.setName("XMenu.menuButton");
        jButton.setModel(new DefaultButtonModel(){

            public boolean isPressed() {
                return BasicXMenuUI.this.xMenu.getModel().isPressed();
            }

            public boolean isArmed() {
                return BasicXMenuUI.this.xMenu.getModel().isArmed();
            }

            public boolean isSelected() {
                return BasicXMenuUI.this.xMenu.getModel().isSelected();
            }
        });
        jButton.setFocusable(false);
        jButton.setMnemonic(this.xMenu.getMnemonic());
        jButton.putClientProperty("Synthetica.opaque", false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.dispatchMouseEvent(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.dispatchMouseEvent(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                this.dispatchMouseEvent(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (BasicXMenuUI.this.isMouseSensitive()) {
                    this.dispatchMouseEvent(mouseEvent);
                } else {
                    BasicXMenuUI.this.selectMenu(mouseEvent);
                    BasicXMenuUI.this.xMenu.getModel().setArmed(false);
                    BasicXMenuUI.this.xMenu.getModel().setPressed(false);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.dispatchMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.dispatchMouseEvent(mouseEvent);
            }

            private void dispatchMouseEvent(MouseEvent mouseEvent) {
                Container container = mouseEvent.getComponent().getParent();
                container.dispatchEvent(SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, container));
                BasicXMenuUI.this.xMenu.repaint();
            }
        };
        jButton.addMouseListener(mouseAdapter);
        jButton.addMouseMotionListener(mouseAdapter);
        return jButton;
    }

    protected boolean isMouseSensitive() {
        return SyntheticaLookAndFeel.getBoolean("XMenu.mouseSensitive", this.xMenu, false);
    }

    private void selectMenu(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        if (abstractButton.isEnabled() && mouseEvent.getButton() == 1) {
            this.xMenu.getActionMap().get("selectMenu").actionPerformed(new ActionEvent(this.xMenu, 1001, ""));
        }
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        this.paintBackground(jComponent, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        super.paint(graphics, jComponent);
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    protected void paintContentPaneBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    protected void paintButtonBackground(JComponent jComponent, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.installDefaults(jComponent);
        }
        if ("mnemonic".equals(string)) {
            SwingXUtilities.updateMnemonicBinding((JComponent)this.xMenu, (String)"selectMenu");
            this.menuButton.setMnemonic((Integer)propertyChangeEvent.getNewValue());
        } else if ("text".equals(string)) {
            this.menuButton.setText("" + propertyChangeEvent.getNewValue());
        } else if ("foreground".equals(string)) {
            this.menuButton.setForeground((Color)propertyChangeEvent.getNewValue());
        } else if ("font".equals(string)) {
            Font font = (Font)propertyChangeEvent.getNewValue();
            this.menuButton.setFont(font == null ? null : font.deriveFont(font.getStyle()));
        } else if ("icon".equals(string)) {
            this.menuButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if ("enabled".equals(string)) {
            this.menuButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public Border createContentPaneBorder() {
        return new ContentPaneBorder();
    }

    private class ContentPaneBorder
    implements Border {
        private Insets insets;

        private ContentPaneBorder() {
            this.insets = SyntheticaLookAndFeel.getInsets("XMenu.contentPane.insets", (Component)BasicXMenuUI.this.xMenu, new Insets(0, 0, 0, 0));
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicXMenuUI.this.paintContentPaneBackground(BasicXMenuUI.this.xMenu, graphics, n, n2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            boolean bl = component.getComponentOrientation().isLeftToRight();
            Insets insets = new Insets(this.insets.top, 0, this.insets.bottom, 0);
            insets.left = bl ? this.insets.left : this.insets.right;
            insets.right = bl ? this.insets.right : this.insets.left;
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class SelectMenuAction
    extends AbstractAction {
        public SelectMenuAction() {
            super("selectMenu");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Container container = BasicXMenuUI.this.xMenu.getParent();
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof XMenu && component != BasicXMenuUI.this.xMenu && !((XMenu)component).isCollapsed()) {
                    ((XMenu)component).setCollapsed(true);
                }
                ++n2;
            }
            BasicXMenuUI.this.xMenu.setCollapsed(!BasicXMenuUI.this.xMenu.isCollapsed());
            this.setSelectedPath();
        }

        private void setSelectedPath() {
            Container container;
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (!BasicXMenuUI.this.xMenu.isSelected() && (container = BasicXMenuUI.this.xMenu.getParent()) != null && container instanceof JMenuBar) {
                MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)((Object)container), BasicXMenuUI.this.xMenu};
                menuPath = menuElementArray;
                menuSelectionManager.setSelectedPath(menuPath);
            }
        }

        public boolean isEnabled() {
            return BasicXMenuUI.this.xMenu.isEnabled();
        }
    }
}

