/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.jydocking.DockingManager;
import de.javasoft.swing.jydocking.FloatingDockingPort;
import de.javasoft.swing.jydocking.FloatingGroup;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.IDockingPort;
import de.javasoft.swing.jydocking.IFloatingDockingPort;
import de.javasoft.swing.jydocking.Perspective;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

class FloatingDialog
extends JDialog {
    private static final long serialVersionUID = 456081945923738818L;
    private static final BoundsMonitor BOUNDS_MONITOR = new BoundsMonitor();
    private IFloatingDockingPort dockingPort;
    private String groupID;

    FloatingDialog(Frame frame, String string) {
        super(frame);
        this.initialize(string);
    }

    FloatingDialog(Dialog dialog, String string) {
        super(dialog);
        this.initialize(string);
    }

    private void initialize(String string) {
        Object object;
        this.groupID = string;
        this.setName("JYDocking.FloatingDialog");
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel && SyntheticaLookAndFeel.getBoolean("Synthetica.window.decoration", this)) {
            object = (JComponent)SyntheticaLookAndFeel.findComponent("RootPane.titlePane", (Container)this);
            ((JComponent)object).setPreferredSize(new Dimension(12, 12));
            boolean bl = SyntheticaLookAndFeel.getBoolean("JYDocking.floatingWindow.closeButton.visible", this, false);
            SyntheticaLookAndFeel.findComponent("RootPane.titlePane.closeButton", (Container)object).setVisible(bl);
            boolean bl2 = SyntheticaLookAndFeel.getBoolean("JYDocking.floatingWindow.menuButton.visible", this, true);
            Component component = SyntheticaLookAndFeel.findComponent("RootPane.titlePane.menuButton", (Container)object);
            if (component != null) {
                component.setVisible(bl2);
            }
        }
        this.dockingPort = (object = DockingManager.getDockingStrategy(IFloatingDockingPort.class).createDockingPort(null)) instanceof IFloatingDockingPort ? (IFloatingDockingPort)object : new FloatingDockingPort();
        this.dockingPort.setFloatingWindow(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(SyntheticaLookAndFeel.getInsets("JYDocking.floatingWindow.insets", (Component)this, new Insets(2, 2, 2, 2))));
        jPanel.add(this.dockingPort.getComponent());
        this.setContentPane(jPanel);
        this.addComponentListener(BOUNDS_MONITOR);
    }

    public IDockingPort getDockingPort() {
        return this.dockingPort;
    }

    public void addDockable(IDockable iDockable, Perspective perspective) {
        if (iDockable == null) {
            return;
        }
        this.dockingPort.dock(iDockable, perspective, "CENTER");
    }

    public void destroy() {
        this.setVisible(false);
        this.dockingPort = null;
        FloatingGroup floatingGroup = this.getGroup();
        if (floatingGroup != null) {
            floatingGroup.setFloatingWindow(null);
        }
        this.dispose();
    }

    public String getGroupID() {
        return this.groupID;
    }

    public FloatingGroup getGroup() {
        return DockingManager.getFloatingGroup(this.getGroupID());
    }

    private static class BoundsMonitor
    implements ComponentListener {
        private BoundsMonitor() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.updateBounds(componentEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.updateBounds(componentEvent);
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.updateBounds(componentEvent);
        }

        private void updateBounds(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (!(component instanceof FloatingDialog)) {
                return;
            }
            FloatingDialog floatingDialog = (FloatingDialog)component;
            FloatingGroup floatingGroup = floatingDialog.getGroup();
            if (floatingGroup != null) {
                floatingGroup.setBounds(floatingDialog.getBounds());
            }
        }
    }
}

