/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.RC4_encoder;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;

class EXAInputStream
extends InputStream {
    static final boolean trace = false;
    final EXAConnection connection;
    protected InputStream father;
    private byte[] buffer;
    private byte[] bigbuffer;
    private Calendar utcCal;
    private Calendar defCal;

    public EXAInputStream(InputStream inputStream, EXAConnection eXAConnection) {
        this.father = inputStream;
        this.buffer = new byte[8];
        this.bigbuffer = new byte[16];
        this.utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.defCal = Calendar.getInstance();
        this.connection = eXAConnection;
    }

    public EXAInputStream(byte[] byArray, EXAConnection eXAConnection) {
        this.father = new ByteArrayInputStream(byArray);
        this.buffer = new byte[8];
        this.bigbuffer = new byte[16];
        this.utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.connection = eXAConnection;
    }

    public void SetEncryptor(RC4_encoder rC4_encoder) throws IOException {
        if (!(this.father instanceof EncryptedInputStream)) {
            throw new IOException("Try to activate encryption on an InputStream that is not an instance of EncryptedInputStream");
        }
        ((EncryptedInputStream)this.father).SetEncryptor(rC4_encoder);
    }

    @Override
    public int available() throws IOException {
        return this.father.available();
    }

    @Override
    public void close() throws IOException {
        this.father.close();
    }

    @Override
    public void mark(int n) {
        this.father.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.father.markSupported();
    }

    @Override
    public int read() throws IOException {
        int n = 100000;
        if (this.connection.testReadTimeout) {
            n = EXAConnection.testReadTimeoutVal;
        }
        if (this.connection.getActiveProtocolVersion() >= 9) {
            switch (this.connection.getExecutionMode()) {
                case 11: 
                case 12: 
                case 17: 
                case 38: {
                    n = this.connection.getFeedbackInterval() + 30;
                }
            }
        }
        while (n > 0) {
            try {
                int n2 = this.father.read();
                return n2;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                --n;
            }
        }
        throw new IOException(Translator.Socket_failed_to_deliver_any_feedback_from_server());
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 100000;
        if (this.connection.testReadTimeout) {
            n3 = EXAConnection.testReadTimeoutVal;
        }
        if (this.connection.getActiveProtocolVersion() >= 9) {
            switch (this.connection.getExecutionMode()) {
                case 11: 
                case 12: 
                case 17: 
                case 38: {
                    n3 = this.connection.getFeedbackInterval() + 30;
                }
            }
        }
        while (n3 > 0) {
            try {
                int n4;
                int n5;
                if (n5 < 0) {
                    throw new IOException();
                }
                for (n5 = this.father.read(byArray, n, n2); n5 < n2; n5 += n4) {
                    n4 = this.father.read(byArray, n + n5, n2 - n5);
                    if (n4 >= 0) continue;
                    throw new IOException();
                }
                return n5;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                --n3;
            }
        }
        throw new IOException(Translator.Socket_failed_to_deliver_any_feedback_from_server());
    }

    @Override
    public void reset() throws IOException {
        this.father.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.father.skip(l);
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public char readChar() throws IOException {
        return (char)this.read();
    }

    public int readInt() throws IOException {
        this.read(this.buffer, 0, 4);
        return (this.buffer[3] & 0xFF) << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    public short readShort() throws IOException {
        this.read(this.buffer, 0, 2);
        return (short)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    public long readLong() throws IOException {
        this.read(this.buffer, 0, 8);
        return ((long)this.buffer[7] & 0xFFL) << 56 | ((long)this.buffer[6] & 0xFFL) << 48 | ((long)this.buffer[5] & 0xFFL) << 40 | ((long)this.buffer[4] & 0xFFL) << 32 | ((long)this.buffer[3] & 0xFFL) << 24 | ((long)this.buffer[2] & 0xFFL) << 16 | ((long)this.buffer[1] & 0xFFL) << 8 | (long)this.buffer[0] & 0xFFL;
    }

    public double readDouble() throws IOException {
        this.read(this.buffer, 0, 8);
        long l = ((long)this.buffer[7] & 0xFFL) << 56 | ((long)this.buffer[6] & 0xFFL) << 48 | ((long)this.buffer[5] & 0xFFL) << 40 | ((long)this.buffer[4] & 0xFFL) << 32 | ((long)this.buffer[3] & 0xFFL) << 24 | ((long)this.buffer[2] & 0xFFL) << 16 | ((long)this.buffer[1] & 0xFFL) << 8 | (long)this.buffer[0] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public float readFloat() throws IOException {
        this.read(this.buffer, 0, 4);
        int n = (this.buffer[3] & 0xFF) << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    public exaTimestamp readTimestamp() throws IOException {
        short s = this.readShort();
        byte by = this.readByte();
        byte by2 = this.readByte();
        byte by3 = this.readByte();
        byte by4 = this.readByte();
        byte by5 = this.readByte();
        int n = this.readInt();
        return new exaTimestamp(s, (byte)(by - 1), by2, by3, by4, by5, n);
    }

    public SimpleDate readDate() throws IOException {
        int n = this.readInt();
        return new SimpleDate(n);
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (n <= 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        this.read(byArray);
        return new String(byArray, this.connection.getEncoding());
    }

    public byte[] readBinary() throws IOException {
        int n = this.readInt();
        if (n <= 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        this.read(byArray);
        return byArray;
    }

    public boolean nextIsNull() throws IOException {
        return this.readByte() == 0;
    }

    public boolean nextIsValue() throws IOException {
        return this.readByte() != 0;
    }

    public ProtocolAttribute readAttribute() throws IOException {
        short s = this.readShort();
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(s);
        switch (protocolAttribute.type) {
            case 0: {
                throw new IOException(Translator.Unsupported_attribute() + s);
            }
            case 10: {
                protocolAttribute.value = this.readString();
                break;
            }
            case 15: {
                protocolAttribute.value = this.readBinary();
                protocolAttribute.binaryLength = ((byte[])protocolAttribute.value).length;
                break;
            }
            case 4: {
                protocolAttribute.value = new Integer(this.readInt());
                break;
            }
            case 1: {
                protocolAttribute.value = new Byte(this.readByte());
                break;
            }
            case 9: {
                protocolAttribute.value = new Boolean(this.readBoolean());
                break;
            }
            case 14: {
                protocolAttribute.value = new Date(this.readInt());
                break;
            }
            case 8: {
                protocolAttribute.value = new Double(this.readDouble());
                break;
            }
            case 5: {
                protocolAttribute.value = new Long(this.readLong());
                break;
            }
            case 7: {
                protocolAttribute.value = new Float(this.readFloat());
                break;
            }
            case 2: {
                protocolAttribute.value = new Short(this.readShort());
                break;
            }
            case 21: {
                protocolAttribute.value = this.readTimestamp();
                break;
            }
            case 64: {
                protocolAttribute.value = this.readBigInteger();
                break;
            }
            default: {
                throw new IOException(Translator.Unsupported_type_of_attribute_value_for_attribute() + s);
            }
        }
        return protocolAttribute;
    }

    public BigInteger readBigInteger() throws IOException {
        for (int i = 15; i >= 0; --i) {
            int n = this.read();
            if (n < 0) {
                throw new IOException(Translator.End_of_input_stream());
            }
            this.bigbuffer[i] = (byte)n;
        }
        BigInteger bigInteger = new BigInteger(this.bigbuffer);
        return bigInteger;
    }
}

