/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.graphics.SoftMask;
import org.icepdf.core.util.Library;

public class ExtGState
extends Dictionary {
    private static final Logger logger = Logger.getLogger(ExtGState.class.toString());
    public static final Name SMASK_KEY = new Name("SMask");
    public static final Name LW_KEY = new Name("LW");
    public static final Name LC_KEY = new Name("LC");
    public static final Name LJ_KEY = new Name("LJ");
    public static final Name ML_KEY = new Name("ML");
    public static final Name CA_KEY = new Name("CA");
    public static final Name ca_KEY = new Name("ca");
    public static final Name BM_KEY = new Name("BM");
    public static final Name OP_KEY = new Name("OP");
    public static final Name op_KEY = new Name("op");
    public static final Name OPM_KEY = new Name("OPM");
    public static final Name D_KEY = new Name("D");
    public static final Name AIS_KEY = new Name("AIS");
    public static final Name HT_KEY = new Name("HT");
    public static final Name BG2_KEY = new Name("BG2");
    public static final Name SA_KEY = new Name("SA");

    public ExtGState(Library library, HashMap graphicsState) {
        super(library, graphicsState);
    }

    public Number getLineWidth() {
        return this.getNumber(LW_KEY);
    }

    public Number getLineCapStyle() {
        return this.getNumber(LC_KEY);
    }

    public Name getBlendingMode() {
        Object tmp = this.library.getObject(this.entries, BM_KEY);
        if (tmp instanceof Name) {
            return (Name)tmp;
        }
        if (tmp instanceof List) {
            List list = (List)tmp;
            return (Name)list.get(0);
        }
        return null;
    }

    public Number getLineJoinStyle() {
        return this.getNumber(LJ_KEY);
    }

    Number getMiterLimit() {
        return this.getNumber(ML_KEY);
    }

    public List getLineDashPattern() {
        ArrayList<Object> dashPattern = null;
        float[] dashArray = null;
        if (this.entries.containsKey(D_KEY)) {
            try {
                List dashData = (List)this.entries.get(D_KEY);
                Number dashPhase = (Number)dashData.get(1);
                List dashVector = (List)dashData.get(0);
                if (dashVector.size() > 0) {
                    int sz = dashVector.size();
                    dashArray = new float[sz];
                    for (int i = 0; i < sz; ++i) {
                        dashArray[i] = ((Number)dashVector.get(i)).floatValue();
                    }
                } else {
                    dashPhase = Float.valueOf(0.0f);
                    dashArray = null;
                }
                dashPattern = new ArrayList<Object>(2);
                dashPattern.add(dashArray);
                dashPattern.add(dashPhase);
            }
            catch (ClassCastException e) {
                logger.log(Level.FINE, "Dash pattern syntax error: ", e);
            }
        }
        return dashPattern;
    }

    public float getStrokingAlphConstant() {
        if (this.getNumber(CA_KEY) != null) {
            return this.getFloat(CA_KEY);
        }
        return -1.0f;
    }

    public float getNonStrokingAlphConstant() {
        if (this.getNumber(ca_KEY) != null) {
            return this.getFloat(ca_KEY);
        }
        return -1.0f;
    }

    public Boolean getOverprint() {
        Object o = this.getObject(OP_KEY);
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    public Boolean isAlphaAShape() {
        Object o = this.getObject(AIS_KEY);
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public Boolean getOverprintFill() {
        Object o = this.getObject(op_KEY);
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    public int getOverprintMode() {
        return this.getInt(OPM_KEY);
    }

    public boolean hasOverPrintMode() {
        return this.library.getObject(this.entries, OPM_KEY) != null;
    }

    public boolean hasAlphaIsShape() {
        return this.library.getObject(this.entries, AIS_KEY) != null;
    }

    public boolean hasHalfTone() {
        return this.library.getObject(this.entries, HT_KEY) != null;
    }

    public boolean hasBG2Function() {
        return this.library.getObject(this.entries, BG2_KEY) != null;
    }

    public SoftMask getSMask() {
        Object tmp = this.library.getObject(this.entries, SMASK_KEY);
        if (tmp != null && tmp instanceof HashMap) {
            SoftMask softMask = new SoftMask(this.library, (HashMap)tmp);
            softMask.setPObjectReference(this.library.getReference(this.entries, SMASK_KEY));
            return softMask;
        }
        return null;
    }
}

