/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.RasterOps;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class YCCKRasterOp
implements RasterOp {
    private RenderingHints hints = null;

    public YCCKRasterOp(RenderingHints hints) {
        this.hints = hints;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        byte[] srcPixels = ((DataBufferByte)src.getDataBuffer()).getData();
        byte[] destPixels = ((DataBufferByte)dest.getDataBuffer()).getData();
        double lastY = -1.0;
        double lastCb = -1.0;
        double lastCr = -1.0;
        double lastK = -1.0;
        int c = 0;
        int m = 0;
        int y2 = 0;
        int k = 0;
        int bands = src.getNumBands();
        for (int pixel = 0; pixel < srcPixels.length; pixel += bands) {
            double Y = srcPixels[pixel] & 0xFF;
            double Cb = srcPixels[pixel + 1] & 0xFF;
            double Cr = srcPixels[pixel + 2] & 0xFF;
            double K = srcPixels[pixel + 3] & 0xFF;
            if (lastY != Y || lastCb != Cb || lastCr != Cr || lastK != K) {
                c = 255 - (int)(Y + 1.402 * Cr - 179.456);
                m = 255 - (int)(Y - 0.34414 * Cb - 0.71413636 * Cr + 135.45984);
                y2 = 255 - (int)(Y + 1.7718 * Cb - 226.816);
                k = (int)K;
                c = YCCKRasterOp.clip(0, 255, c);
                m = YCCKRasterOp.clip(0, 255, m);
                y2 = YCCKRasterOp.clip(0, 255, y2);
            }
            lastY = Y;
            lastCb = Cb;
            lastCr = Cr;
            lastK = K;
            destPixels[pixel] = (byte)(c & 0xFF);
            destPixels[pixel + 1] = (byte)(m & 0xFF);
            destPixels[pixel + 2] = (byte)(y2 & 0xFF);
            destPixels[pixel + 3] = (byte)(k & 0xFF);
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = (Point2D)srcPt.clone();
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    private static int clip(int floor, int ceiling, int value) {
        if (value < floor) {
            value = floor;
        }
        if (value > ceiling) {
            value = ceiling;
        }
        return value;
    }
}

