/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataReadOnlyException;
import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.column.AbstractColumn;
import java.util.BitSet;

public class BooleanColumn
extends AbstractColumn {
    private BitSet \u0104;
    private int \u0103;

    public BooleanColumn() {
        this(0, 10, false);
    }

    public BooleanColumn(int n2) {
        this(n2, n2, false);
    }

    public BooleanColumn(int n2, int n3, boolean bl) {
        super(Boolean.TYPE, new Boolean(bl));
        if (n3 < n2) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.\u0104 = new BitSet(n3);
        this.\u0104.set(0, n3, bl);
        this.\u0103 = n2;
    }

    @Override
    public int getRowCount() {
        return this.\u0103;
    }

    @Override
    public void setMaximumRow(int n2) {
        if (n2 > this.\u0103) {
            this.\u0104.set(this.\u0103, n2, (Boolean)this.m_defaultValue);
        }
        this.\u0103 = n2;
    }

    @Override
    public Object get(int n2) {
        return new Boolean(this.getBoolean(n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Boolean) {
            this.setBoolean((Boolean)object, n2);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n2);
        }
    }

    @Override
    public boolean getBoolean(int n2) throws DataTypeException {
        if (n2 < 0 || n2 > this.\u0103) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        return this.\u0104.get(n2);
    }

    @Override
    public void setBoolean(boolean bl, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.\u0103) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        boolean bl2 = this.\u0104.get(n2);
        if (bl2 == bl) {
            return;
        }
        this.\u0104.set(n2, bl);
        this.fireColumnEvent(n2, bl2);
    }
}

