/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.A;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TableColumnAutoResizer
extends A {
    protected static final String KEY = "columnAutoResizer";

    public TableColumnAutoResizer(JTable jTable) {
        this(jTable, true);
    }

    public TableColumnAutoResizer(JTable jTable, boolean bl) {
        super(jTable, bl);
    }

    @Override
    String \u0101() {
        return KEY;
    }

    @Override
    public MouseInputListener createMouseInputListener() {
        return new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n2;
                    Point point = mouseEvent.getPoint();
                    if (TableColumnAutoResizer.this.\u0102) {
                        if (TableColumnAutoResizer.this.\u0101.getTableHeader() == null) {
                            return;
                        }
                        n2 = TableColumnAutoResizer.this.\u0101.getTableHeader().columnAtPoint(point);
                    } else {
                        n2 = TableColumnAutoResizer.this.\u0101.columnAtPoint(point);
                    }
                    if (n2 != -1) {
                        TableColumn[] tableColumnArray;
                        for (TableColumn tableColumn : tableColumnArray = TableColumnAutoResizer.this.\u0101(TableColumnAutoResizer.this.\u0101, point, n2)) {
                            TableColumnAutoResizer.this.resizeColumn(tableColumn);
                        }
                    }
                }
            }
        };
    }

    protected void resizeColumn(TableColumn tableColumn) {
        if (TableUtils.isTableColumnResizable(this.\u0101, tableColumn)) {
            TableUtils.autoResizeColumn(this.\u0101, this.\u0101.convertColumnIndexToView(tableColumn.getModelIndex()), this.\u0102);
        }
    }

    private TableColumn[] \u0101(JTable jTable, Point point, int n2) {
        CellSpan cellSpan;
        int n3;
        if (n2 == -1) {
            return new TableColumn[0];
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (this.\u0102 && jTableHeader == null) {
            return new TableColumn[0];
        }
        Rectangle rectangle = this.\u0102 ? jTableHeader.getHeaderRect(n2) : jTable.getCellRect(this.\u0101.rowAtPoint(point), n2, true);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return new TableColumn[0];
        }
        int n4 = rectangle.x + rectangle.width / 2;
        boolean bl = this.\u0102 ? jTableHeader.getComponentOrientation().isLeftToRight() : jTable.getComponentOrientation().isLeftToRight();
        if (bl) {
            n3 = point.x < n4 ? n2 - 1 : n2;
        } else {
            int n5 = n3 = point.x < n4 ? n2 : n2 - 1;
        }
        if (n3 == -1) {
            return new TableColumn[0];
        }
        if (this.\u0102) {
            int n6;
            int n7;
            NestedTableHeader nestedTableHeader;
            CellSpan cellSpan2;
            if (jTableHeader instanceof NestedTableHeader && (cellSpan2 = (nestedTableHeader = (NestedTableHeader)jTableHeader).getCellSpanAt(n7 = point.y / (n6 = nestedTableHeader.getSize().height / nestedTableHeader.getRowCount()), n3)) != null && cellSpan2.getColumnSpan() != 1) {
                int n8 = cellSpan2.getColumnSpan();
                TableColumn[] tableColumnArray = new TableColumn[n8];
                int n9 = cellSpan2.getColumn();
                for (int i2 = 0; i2 < n8; ++i2) {
                    tableColumnArray[i2] = jTableHeader.getColumnModel().getColumn(n9 + i2);
                }
                return tableColumnArray;
            }
            TableColumn[] tableColumnArray = new TableColumn[]{jTableHeader.getColumnModel().getColumn(n3)};
            return tableColumnArray;
        }
        if (jTable instanceof CellSpanTable && ((CellSpanTable)jTable).isCellSpanOn() && (cellSpan = ((CellSpanTable)jTable).getCellSpanAt(this.\u0101.rowAtPoint(point), n3)) != null && cellSpan.getColumnSpan() > 1) {
            int n10 = cellSpan.getColumnSpan();
            TableColumn[] tableColumnArray = new TableColumn[n10];
            int n11 = cellSpan.getColumn();
            for (int i3 = 0; i3 < n10; ++i3) {
                tableColumnArray[i3] = this.\u0101.getColumnModel().getColumn(n11 + i3);
            }
            return tableColumnArray;
        }
        TableColumn[] tableColumnArray = new TableColumn[]{this.\u0101.getColumnModel().getColumn(n3)};
        return tableColumnArray;
    }
}

