/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.render.A;
import com.jidesoft.chart.render.AbstractPieSegmentRenderer;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.render.PieLabelRenderer2D;
import com.jidesoft.chart.render.PieSegmentRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Positionable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ListSelectionModel;

public class Pie3DRenderer
extends AbstractPieSegmentRenderer
implements PieSegmentRenderer2D {
    private final ColorFactory \u012e = new ColorFactory();
    private float \u012f = 0.2f;

    public float getThicknessRatio() {
        return this.\u012f;
    }

    public void setThicknessRatio(float f2) {
        this.\u012f = f2;
    }

    public float[] getSpotlightRatios() {
        return A.\u010c;
    }

    public void setSpotlightRatios(float[] fArray) {
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Supplied Ratios must be an array of length 4");
        }
        for (float f2 : fArray) {
            if (!(f2 < 0.0f) && !(f2 > 1.0f)) continue;
            throw new IllegalArgumentException("Supplied ratio must be between 0 and 1");
        }
        A.\u010c = fArray;
    }

    private float \u0101(Graphics graphics, Chart chart, ChartStyle chartStyle) {
        float f2;
        float f3;
        Insets insets = chart.getInsets();
        int n2 = graphics.getFontMetrics().getHeight();
        float f4 = chartStyle.getPieExplosionRatio();
        int n3 = chart.titleHeight();
        int n4 = this.getTickLength();
        int n5 = chart.getWidth() - insets.left - insets.right;
        int n6 = chart.getHeight() - insets.top - insets.bottom - n4 - 2 * n2 - n3;
        if ((double)n6 < (double)(f3 = (float)n5) * 0.67 + (double)(f3 * this.\u012f) && (f2 = ((float)n6 - (float)n6 * this.\u012f) / 0.67f) < f3) {
            f3 = f2;
        }
        f2 = chart.isSelectionShowsExplodedSegments() || chartStyle.isPieSegmentsAlwaysExploded() ? 2.0f * (1.0f + f4) : 2.0f;
        float f5 = f3 / f2;
        return f5;
    }

    @Override
    public void renderSegments(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, float f2, float[] fArray) {
        Object object6;
        Object object2;
        int n2;
        Object object3;
        if (chart == null) {
            throw new IllegalArgumentException("chart should not be null!");
        }
        ChartStyle chartStyle = chart.getStyle(chartModel) == null ? new ChartStyle() : chart.getStyle(chartModel);
        HashMap<Object, Float> hashMap = new HashMap<Object, Float>();
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.blue);
        }
        float f3 = chartStyle.getPieOffsetAngle();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            boolean bl;
            Object object4;
            object3 = chartModel.getPoint(i2);
            Highlight highlight = null;
            if (object3 instanceof Highlightable) {
                highlight = ((Highlightable)object3).getHighlight();
            }
            Positionable positionable = object3.getX();
            if (highlight == null && positionable instanceof ChartCategory) {
                object4 = (ChartCategory)positionable;
                highlight = ((ChartCategory)object4).getHighlight();
            }
            object4 = chart.getSelectionsForModel(chartModel);
            n2 = object4.isSelectedIndex(i2);
            float f4 = fArray[i2];
            ChartStyle chartStyle2 = chart.getStyle(chartModel);
            Object object5 = object2 = chartStyle2 == null ? Color.gray : chartStyle2.getBarPaint();
            if (highlight != null && (chartStyle2 = chart.getHighlightStyle(highlight)) != null) {
                object2 = chartStyle2.getBarPaint();
            }
            boolean bl2 = bl = chart.isRolloverEnabled() && object3.equals(chart.getCurrentChartPoint());
            if (bl) {
                if (object2 instanceof Color) {
                    object2 = ColorFactory.intensify2((Color)object2, 50);
                } else if (object2 instanceof TexturePaint) {
                    object2 = this.modify((TexturePaint)object2);
                }
            }
            graphics2D.setPaint((Paint)object2);
            if (object2 == null) {
                object2 = this.\u012e.create();
            }
            if (f4 == 360.0f && fArray.length == 1) {
                object6 = new A((Chartable)object3, f3, f4, (Paint)object2);
                ((A)object6).\u0102(f3);
                ((A)object6).\u0104(f4);
                ((A)object6).\u0102(i2);
                ((A)object6).\u0101(n2 != 0);
                arrayList.add(object6);
            } else if (A.\u0101(f3, f4) && A.\u0103(f3, f4)) {
                if (A.\u0107(f3) || A.\u0101(f3)) {
                    object6 = new A((Chartable)object3, f3, 180.0f, (Paint)object2);
                    ((A)object6).\u0102(f3);
                    ((A)object6).\u0104(f4);
                    ((A)object6).\u0102(false);
                    ((A)object6).\u0102(i2);
                    ((A)object6).\u0101(n2 != 0);
                    float f5 = f3 + 180.0f;
                    if (f5 >= 360.0f) {
                        f5 -= 360.0f;
                    }
                    A a2 = new A((Chartable)object3, f5, f4 - 180.0f, (Paint)object2);
                    a2.\u0102(true);
                    a2.\u0102(f3);
                    a2.\u0104(f4);
                    a2.\u0102(i2);
                    a2.\u0101(n2 != 0);
                    arrayList.add(object6);
                    arrayList.add(a2);
                    float f6 = f3 + f4 / 2.0f;
                    hashMap.put(object6, Float.valueOf(f6));
                    hashMap.put(a2, Float.valueOf(f6));
                } else {
                    object6 = new A((Chartable)object3, f3 + f4 - 180.0f, 180.0f, (Paint)object2);
                    ((A)object6).\u0102(f3);
                    ((A)object6).\u0104(f4);
                    ((A)object6).\u0102(false);
                    ((A)object6).\u0102(i2);
                    ((A)object6).\u0101(n2 != 0);
                    A a3 = new A((Chartable)object3, f3, f4 - 180.0f, (Paint)object2);
                    a3.\u0102(true);
                    a3.\u0102(f3);
                    a3.\u0104(f4);
                    a3.\u0102(i2);
                    a3.\u0101(n2 != 0);
                    arrayList.add(object6);
                    arrayList.add(a3);
                    float f7 = f3 + f4 / 2.0f;
                    hashMap.put(object6, Float.valueOf(f7));
                    hashMap.put(a3, Float.valueOf(f7));
                }
            } else {
                object6 = new A((Chartable)object3, f3, f4, (Paint)object2);
                ((A)object6).\u0102(f3);
                ((A)object6).\u0104(f4);
                ((A)object6).\u0102(i2);
                ((A)object6).\u0101(n2 != 0);
                arrayList.add(object6);
            }
            f3 += f4;
            if (!(f3 >= 360.0f)) continue;
            f3 -= 360.0f;
        }
        Collections.sort(arrayList);
        f2 = this.\u0101(graphics2D, chart, chartStyle);
        float f8 = 2.0f * f2;
        object3 = chart.getInsets();
        int n3 = chart.getWidth() - ((Insets)object3).left - ((Insets)object3).right;
        if (f8 > (float)n3) {
            f8 = n3;
        }
        int n4 = (int)f8;
        float f9 = f8 * this.\u012f;
        n2 = (int)(0.67 * (double)f8);
        int n5 = (int)((double)(this.\u012f * (float)n4) / 2.0);
        int n6 = (int)((double)(this.\u012f * (float)n2) / 2.0);
        object2 = new Point2D.Double(point2D.getX(), point2D.getY() - (double)f9 / 2.0);
        for (Object object6 : arrayList) {
            ((A)object6).\u0101((int)f9);
            Float f10 = (Float)hashMap.get(object6);
            float f11 = f10 == null ? ((A)object6).\u0102() : f10.floatValue();
            int n7 = chartStyle.isPieSegmentsAlwaysExploded() || ((A)object6).\u0104() && chart.isSelectionShowsExplodedSegments() ? (int)((double)n5 * Math.cos(A.\u0101((double)f11))) : 0;
            int n8 = chartStyle.isPieSegmentsAlwaysExploded() || ((A)object6).\u0104() && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n6 * Math.sin(A.\u0101((double)f11)))) : 0;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n7, n8);
            graphics2D.transform(affineTransform);
            ((A)object6).\u0101(graphics2D, (Point2D)object2, n4, n2);
            for (Shape shape : ((A)object6).\u0103()) {
                PointDescriptor pointDescriptor = new PointDescriptor(((A)object6).\u0107(), ((A)object6).\u0108(), chartModel);
                this.recordSegment(affineTransform.createTransformedShape(shape), pointDescriptor);
            }
            graphics2D.translate(-n7, -n8);
        }
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines2D(false, graphics2D, chart, chartModel, (Point2D)object2, n4, n2, fArray, chartStyle);
        }
        this.renderOutlines2D(true, graphics2D, chart, chartModel, (Point2D)object2, n4, n2, fArray, chartStyle);
        PieLabelRenderer pieLabelRenderer = this.getPieLabelRenderer();
        if (pieLabelRenderer != null) {
            if (pieLabelRenderer instanceof PieLabelRenderer2D) {
                object6 = (PieLabelRenderer2D)pieLabelRenderer;
                Graphics2D graphics2D2 = (Graphics2D)this.getLabelGraphics();
                object6.renderLabels(graphics2D2 == null ? graphics2D : graphics2D2, chart, chartModel, (Point2D)object2, (double)n4, (double)n2, fArray, chartStyle);
            } else {
                throw new IllegalStateException("To use a PieSegmentRenderer2D, you must also use a PieLabelRenderer2D");
            }
        }
    }

    @Override
    public void renderSegments(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n2, int[] nArray) {
        int n3;
        Comparable<A> comparable;
        Object object;
        Object object2;
        int n4;
        int n5;
        int n6;
        if (chart == null) {
            throw new IllegalArgumentException("chart should not be null!");
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChartStyle chartStyle = chart.getStyle(chartModel) == null ? new ChartStyle() : chart.getStyle(chartModel);
        HashMap<Comparable<A>, Integer> hashMap = new HashMap<Comparable<A>, Integer>();
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.blue);
        }
        float f2 = chartStyle.getPieOffsetAngle();
        ArrayList<Comparable<A>> arrayList = new ArrayList<Comparable<A>>();
        for (n6 = 0; n6 < nArray.length; ++n6) {
            boolean bl;
            Chartable chartable = chartModel.getPoint(n6);
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            n5 = listSelectionModel.isSelectedIndex(n6);
            n4 = nArray[n6];
            ChartStyle chartStyle2 = chart.getStyle(chartModel);
            object2 = chartStyle2 == null ? Color.gray : chartStyle2.getBarPaint();
            object = ((ChartPoint)chartable).getHighlight();
            if (object != null && (chartStyle2 = chart.getHighlightStyle((Highlight)object)) != null) {
                object2 = chartStyle2.getBarPaint();
            }
            boolean bl2 = bl = chart.isRolloverEnabled() && chartable.equals(chart.getCurrentChartPoint());
            if (bl) {
                if (object2 instanceof Color) {
                    object2 = ColorFactory.intensify2((Color)object2, 50);
                } else if (object2 instanceof TexturePaint) {
                    object2 = this.modify((TexturePaint)object2);
                }
            }
            graphics2D.setPaint((Paint)object2);
            if (object2 == null) {
                object2 = this.\u012e.create();
            }
            if (f2 == 0.0f && n4 == 360 && nArray.length == 1) {
                comparable = new A(chartable, f2, n4, (Paint)object2);
                ((A)comparable).\u0102(f2);
                ((A)comparable).\u0104(n4);
                ((A)comparable).\u0102(n6);
                ((A)comparable).\u0101(n5 != 0);
                arrayList.add(comparable);
            } else if (A.\u0101(f2, n4) && A.\u0103(f2, n4)) {
                comparable = new A(chartable, f2, 90.0f, (Paint)object2);
                ((A)comparable).\u0102(f2);
                ((A)comparable).\u0104(n4);
                ((A)comparable).\u0102(false);
                ((A)comparable).\u0102(n6);
                ((A)comparable).\u0101(n5 != 0);
                A a2 = new A(chartable, f2 + 90.0f, n4 - 90, (Paint)object2);
                a2.\u0102(true);
                a2.\u0102(f2);
                a2.\u0104(n4);
                a2.\u0102(n6);
                a2.\u0101(n5 != 0);
                arrayList.add(comparable);
                arrayList.add(a2);
                n3 = (int)(f2 + (float)(n4 / 2));
                hashMap.put(comparable, n3);
                hashMap.put(a2, n3);
            } else {
                comparable = new A(chartable, f2, n4, (Paint)object2);
                ((A)comparable).\u0102(f2);
                ((A)comparable).\u0104(n4);
                ((A)comparable).\u0102(n6);
                ((A)comparable).\u0101(n5 != 0);
                arrayList.add(comparable);
            }
            f2 += (float)n4;
        }
        Collections.sort(arrayList);
        n2 = (int)this.\u0101(graphics2D, chart, chartStyle);
        int n7 = n6 = 2 * n2;
        int n8 = (int)((float)n6 * this.\u012f);
        n5 = (int)(0.67 * (double)n6);
        n4 = (int)(this.\u012f * (float)n7 / 2.0f);
        int n9 = (int)(this.\u012f * (float)n5 / 2.0f);
        object2 = new Point(point.x, point.y - n8 / 2);
        for (A a3 : arrayList) {
            a3.\u0101(n8);
            comparable = (Integer)hashMap.get(a3);
            float f3 = comparable == null ? a3.\u0102() : (float)((Integer)comparable).intValue();
            n3 = a3.\u0104() && chart.isSelectionShowsExplodedSegments() ? (int)((double)n4 * Math.cos(A.\u0101((double)f3))) : 0;
            int n10 = a3.\u0104() && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n9 * Math.sin(A.\u0101((double)f3)))) : 0;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n3, n10);
            graphics2D.transform(affineTransform);
            a3.\u0101(graphics, (Point2D)object2, n7, n5);
            for (Shape shape : a3.\u0103()) {
                PointDescriptor pointDescriptor = new PointDescriptor(a3.\u0107(), a3.\u0108(), chartModel);
                this.recordSegment(affineTransform.createTransformedShape(shape), pointDescriptor);
            }
            graphics.translate(-n3, -n10);
        }
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines(false, graphics2D, chart, chartModel, (Point)object2, n7, n5, nArray, chartStyle);
        }
        this.renderOutlines(true, graphics2D, chart, chartModel, (Point)object2, n7, n5, nArray, chartStyle);
        object = this.getPieLabelRenderer();
        if (object != null) {
            Graphics2D graphics2D2 = (Graphics2D)this.getLabelGraphics();
            object.renderLabels(graphics2D2 == null ? graphics : graphics2D2, chart, chartModel, (Point)object2, n7, n5, nArray, chartStyle);
        }
    }

    protected void renderOutlines(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point point, int n2, int n3, int[] nArray, ChartStyle chartStyle) {
        int n4 = point.x;
        int n5 = point.y;
        int n6 = n4 - n2 / 2;
        int n7 = n5 - n3 / 2;
        float f2 = chartStyle.getPieOffsetAngle();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            float f3 = f2 + (float)(nArray[i2] / 2);
            int n8 = (int)(0.2 * (double)n2 / 2.0);
            int n9 = (int)(0.2 * (double)n3 / 2.0);
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i2);
            int n10 = bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n8 * Math.cos(A.\u0101((double)f3))) : 0;
            int n11 = bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n9 * Math.sin(A.\u0101((double)f3)))) : 0;
            graphics2D.translate(n10, n11);
            if (this.isAlwaysShowOutlines() && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                graphics2D.drawLine(n4, n5, (int)Math.round((double)n4 + (double)(n2 / 2) * Math.cos(Math.toRadians(f2))), (int)Math.round((double)n5 - (double)(n3 / 2) * Math.sin(Math.toRadians(f2))));
                graphics2D.drawArc(n6, n7, n2, n3, (int)f2, nArray[i2]);
                graphics2D.drawLine(n4, n5, (int)Math.round((double)n4 + (double)(n2 / 2) * Math.cos(Math.toRadians(f2 += (float)nArray[i2]))), (int)Math.round((double)n5 - (double)(n3 / 2) * Math.sin(Math.toRadians(f2))));
            } else {
                f2 += (float)nArray[i2];
            }
            graphics2D.translate(-n10, -n11);
        }
    }

    protected void renderOutlines2D(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, int n2, int n3, float[] fArray, ChartStyle chartStyle) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = d2 - (double)(n2 / 2);
        double d5 = d3 - (double)(n3 / 2);
        float f2 = chartStyle.getPieOffsetAngle();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f3 = f2 + fArray[i2] / 2.0f;
            int n4 = (int)(this.\u012f * (float)n2 / 2.0f);
            int n5 = (int)(this.\u012f * (float)n3 / 2.0f);
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i2);
            int n6 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n4 * Math.cos(A.\u0101((double)f3))) : 0;
            int n7 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n5 * Math.sin(A.\u0101((double)f3)))) : 0;
            graphics2D.translate(n6, n7);
            if (this.isAlwaysShowOutlines() && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                Line2D.Double double_ = new Line2D.Double(d2, d3, d2 + (double)(n2 / 2) * Math.cos(Math.toRadians(f2)), d3 - (double)(n3 / 2) * Math.sin(Math.toRadians(f2)));
                graphics2D.draw(double_);
                Arc2D.Double double_2 = new Arc2D.Double(d4, d5, n2, n3, f2, fArray[i2], 0);
                graphics2D.draw(double_2);
                Line2D.Double double_3 = new Line2D.Double(d2, d3, d2 + (double)(n2 / 2) * Math.cos(Math.toRadians(f2 += fArray[i2])), d3 - (double)(n3 / 2) * Math.sin(Math.toRadians(f2)));
                graphics2D.draw(double_3);
            } else {
                f2 += fArray[i2];
            }
            graphics2D.translate(-n6, -n7);
        }
    }
}

