/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LabelPlacement;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.range.NumericRange;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.Map;

public class RectangularRegionMarker
implements Drawable,
Frontable,
ZOrder {
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_PAINT = "Paint";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_X_INTERVAL = "X Interval";
    public static final String PROPERTY_Y_INTERVAL = "Y Interval";
    public static final String PROPERTY_LABEL = "Label";
    public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";
    public static final String PROPERTY_LABEL_COLOR = "Label Color";
    public static final String PROPERTY_LABEL_FONT = "Label Font";
    public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";
    public static final String PROPERTY_OUTLINE_STROKE = "Outline Stroke";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Chart \u0198;
    private Paint \u019a = new Color(255, 0, 0, 128);
    private NumericRange \u0191;
    private NumericRange \u0199;
    private boolean \u0192 = true;
    private boolean \u0197 = false;
    private String \u0196;
    private LabelPlacement \u0190;
    private Color \u019d;
    private Font \u0195;
    private Color \u019e;
    private Stroke \u019c = new BasicStroke(1.0f);
    private static final int \u0194 = 4;
    private int \u018f = 100;
    private RenderingHints \u0193 = null;

    public RectangularRegionMarker() {
    }

    public RectangularRegionMarker(Chart chart) {
        this.\u0198 = chart;
    }

    public RectangularRegionMarker(Chart chart, double d2, double d3, double d4, double d5, Paint paint) {
        this.\u0198 = chart;
        this.\u019a = paint;
        assert (d3 >= d2);
        this.setXInterval(d2, d3);
        assert (d5 >= d4);
        this.setYInterval(d4, d5);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.\u0198;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.\u0198;
        this.\u0198 = chart;
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.\u0193 == null) {
            this.\u0193 = new RenderingHints(key, object);
        } else {
            this.\u0193.put(key, object);
        }
    }

    public boolean isVisible() {
        return this.\u0192;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.\u0192;
        this.\u0192 = bl;
        this.support.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public Color getColor() {
        if (this.\u019a instanceof Color) {
            return (Color)this.\u019a;
        }
        return null;
    }

    public void setColor(Color color) {
        Paint paint = this.\u019a;
        this.\u019a = color;
        if (this.\u0198 != null) {
            this.\u0198.repaint();
        }
        this.support.firePropertyChange(PROPERTY_COLOR, paint, color);
    }

    public Paint getPaint() {
        return this.\u019a;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.\u019a;
        this.\u019a = paint;
        if (this.\u0198 != null) {
            this.\u0198.repaint();
        }
        this.support.firePropertyChange(PROPERTY_PAINT, paint2, paint);
    }

    public NumericRange getXInterval() {
        return this.\u0191;
    }

    public NumericRange getYInterval() {
        return this.\u0199;
    }

    public void setXInterval(double d2, double d3) {
        NumericRange numericRange = this.\u0191;
        this.\u0191 = new NumericRange(d2, d3);
        if (this.\u0198 != null) {
            this.\u0198.repaint();
        }
        this.support.firePropertyChange(PROPERTY_X_INTERVAL, numericRange, this.\u0191);
    }

    public void setYInterval(double d2, double d3) {
        NumericRange numericRange = this.\u0199;
        this.\u0199 = new NumericRange(d2, d3);
        if (this.\u0198 != null) {
            this.\u0198.repaint();
        }
        this.support.firePropertyChange(PROPERTY_Y_INTERVAL, numericRange, this.\u0199);
    }

    public String getLabel() {
        return this.\u0196;
    }

    public void setLabel(String string) {
        String string2 = this.\u0196;
        this.\u0196 = string;
        this.support.firePropertyChange(PROPERTY_LABEL, string2, string);
    }

    public LabelPlacement getLabelPlacement() {
        return this.\u0190;
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        LabelPlacement labelPlacement2 = this.\u0190;
        this.\u0190 = labelPlacement;
        this.support.firePropertyChange(PROPERTY_LABEL_PLACEMENT, (Object)labelPlacement2, (Object)labelPlacement);
    }

    public Color getLabelColor() {
        return this.\u019d;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.\u019d;
        this.\u019d = color;
        this.support.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Font getLabelFont() {
        return this.\u0195;
    }

    public void setLabelFont(Font font) {
        Font font2 = this.\u0195;
        this.\u0195 = font;
        this.support.firePropertyChange(PROPERTY_LABEL_FONT, font2, font);
    }

    public Color getOutlineColor() {
        return this.\u019e;
    }

    @Override
    public int getZOrder() {
        return this.\u018f;
    }

    @Override
    public void setZOrder(int n2) {
        this.\u018f = n2;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.\u019e;
        this.\u019e = color;
        this.support.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, color);
    }

    public Stroke getOutlineStroke() {
        return this.\u019c;
    }

    private float \u0104() {
        if (this.\u019c == null) {
            return 0.0f;
        }
        if (this.\u019c instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.\u019c;
            return basicStroke.getLineWidth();
        }
        return 0.0f;
    }

    public void setOutlineStroke(Stroke stroke) {
        Stroke stroke2 = this.\u019c;
        this.\u019c = stroke;
        this.support.firePropertyChange(PROPERTY_OUTLINE_STROKE, stroke2, stroke);
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.\u0198 == null || this.\u0191 == null || this.\u0199 == null) {
            return;
        }
        if (this.\u0192) {
            if (this.\u0193 != null) {
                for (Map.Entry object2 : this.\u0193.entrySet()) {
                    RenderingHints.Key d2 = (RenderingHints.Key)object2.getKey();
                    graphics2D.setRenderingHint(d2, object2.getValue());
                }
            }
            Axis axis = this.\u0198.getXAxis();
            Axis axis2 = this.\u0198.getYAxis();
            double d2 = axis.isFlipped() ? this.\u0191.getMax() : this.\u0191.getMin();
            double d3 = axis.isFlipped() ? this.\u0191.getMin() : this.\u0191.getMax();
            double d4 = axis2.isFlipped() ? this.\u0199.getMax() : this.\u0199.getMin();
            double d5 = axis2.isFlipped() ? this.\u0199.getMin() : this.\u0199.getMax();
            Point point = this.\u0198.calculatePixelPoint(new Point2D.Double(d2, d4));
            Point point2 = this.\u0198.calculatePixelPoint(new Point2D.Double(d3, d5));
            graphics2D.setPaint(this.\u019a);
            assert (point2.x >= point.x);
            BigDecimal bigDecimal = new BigDecimal(point2.x).subtract(new BigDecimal(point.x));
            BigDecimal bigDecimal2 = new BigDecimal(point.y).subtract(new BigDecimal(point2.y));
            Rectangle2D.Double double_ = new Rectangle2D.Double(point.x, point2.y, bigDecimal.doubleValue(), bigDecimal2.doubleValue());
            Shape shape = graphics2D.getClip();
            Rectangle rectangle = shape == null ? new Rectangle(0, 0, 0, 0) : shape.getBounds();
            float f2 = this.\u0104();
            double d6 = Math.max((double)((float)rectangle.x - f2), double_.getMinX());
            double d7 = rectangle.getMaxY() + (double)f2;
            double d8 = double_.getMaxY();
            double d9 = Math.min(d7, d8);
            double d10 = Math.min(rectangle.getMaxX() + (double)f2, double_.getMaxX());
            double d11 = Math.max(rectangle.getMinY() - (double)f2, double_.getMinY());
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d6, d11, d10 - d6, d9 - d11);
            graphics2D.fill(double_2);
            if (this.\u019e != null && this.\u019c != null) {
                graphics2D.setColor(this.\u019e);
                graphics2D.setStroke(this.\u019c);
                graphics2D.draw(double_2);
            }
            if (this.\u0196 != null) {
                this.\u0103(graphics2D, this.\u0196, point.x, point2.y, point2.x - point.x, point.y - point2.y);
            }
        }
        graphics2D.dispose();
    }

    private void \u0103(Graphics2D graphics2D, String string, int n2, int n3, int n4, int n5) {
        if (this.\u0195 != null) {
            graphics2D.setFont(this.\u0195);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n6 = fontMetrics.stringWidth(string);
        int n7 = fontMetrics.getHeight();
        int n8 = fontMetrics.getAscent();
        int n9 = n2 + n4;
        int n10 = n3 + n5;
        int n11 = this.\u0190 == LabelPlacement.WEST || this.\u0190 == LabelPlacement.NORTH_WEST || this.\u0190 == LabelPlacement.SOUTH_WEST ? n2 + 4 : (this.\u0190 == LabelPlacement.EAST || this.\u0190 == LabelPlacement.NORTH_EAST || this.\u0190 == LabelPlacement.SOUTH_EAST ? n9 - n6 - 4 : n2 + n4 / 2 - n6 / 2);
        int n12 = this.\u0190 == LabelPlacement.NORTH || this.\u0190 == LabelPlacement.NORTH_WEST || this.\u0190 == LabelPlacement.NORTH_EAST ? n3 + n7 : (this.\u0190 == LabelPlacement.SOUTH || this.\u0190 == LabelPlacement.SOUTH_EAST || this.\u0190 == LabelPlacement.SOUTH_WEST ? n3 + n5 - 4 : (n3 + n10) / 2 + n8 / 2);
        if (this.\u019d == null) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(this.\u019d);
        }
        graphics2D.drawString(string, n11, n12);
    }

    @Override
    public boolean isAtFront() {
        return this.\u0197;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.\u0197;
        this.\u0197 = bl;
        this.support.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }
}

