/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.TimeoutException;
import com.exasol.jdbc.Translator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;

class Header {
    final EXAConnection connection;
    private int size = 0;
    private byte mode = (byte)-1;
    private Vector attributes;
    private int serialNumber = -1;
    private int numberOfResults;
    private int sizeOfAttributes;
    static final int VMU = 64;
    private DebugLog debug;

    Header(EXAConnection eXAConnection, DebugLog debugLog, int n) {
        this.connection = eXAConnection;
        this.attributes = new Vector();
        this.debug = debugLog;
        this.serialNumber = n;
    }

    Header(Header header) {
        this.connection = header.connection;
        this.attributes = new Vector();
        this.debug = header.debug;
        this.serialNumber = header.serialNumber;
    }

    private void log(Object object) {
        if (this.debug != null) {
            this.debug.log(object.toString());
        }
    }

    synchronized InputStream read_from(InputStream inputStream, int n) throws SQLException, IOException {
        Object object;
        EXAInputStream eXAInputStream = new EXAInputStream(inputStream, this.connection);
        long l = System.currentTimeMillis();
        if (0 < n && 0 == eXAInputStream.available() && this.connection.getActiveProtocolVersion() > 8) {
            while (0 == eXAInputStream.available()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    throw new SQLException(interruptedException.toString(), "08006");
                }
                boolean bl = this.connection.csocket.getKeepAlive();
                if (!bl) {
                    throw new SQLException(Translator.Connection_lost(), "08006");
                }
                if (!this.connection.csocket.isConnected()) {
                    throw new SQLException(Translator.Connection_lost(), "08006");
                }
                if (this.connection.csocket.isClosed()) {
                    throw new SQLException(Translator.Connection_lost(), "08006");
                }
                if (this.connection.csocket.isInputShutdown()) {
                    throw new SQLException(Translator.Connection_lost(), "08006");
                }
                if (this.connection.csocket.isOutputShutdown()) {
                    throw new SQLException(Translator.Connection_lost(), "08006");
                }
                long l2 = System.currentTimeMillis();
                if (l2 < l + (long)n) continue;
                this.log("Header.read_from(InputStream, " + n + ") throwing TimeoutException");
                this.log("    current=" + l2 + " previous=" + l);
                throw new TimeoutException(Translator.Server_response_timeout_exceded() + " (" + n + " milliseconds)");
            }
        }
        byte[] byArray = new byte[21];
        eXAInputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EXAInputStream eXAInputStream2 = new EXAInputStream(byteArrayInputStream, this.connection);
        this.size = eXAInputStream2.readInt();
        if (this.size < 0) {
            throw new ProtocolException("Message size negative: " + this.size);
        }
        this.mode = eXAInputStream2.readByte();
        this.serialNumber = eXAInputStream2.readInt();
        int n2 = eXAInputStream2.readInt();
        this.sizeOfAttributes = eXAInputStream2.readInt();
        this.numberOfResults = eXAInputStream2.readInt();
        byte[] byArray2 = new byte[this.size];
        eXAInputStream.read(byArray2);
        byte[] byArray3 = new byte[this.sizeOfAttributes];
        System.arraycopy(byArray2, 0, byArray3, 0, this.sizeOfAttributes);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray3);
        EXAInputStream eXAInputStream3 = new EXAInputStream(byteArrayInputStream2, this.connection);
        try {
            for (int i = 0; i < n2; ++i) {
                object = eXAInputStream3.readAttribute();
                this.attributes.add(object);
                this.log("Attribute of message #" + this.serialNumber + ": " + object);
            }
        }
        catch (Exception exception) {
            throw new ProtocolException(exception.getMessage());
        }
        byte[] byArray4 = new byte[this.size - this.sizeOfAttributes];
        System.arraycopy(byArray2, this.sizeOfAttributes, byArray4, 0, this.size - this.sizeOfAttributes);
        object = new ByteArrayInputStream(byArray4);
        this.size -= this.sizeOfAttributes;
        this.log("Header.read_from(InputStream, " + n + ") serialNumber: " + this.serialNumber + ", attrSize: " + this.sizeOfAttributes + ", numRes: " + this.numberOfResults + ", mode: " + this.mode + ", data_size: " + this.size);
        return object;
    }

    private String getStacktrace() {
        String string = "";
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            string = string + stackTraceElement + "\n";
        }
        return string;
    }

    void write_to(OutputStream outputStream) throws IOException, ConnectionException {
        int n;
        if (this.mode <= 0) {
            throw new ProtocolException("ProtocolException A0001 in Header.write_to:\n" + this.getStacktrace() + "mode=" + this.mode);
        }
        if (this.serialNumber < 0) {
            throw new ProtocolException("ProtocolException B0001 in Header.write_to:\n" + this.getStacktrace() + "serialNumber=" + this.serialNumber);
        }
        EXAOutputStream eXAOutputStream = new EXAOutputStream(outputStream, this.connection);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream2 = new EXAOutputStream(byteArrayOutputStream, this.connection);
        for (n = 0; n < this.attributes.size(); ++n) {
            ProtocolAttribute protocolAttribute = (ProtocolAttribute)this.attributes.get(n);
            eXAOutputStream2.writeAttribute(protocolAttribute);
        }
        eXAOutputStream2.flush();
        n = byteArrayOutputStream.size();
        if (this.mode <= 0) {
            throw new ProtocolException("ProtocolException A0002 in Header.write_to:\n" + this.getStacktrace() + "mode=" + this.mode);
        }
        if (this.serialNumber < 0) {
            throw new ProtocolException("ProtocolException B0002 in Header.write_to:\n" + this.getStacktrace() + "serialNumber=" + this.serialNumber);
        }
        eXAOutputStream.writeInt(n + this.size);
        eXAOutputStream.writeByte(this.mode);
        eXAOutputStream.writeInt(this.serialNumber);
        eXAOutputStream.writeInt(this.attributes.size());
        eXAOutputStream.writeInt(n);
        eXAOutputStream.writeInt(this.numberOfResults);
        eXAOutputStream.setHeader();
        eXAOutputStream.write(byteArrayOutputStream.toByteArray());
        this.log("Header.write_to(OutputStream) serialNumber: " + this.serialNumber + ", numAttr: " + this.attributes.size() + ", attrSize: " + n + ", numRes: " + this.numberOfResults + ", data_size: " + this.size + ", mode: " + this.mode);
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(int n) {
        this.numberOfResults = n;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int n) {
        this.serialNumber = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public void incSize(int n) {
        this.size += n;
    }

    public void addAttribute(ProtocolAttribute protocolAttribute) {
        this.attributes.addElement(protocolAttribute);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("*** Header no. ");
        stringBuffer.append(this.serialNumber);
        stringBuffer.append(" ***\n");
        stringBuffer.append("  message mode   : " + this.mode);
        stringBuffer.append('\n');
        stringBuffer.append("  result count   : " + this.numberOfResults);
        stringBuffer.append('\n');
        stringBuffer.append("  data size      : " + this.size);
        stringBuffer.append('\n');
        stringBuffer.append("  attribute count: " + this.attributes.size());
        stringBuffer.append('\n');
        stringBuffer.append("  attribute size : " + this.attributes.size());
        stringBuffer.append("\n ****************");
        return stringBuffer.toString();
    }
}

