/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Resources;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;

public class ValueInt
extends Value {
    private int value;

    public ValueInt(int value) {
        this.value = value;
    }

    public ValueInt(Object value) {
        this.value = value instanceof Number ? ((Number)value).intValue() : (value instanceof Boolean ? (Boolean.TRUE.equals(value) ? 1 : 0) : Integer.parseInt(value.toString()));
    }

    @Override
    int getType() {
        return 5;
    }

    @Override
    int getScale() {
        return 0;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws java.sql.SQLException {
        dataStream.encodeInt(this.getInt());
    }

    @Override
    String getString() {
        return ValueInt.getString(this.value, 0);
    }

    @Override
    String getZeroPaddedString(int numZeroes, SQLContext context) {
        return ValueInt.getString(this.value, 0, numZeroes);
    }

    @Override
    boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    byte getByte() throws java.sql.SQLException {
        int value = this.getInt();
        if (value < -128 || value > 127) {
            throw new SQLException(Resources.getMessage("error.byte.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (byte)value;
    }

    @Override
    short getShort() throws java.sql.SQLException {
        int value = this.getInt();
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new SQLException(Resources.getMessage("error.short.value.out.of.range", this.getString()), SQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return (short)value;
    }

    @Override
    int getInt() {
        return this.value;
    }

    @Override
    long getLong() {
        return this.getInt();
    }

    @Override
    double getDouble() {
        return this.getInt();
    }

    @Override
    float getFloat() {
        return this.getInt();
    }

    @Override
    BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.value, 0);
    }

    @Override
    Object getObject() {
        return this.getInt();
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.getInt());
    }
}

