/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.flatlaf;

import com.install4j.api.Util;
import com.install4j.api.laf.IndeterminateStateComponent;
import com.install4j.api.laf.LookAndFeelHandler;
import com.install4j.runtime.flatlaf.FlatWindowsNativeWindowBorder;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.InstallerLookAndFeelConfig;
import com.install4j.runtime.installer.config.laf.DarkModeStrategy;
import com.install4j.runtime.installer.config.laf.FlatLafDarkTheme;
import com.install4j.runtime.installer.config.laf.FlatLafLightTheme;
import com.install4j.shadow.com.formdev.flatlaf.FlatDarculaLaf;
import com.install4j.shadow.com.formdev.flatlaf.FlatDarkLaf;
import com.install4j.shadow.com.formdev.flatlaf.FlatIntelliJLaf;
import com.install4j.shadow.com.formdev.flatlaf.FlatLaf;
import com.install4j.shadow.com.formdev.flatlaf.FlatLightLaf;
import com.install4j.shadow.com.formdev.flatlaf.IntelliJTheme;
import com.install4j.shadow.com.formdev.flatlaf.ui.FlatNativeWindowBorder;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class FlatLafLookAndFeelHandler
implements LookAndFeelHandler {
    private FlatLaf lookAndFeel;

    public void applyLookAndFeel(boolean darkDesktop) throws Exception {
        FlatNativeWindowBorder.Provider instance;
        boolean disableWindowDecorations = true;
        if (Util.isWindows() && (instance = FlatWindowsNativeWindowBorder.getInstance()) != null) {
            FlatNativeWindowBorder.setNativeProvider(instance);
            disableWindowDecorations = false;
        }
        if (disableWindowDecorations) {
            System.setProperty("flatlaf.useWindowDecorations", "false");
        }
        FlatLaf.registerCustomDefaultsSource("com.install4j.shadow.com.formdev", this.getClass().getClassLoader());
        InstallerLookAndFeelConfig lafConfig = InstallerConfig.getCurrentInstance().getLookAndFeelConfig();
        boolean darkMode = this.isDarkModeUsed(lafConfig.getDarkModeStrategy(), darkDesktop);
        this.lookAndFeel = this.createLookAndFeel(darkMode);
        UIManager.setLookAndFeel(this.lookAndFeel);
    }

    public boolean isDarkModeSwitchingSupported() {
        return true;
    }

    public void setDark(boolean dark) {
        if (this.lookAndFeel.isDark() == dark) {
            return;
        }
        FlatLaf oldLookAndFeel = this.lookAndFeel;
        try {
            FlatLaf lookAndFeel;
            this.lookAndFeel = lookAndFeel = this.createLookAndFeel(dark);
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            this.lookAndFeel = oldLookAndFeel;
            Util.logError(null, (String)(dark ? "Error switch to dark mode" : "Error switching to light mode"));
            Util.log((Throwable)e);
            e.printStackTrace();
        }
    }

    public boolean isDark() {
        return this.lookAndFeel != null ? this.lookAndFeel.isDark() : false;
    }

    public boolean isWideTreeSelection() {
        return UIManager.getBoolean("Tree.wideSelection");
    }

    @NotNull
    public JCheckBox createTriStateCheckBox() {
        return new FlatLafTriStateCheckBox();
    }

    public void disableExtraSelectionPainting(JTree tree) {
        tree.putClientProperty("JTree.paintSelection", false);
    }

    @NotNull
    private FlatLaf createLookAndFeel(boolean darkMode) throws IOException {
        InstallerLookAndFeelConfig lafConfig = InstallerConfig.getCurrentInstance().getLookAndFeelConfig();
        if (darkMode) {
            FlatLafDarkTheme theme = lafConfig.getDarkTheme();
            switch (theme) {
                case DARK: {
                    return new FlatDarkLaf();
                }
                case DARCULA: {
                    return new FlatDarculaLaf();
                }
                case CUSTOM: {
                    return this.loadTheme(lafConfig.getCustomDarkThemeName());
                }
            }
            throw new IllegalStateException(theme.name());
        }
        FlatLafLightTheme theme = lafConfig.getLightTheme();
        switch (theme) {
            case LIGHT: {
                return new FlatLightLaf();
            }
            case LIGHT_INTELLIJ: {
                return new FlatIntelliJLaf();
            }
            case CUSTOM: {
                return this.loadTheme(lafConfig.getCustomLightThemeName());
            }
        }
        throw new IllegalStateException(theme.name());
    }

    private boolean isDarkModeUsed(DarkModeStrategy darkModeStrategy, boolean darkDesktop) {
        switch (darkModeStrategy) {
            case AUTO_DETECT: {
                return darkDesktop;
            }
            case ALWAYS_LIGHT: {
                return false;
            }
            case ALWAYS_DARK: {
                return true;
            }
        }
        throw new IllegalStateException(darkModeStrategy.name());
    }

    @NotNull
    private FlatLaf loadTheme(String themeName) throws IOException {
        return IntelliJTheme.createLaf(this.getClass().getResourceAsStream("/" + themeName));
    }

    private static class FlatLafTriStateCheckBox
    extends JCheckBox
    implements IndeterminateStateComponent {
        private FlatLafTriStateCheckBox() {
        }

        public void setIndeterminate(boolean indeterminate) {
            this.putClientProperty("JButton.selectedState", indeterminate ? "indeterminate" : null);
        }

        @Override
        public void setSelected(boolean selected) {
            this.setIndeterminate(false);
            super.setSelected(selected);
        }
    }
}

