/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.EnvironmentUtil;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.launching.DirectOutputRedirection;
import com.install4j.runtime.installer.helper.launching.InputRedirection;
import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.UncloseableInputStream;
import com.install4j.runtime.installer.helper.launching.UncloseableOutputStream;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class LaunchHelper {
    public static final long LAUNCH_EXIT_DELTA_TIME = 10000L;
    public static final int RETURN_VALUE_TIMEOUT = -10000;
    private static final char[] SPECIAL_BATCH_FILE_CHARACTERS = new char[]{' ', '&', '(', ')', '[', ']', '{', '}', '^', '=', ';', '!', '+', '`', '\u00b4', '~', '<', '>', '@', '|'};
    private static final char[] SPECIAL_ARGUMENTS_CHARACTERS = new char[]{' ', '&', '^', '`', '\u00b4', '<', '>', '@', '|'};
    public static final String PROPNAME_DEBUG_LAUNCH = "install4j.debugLaunch";
    private static final boolean DEBUG = Boolean.getBoolean("install4j.debugLaunch");
    public static final String PROPNAME_NO_SUID = "install4j.noSuid";
    private static long lastLaunchTime;

    public static long getLastLaunchTime() {
        return lastLaunchTime;
    }

    private LaunchHelper() {
    }

    public static boolean launchFinishExecutable(File launcherFile, String[] arguments, File workingDirectory, ExecutionContext executionContext) {
        Integer ret = Util.isWindows() || Util.isMacOS() ? LaunchHelper.launchApplication(new LaunchDescriptor(launcherFile).workingDirectory(workingDirectory).arguments(arguments).executionContext(executionContext)) : LaunchHelper.launchApplication(new LaunchDescriptor(new File("/bin/sh")).workingDirectory(workingDirectory).arguments("-c", "nohup \"" + (launcherFile.exists() ? launcherFile.getAbsolutePath() : launcherFile.getPath()) + "\" " + StringUtil.makeCommandLine(arguments) + " > /dev/null 2>&1"));
        if (ret != null) {
            lastLaunchTime = System.currentTimeMillis();
        }
        return ret != null;
    }

    public static Integer launchApplication(LaunchDescriptor launchDescriptor) {
        LaunchResult launchResult = LaunchHelper.launchApplicationWithResult(launchDescriptor);
        if (launchResult == null) {
            return null;
        }
        return launchResult.getReturnCode();
    }

    private static void syncPreferences() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new HelperCommunication.DirectRunAction(){

            @Override
            protected void run(Context context) throws Exception {
                if (!PreferencesUtil.isDisableSystemRoot()) {
                    try {
                        Preferences.systemRoot().sync();
                    }
                    catch (BackingStoreException backingStoreException) {
                        // empty catch block
                    }
                }
                try {
                    Preferences.userRoot().sync();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        });
    }

    public static LaunchResult launchApplicationWithResult(final LaunchDescriptor launchDescriptor) {
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        return helperCommunication.fetchObject(launchDescriptor.getExecutionContext(), new FetchObjectAction<LaunchResult>(){

            @Override
            protected LaunchResult fetchValue(Context context) throws Exception {
                return LaunchHelper.launchApplicationDirectly(launchDescriptor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LaunchResult launchApplicationDirectly(LaunchDescriptor launchDescriptor) {
        if (DEBUG) {
            Util.logInfo(null, launchDescriptor.toString());
        }
        File executable = launchDescriptor.getExecutable();
        Map<String, String> environment = LaunchHelper.getEnvironmentVariables(launchDescriptor.getSpecificEnvironmentVariables(), launchDescriptor.isIncludeParentEnvironmentVariables());
        try {
            if (executable == null) {
                Logger.getInstance().error(null, "executable is null");
                return null;
            }
            Process process = null;
            OutputStream outputRedirectStream = null;
            OutputStream errorRedirectStream = null;
            InputStream inputRedirectStream = null;
            LaunchResult launchResult = new LaunchResult();
            try {
                outputRedirectStream = LaunchHelper.createOutputStream(launchDescriptor.getUsedStdoutRedirection(), "stdout", launchResult, false);
                errorRedirectStream = LaunchHelper.createOutputStream(launchDescriptor.getUsedStderrRedirection(), "stderr", launchResult, true);
                inputRedirectStream = LaunchHelper.createInputStream(launchDescriptor.getUsedStdinRedirection());
            }
            catch (IOException e) {
                LaunchHelper.closeStreams(inputRedirectStream, outputRedirectStream, errorRedirectStream);
                return null;
            }
            if (InstallerUtil.isMacOS()) {
                process = LaunchHelper.launchOnMacOS(launchDescriptor);
            } else if (!executable.exists() || executable.isFile()) {
                launchDescriptor.useNohup(launchDescriptor.isUseNohup() && outputRedirectStream == null && errorRedirectStream == null && inputRedirectStream == null);
                String executablePath = executable.exists() ? executable.getAbsolutePath() : executable.getPath();
                process = Util.isWindows() && (executablePath.toLowerCase(Locale.ENGLISH).endsWith(".bat") || executablePath.toLowerCase(Locale.ENGLISH).endsWith(".cmd") || Util.isAtLeastWindowsVista() || launchDescriptor.isShowWindowsConsole()) ? LaunchHelper.launchOnWindows(launchDescriptor, executablePath, environment) : LaunchHelper.launchOtherwise(launchDescriptor, executablePath, environment);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                Logger.getInstance().error(null, "executable is not a file: " + executable);
            }
            if (process == null) {
                Logger.getInstance().error(LaunchHelper.class, "process could not be created");
                LaunchHelper.closeStreams(inputRedirectStream, outputRedirectStream, errorRedirectStream);
                return null;
            }
            if (launchDescriptor.getUsedStdoutRedirection() != null && launchDescriptor.getUsedStdoutRedirection().getRedirectionMode() != OutputRedirectionMode.INHERIT) {
                new ConsumerThread(process.getInputStream(), outputRedirectStream).start();
            }
            if (launchDescriptor.getUsedStderrRedirection() != null && launchDescriptor.getUsedStderrRedirection().getRedirectionMode() != OutputRedirectionMode.INHERIT) {
                new ConsumerThread(process.getErrorStream(), errorRedirectStream).start();
            }
            if (inputRedirectStream != null) {
                new WriterThread(process.getOutputStream(), inputRedirectStream, inputRedirectStream instanceof UncloseableInputStream).start();
            }
            if (launchDescriptor.isReceiveProcess()) {
                launchDescriptor.setProcess(process);
            }
            if (!launchDescriptor.isWait()) {
                return launchResult.returnCode(1);
            }
            boolean timeoutOccurred = true;
            try {
                int retVal = VersionSpecificHelper.waitForOrTerminate(process, launchDescriptor.getTimeout(), launchDescriptor.isTerminate());
                timeoutOccurred = retVal == -10000;
                LaunchHelper.syncPreferences();
                if (retVal != 0 && launchDescriptor.isLogReturnValue()) {
                    Logger.getInstance().info(LaunchHelper.class, "return value is " + retVal);
                }
                LaunchResult launchResult2 = launchResult.returnCode(retVal);
                return launchResult2;
            }
            catch (InterruptedException e) {
                Logger.getInstance().info(LaunchHelper.class, e.toString());
                e.printStackTrace();
                LaunchResult launchResult2 = null;
                return launchResult2;
            }
            finally {
                if (launchDescriptor.isWait() && launchDescriptor.isWaitForStreams() && !timeoutOccurred && !Util.isMacOS()) {
                    LaunchHelper.waitForStream(process.getInputStream());
                    LaunchHelper.waitForStream(process.getErrorStream());
                }
                LaunchHelper.closeStreams(inputRedirectStream, outputRedirectStream, errorRedirectStream);
            }
        }
        catch (IOException e2) {
            try {
                Logger.getInstance().error(LaunchHelper.class, e2.getMessage());
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void waitForStream(InputStream inputStream) {
        try {
            for (int i = 0; i < 10; ++i) {
                if (inputStream.available() <= 0) {
                    return;
                }
                Thread.sleep(100L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Process launchOnMacOS(LaunchDescriptor launchDescriptor) throws IOException {
        File executable = launchDescriptor.getExecutable();
        if ((executable = LaunchHelper.checkDmg(executable, launchDescriptor.isAttachWithNoBrowse())) == null) {
            return null;
        }
        if (executable.isDirectory()) {
            ArrayList<String> args = new ArrayList<String>();
            if (launchDescriptor.isReceiveProcess() || launchDescriptor.isWait()) {
                args.add("-W");
            }
            args.add(executable.getAbsolutePath());
            if (launchDescriptor.getArguments() != null) {
                args.add("--args");
                Collections.addAll(args, launchDescriptor.getArguments());
            }
            launchDescriptor.arguments(args.toArray(new String[0]));
            executable = new File("/usr/bin/open");
        }
        File scriptFile = LaunchHelper.createMacStartScript(launchDescriptor, executable);
        if (DEBUG) {
            Util.logInfo(null, "script file: " + scriptFile);
            Util.logInfo(null, "script file exists: " + scriptFile.exists());
            Util.logInfo(null, "script file contents: " + InstallerUtil.readTextFile(scriptFile, StandardCharsets.UTF_8.name()));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("/bin/sh");
        cmd.add(scriptFile.getAbsolutePath());
        Process process = LaunchHelper.createProcessBuilder(cmd, null, launchDescriptor).start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return process;
    }

    private static File createMacStartScript(LaunchDescriptor launchDescriptor, File executable) throws IOException {
        String[] arguments = launchDescriptor.getArguments();
        File scriptFile = File.createTempFile("i4j", ".sh", null);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(scriptFile)), StandardCharsets.UTF_8));
        pw.println("#!/bin/sh");
        if (launchDescriptor.getWorkingDirectory() != null) {
            pw.println("old_pwd=`pwd`");
            pw.println("cd \"" + launchDescriptor.getWorkingDirectory() + "\"");
        }
        if (launchDescriptor.getSpecificEnvironmentVariables() != null) {
            for (Map.Entry<String, String> entry : launchDescriptor.getSpecificEnvironmentVariables().entrySet()) {
                pw.println(InstallerVariables.replaceVariables(entry.getKey()) + "=\"" + InstallerVariables.replaceVariables(entry.getValue()) + "\"");
                pw.println("export " + entry.getKey());
            }
        }
        if (launchDescriptor.isSuidRoot() && (UnixUserInfo.ROOT_USER || HelperCommunication.getInstance().isElevatedHelper()) && Util.isMacOS()) {
            File elevationUtil;
            boolean fromService = Boolean.getBoolean("install4j.fromService");
            boolean noSuid = Boolean.getBoolean(PROPNAME_NO_SUID);
            Logger.getExistingInstance().info(null, "SUID elevation: " + !fromService + ", " + !noSuid);
            if (!fromService && !noSuid && (elevationUtil = InstallerUtil.getInstallerFile("install4j")).exists()) {
                pw.print("\"" + elevationUtil.getAbsolutePath() + "\" __i4j_setuid ");
            }
        }
        pw.print("\"" + executable.getAbsolutePath() + "\"");
        if (arguments != null) {
            for (String argument : arguments) {
                pw.print(" \"" + argument + "\"");
            }
        }
        pw.println();
        pw.println("exitCode=$?");
        if (launchDescriptor.getWorkingDirectory() != null) {
            pw.println("  cd \"$old_pwd\"");
        }
        pw.println("rm \"$0\"");
        pw.println("exit $exitCode");
        pw.close();
        return scriptFile;
    }

    private static Process launchOnWindows(LaunchDescriptor launchDescriptor, String executablePath, Map<String, String> environmentVariables) throws IOException {
        ArrayList<String> cmdArray = new ArrayList<String>();
        String shortPathName = executablePath;
        try {
            shortPathName = FolderInfo.getShortPathName(executablePath);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean showConsole = launchDescriptor.isShowWindowsConsole();
        if (showConsole || !LaunchHelper.isExe(launchDescriptor)) {
            Logger.getExistingInstance().info(null, "execute using batch file");
            try {
                cmdArray.add(new File(WinFileSystem.getSystemDirectory(), "cmd.exe").getAbsolutePath());
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
                cmdArray.add("cmd.exe");
            }
            cmdArray.add("/D");
            if (showConsole && launchDescriptor.isKeepConsoleWindow()) {
                cmdArray.add("/K");
            } else {
                cmdArray.add("/C");
            }
            File tempFile = LaunchHelper.createWindowsStartScript(launchDescriptor, shortPathName);
            cmdArray.add(tempFile.getAbsolutePath());
            if (showConsole) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("start \"");
                buffer.append(executablePath);
                buffer.append("\" /WAIT ");
                for (int i = 0; i < cmdArray.size(); ++i) {
                    String argument = (String)cmdArray.get(i);
                    if (LaunchHelper.needsQuotes(argument, false)) {
                        buffer.append('\"').append(argument).append('\"');
                    } else {
                        buffer.append(argument);
                    }
                    if (i >= cmdArray.size() - 1) continue;
                    buffer.append(" ");
                }
                return LaunchHelper.createProcessBuilder(Arrays.asList("cmd.exe", "/D", "/C", buffer.toString()), environmentVariables, launchDescriptor).start();
            }
            return LaunchHelper.createProcessBuilder(cmdArray, environmentVariables, launchDescriptor).start();
        }
        Logger.getExistingInstance().info(null, "execute directly");
        cmdArray.add(executablePath);
        String[] arguments = launchDescriptor.getArguments();
        if (arguments != null) {
            Collections.addAll(cmdArray, arguments);
        }
        return LaunchHelper.createProcessBuilder(cmdArray, environmentVariables, launchDescriptor).start();
    }

    private static File createWindowsStartScript(LaunchDescriptor launchDescriptor, String executablePath) throws IOException {
        File tempFile = File.createTempFile("i4j", ".bat");
        PrintWriter pw = new PrintWriter(new FileOutputStream(tempFile));
        pw.println("@ECHO OFF");
        pw.print("\"" + executablePath + "\"");
        boolean isExe = LaunchHelper.isExe(launchDescriptor);
        String[] arguments = launchDescriptor.getArguments();
        if (arguments != null) {
            for (String argument : arguments) {
                if (LaunchHelper.needsQuotes(argument = StringUtil.replace(argument, "%", "%%"), isExe)) {
                    pw.print(" \"" + argument + "\"");
                    continue;
                }
                pw.print(" " + argument);
            }
        }
        pw.println();
        pw.close();
        tempFile.deleteOnExit();
        return tempFile;
    }

    private static boolean isExe(LaunchDescriptor launchDescriptor) {
        return launchDescriptor.getExecutable().getName().toLowerCase(Locale.ENGLISH).endsWith(".exe");
    }

    private static boolean isAsciiOnly(String[] strings) {
        if (strings != null) {
            CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
            for (String string : strings) {
                if (charsetEncoder.canEncode(string)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean needsQuotes(String argument, boolean isExe) {
        if (argument.startsWith("\"")) {
            return false;
        }
        int charCount = argument.length();
        for (int i = 0; i < charCount; ++i) {
            char c = argument.charAt(i);
            if (c >= ' ' && c <= 'z' && Arrays.binarySearch(isExe ? SPECIAL_ARGUMENTS_CHARACTERS : SPECIAL_BATCH_FILE_CHARACTERS, c) < 0) continue;
            return true;
        }
        return false;
    }

    private static Process launchOtherwise(LaunchDescriptor launchDescriptor, String executablePath, Map<String, String> environment) throws IOException {
        ArrayList<String> cmdArray = new ArrayList<String>();
        if (launchDescriptor.isUseNohup()) {
            cmdArray.add("/bin/sh");
            cmdArray.add("-c");
            cmdArray.add("nohup \"" + executablePath + "\" " + StringUtil.makeCommandLine(launchDescriptor.getArguments()) + " > /dev/null 2>&1");
        } else {
            cmdArray.add(executablePath);
            String[] arguments = launchDescriptor.getArguments();
            if (arguments != null) {
                cmdArray.addAll(Arrays.asList(arguments));
            }
        }
        return LaunchHelper.createProcessBuilder(cmdArray, environment, launchDescriptor).start();
    }

    private static ProcessBuilder createProcessBuilder(List<String> cmdArray, Map<String, String> environment, LaunchDescriptor launchDescriptor) {
        ProcessBuilder processBuilder = new ProcessBuilder(cmdArray).directory(launchDescriptor.getWorkingDirectory());
        if (launchDescriptor.getUsedStdoutRedirection() != null && launchDescriptor.getUsedStdoutRedirection().getRedirectionMode() == OutputRedirectionMode.INHERIT) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        if (launchDescriptor.getUsedStderrRedirection() != null && launchDescriptor.getUsedStderrRedirection().getRedirectionMode() == OutputRedirectionMode.INHERIT) {
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        if (launchDescriptor.getUsedStdinRedirection() != null && launchDescriptor.getUsedStdinRedirection().getRedirectionMode() == InputRedirectionMode.INHERIT) {
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        }
        if (launchDescriptor.isRedirectErrorStream()) {
            processBuilder.redirectErrorStream(true);
        }
        if (environment != null) {
            Map<String, String> actualEnvironment = processBuilder.environment();
            actualEnvironment.clear();
            actualEnvironment.putAll(environment);
        }
        return processBuilder;
    }

    private static Map<String, String> getEnvironmentVariables(Map<String, String> specificEnvironmentVariables, boolean includeParentEnvironmentVariables) {
        String value;
        String name;
        if (specificEnvironmentVariables == null || specificEnvironmentVariables.isEmpty()) {
            if (includeParentEnvironmentVariables) {
                return null;
            }
            return Collections.emptyMap();
        }
        Map<String, String> parentVariables = System.getenv();
        Map<String, String> uppercaseParentVariables = EnvironmentUtil.getUpperCaseVariables(parentVariables);
        LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>();
        HashSet<String> processedNames = new HashSet<String>();
        boolean windows = InstallerUtil.isWindows();
        for (Map.Entry<String, String> entry : specificEnvironmentVariables.entrySet()) {
            name = InstallerVariables.replaceVariables(entry.getKey());
            value = InstallerVariables.replaceVariables(entry.getValue());
            processedNames.add(windows ? name.toUpperCase(Locale.ENGLISH) : name);
            environment.put(name, EnvironmentUtil.replaceEnvironmentVariables(value, windows ? uppercaseParentVariables : parentVariables));
        }
        if (includeParentEnvironmentVariables) {
            for (Map.Entry<String, String> entry : parentVariables.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                if (processedNames.contains(windows ? name.toUpperCase(Locale.ENGLISH) : name)) continue;
                environment.put(name, value);
            }
        }
        return environment;
    }

    public static File checkDmg(File executable, boolean noBrowse) throws IOException {
        if ((executable = executable.getCanonicalFile()).getName().endsWith(".dmg")) {
            File mountPoint = VolumeInfo.attachDmg(executable, noBrowse);
            if (mountPoint == null) {
                mountPoint = VolumeInfo.findAttachedDmg(executable);
            }
            if (mountPoint != null) {
                File[] files = mountPoint.listFiles();
                if (files != null) {
                    File file = LaunchHelper.findExecutableFile(files);
                    if (file != null && file.isDirectory()) {
                        try {
                            MacFileSystem.notifyBundleChange(file);
                        }
                        catch (Throwable t) {
                            Logger.getInstance().log(t);
                        }
                    }
                    return file;
                }
                Logger.getInstance().error(null, "could not list files in " + mountPoint);
                return null;
            }
            return null;
        }
        return executable;
    }

    public static File findExecutableFile(File[] files) {
        if (files != null) {
            for (File file : files) {
                File[] macFiles;
                File macDir;
                if (!file.isDirectory() || !file.getName().endsWith(".app")) continue;
                Logger.getInstance().info(null, "mounted bundle is " + file);
                if (Objects.equals("_unknown:_unknown", LegacyUnixFileSystem.getOwnerInfo(file)) && (macDir = new File(file, "Contents/MacOS")).isDirectory() && (macFiles = macDir.listFiles()) != null) {
                    for (File macFile : macFiles) {
                        if (!macFile.isFile() || macFile.getName().startsWith(".")) continue;
                        Logger.getInstance().info(null, "mounted as root, using executable " + macFile + ".");
                        return macFile;
                    }
                }
                return file;
            }
        }
        Logger.getInstance().error(null, "could not find app bundle");
        return null;
    }

    private static void closeStreams(InputStream inputRedirectStream, OutputStream outputRedirectStream, OutputStream errorRedirectStream) {
        try {
            if (inputRedirectStream != null) {
                inputRedirectStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputRedirectStream != null) {
                outputRedirectStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (errorRedirectStream != null) {
                errorRedirectStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static OutputStream createOutputStream(OutputRedirection outputRedirection, String streamName, LaunchResult launchResult, boolean error) throws IOException {
        if (outputRedirection != null) {
            OutputRedirectionMode redirectionMode = outputRedirection.getRedirectionMode();
            if (redirectionMode == OutputRedirectionMode.FILE) {
                return LaunchHelper.createFileOutputStream(outputRedirection);
            }
            if (redirectionMode == OutputRedirectionMode.VARIABLE || redirectionMode == OutputRedirectionMode.LOG_FILE) {
                return LaunchHelper.createStringOutputStream(outputRedirection, streamName, launchResult, error);
            }
        }
        return null;
    }

    private static OutputStream createFileOutputStream(OutputRedirection outputRedirection) throws IOException {
        block6: {
            if (outputRedirection != null) {
                if (outputRedirection.isStdOutFile()) {
                    return new UncloseableOutputStream(System.out);
                }
                if (outputRedirection.isStdErrFile()) {
                    return new UncloseableOutputStream(System.err);
                }
                File file = outputRedirection.getFile();
                if (file != null) {
                    try {
                        return new BufferedOutputStream(new FileOutputStream(file));
                    }
                    catch (IOException e) {
                        Logger.getInstance().error(LaunchHelper.class, "output file " + file.getPath() + " could not be created");
                        if (!outputRedirection.isFailOnFileError()) break block6;
                        throw e;
                    }
                }
            }
        }
        return null;
    }

    private static OutputStream createStringOutputStream(final OutputRedirection outputRedirection, final String streamName, final LaunchResult launchResult, final boolean error) {
        ContextInt context;
        final OutputRedirectionMode redirectionMode = outputRedirection.getRedirectionMode();
        if (redirectionMode == OutputRedirectionMode.VARIABLE && (context = ContextImpl.getSingleContextInt()) != null) {
            String variableName = outputRedirection.getVariableName();
            context.registerHiddenVariable(variableName);
        }
        return new ByteArrayOutputStream(){
            boolean closed = false;

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                if (this.containsLineSeparators(b, off, len) && redirectionMode == OutputRedirectionMode.VARIABLE && outputRedirection.isUpdateLines()) {
                    this.updateVariable();
                }
            }

            private boolean containsLineSeparators(byte[] buffer, int off, int len) {
                for (int i = 0; i < len; ++i) {
                    byte b = buffer[off + i];
                    if (b != 10 && b != 13) continue;
                    return true;
                }
                return false;
            }

            private void updateVariable() {
                ContextInt context = ContextImpl.getSingleContextInt();
                String variableName = outputRedirection.getVariableName();
                context.setVariable(variableName, this.toString());
            }

            @Override
            public synchronized String toString() {
                this.trimZeros();
                return super.toString();
            }

            public void trimZeros() {
                int j = 0;
                for (int i = 0; i < this.count; ++i) {
                    if (this.buf[i] == 0) continue;
                    this.buf[j++] = this.buf[i];
                }
                this.count = j;
            }

            @Override
            public synchronized void close() throws IOException {
                if (!this.closed) {
                    if (outputRedirection instanceof DirectOutputRedirection) {
                        if (error) {
                            launchResult.error = this.toString();
                        } else {
                            launchResult.output = this.toString();
                        }
                    } else {
                        OutputRedirectionMode redirectionMode2 = outputRedirection.getRedirectionMode();
                        if (redirectionMode2 == OutputRedirectionMode.VARIABLE) {
                            this.updateVariable();
                        } else if (redirectionMode2 == OutputRedirectionMode.LOG_FILE) {
                            String content = StringUtil.trimLineSeparators(this.toString());
                            if (content.trim().length() == 0) {
                                Logger.getInstance().info(LaunchHelper.class, streamName + " output was empty");
                            } else {
                                Logger.getInstance().info(LaunchHelper.class, "\n" + streamName + " output:\n---BEGIN---\n" + content + "\n---END---");
                            }
                        }
                    }
                    this.closed = true;
                }
            }
        };
    }

    private static InputStream createInputStream(InputRedirection inputRedirection) throws IOException {
        if (inputRedirection != null) {
            InputRedirectionMode redirectionMode = inputRedirection.getRedirectionMode();
            if (redirectionMode == InputRedirectionMode.FILE) {
                return LaunchHelper.createFileInputStream(inputRedirection);
            }
            if (redirectionMode == InputRedirectionMode.STRING) {
                return LaunchHelper.createStringInputStream(inputRedirection);
            }
        }
        return null;
    }

    private static InputStream createFileInputStream(InputRedirection inputRedirection) throws IOException {
        block5: {
            if (inputRedirection != null) {
                if (inputRedirection.isStdInFile()) {
                    return new UncloseableInputStream(System.in);
                }
                File file = inputRedirection.getFile();
                if (file != null) {
                    try {
                        return new FileInputStream(file);
                    }
                    catch (IOException e) {
                        Logger.getInstance().error(LaunchHelper.class, "input file " + file.getPath() + " could not be opened");
                        if (!inputRedirection.isFailOnFileError()) break block5;
                        throw e;
                    }
                }
            }
        }
        return null;
    }

    private static InputStream createStringInputStream(InputRedirection inputRedirection) {
        return new ByteArrayInputStream(inputRedirection.getString().getBytes());
    }

    static {
        Arrays.sort(SPECIAL_BATCH_FILE_CHARACTERS);
        Arrays.sort(SPECIAL_ARGUMENTS_CHARACTERS);
    }

    public static class LaunchResult
    implements Serializable {
        private int returnCode;
        private String output;
        private String error;

        public LaunchResult returnCode(int returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public String getOutput() {
            return this.output;
        }

        public String getError() {
            return this.error;
        }
    }

    private static class WriterThread
    extends Thread {
        private boolean canceled;
        private OutputStream processOutput;
        private InputStream inputStream;
        private boolean unbuffered;

        public WriterThread(OutputStream processOutput, InputStream inputStream, boolean unbuffered) {
            this.processOutput = processOutput;
            this.inputStream = inputStream;
            this.unbuffered = unbuffered;
        }

        @Override
        public void run() {
            if (this.unbuffered) {
                while (!this.canceled) {
                    try {
                        int read = this.inputStream.read();
                        if (read == -1) {
                            this.cancel();
                            continue;
                        }
                        this.processOutput.write(read);
                        this.processOutput.flush();
                    }
                    catch (IOException e) {
                        this.cancel();
                    }
                }
            } else {
                byte[] buffer = new byte[512];
                while (!this.canceled) {
                    try {
                        int read = this.inputStream.read(buffer);
                        if (read == -1) {
                            this.cancel();
                            continue;
                        }
                        this.processOutput.write(buffer, 0, read);
                    }
                    catch (IOException e) {
                        this.cancel();
                    }
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                this.inputStream.close();
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class ConsumerThread
    extends Thread {
        private boolean canceled;
        private InputStream stream;
        private OutputStream outputStream;

        public ConsumerThread(InputStream stream, OutputStream outputStream) {
            this.stream = stream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[512];
            while (!this.canceled) {
                try {
                    int read = this.stream.read(buffer);
                    if (read == -1) {
                        this.cancel();
                        continue;
                    }
                    if (this.outputStream == null) continue;
                    this.outputStream.write(buffer, 0, read);
                }
                catch (IOException e) {
                    this.cancel();
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

