/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.CommunicationBackend;
import com.install4j.runtime.installer.platform.unix.PipeCommunicationBackend;
import com.install4j.runtime.installer.platform.unix.TcpCommunicationBackend;
import com.install4j.runtime.installer.platform.win32.Win32CommunicationBackend;
import com.install4j.runtime.util.Base64;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class InterProcessCommunication {
    public static final ErrorLogger INSTALLER_APP_LOGGER = new ErrorLogger(){

        @Override
        public void log(String str) {
            Logger.getInstance().error(null, str);
        }

        @Override
        public void log(Throwable t) {
            Logger.getInstance().log(t);
        }
    };
    private CommunicationBackend backend;
    private final String parentIdentifier;
    private boolean connected = false;
    private String hash;
    private final ErrorLogger logger;
    private KeyPair rsaKey;
    private final Cipher aesEncryptCipher;
    private final Cipher aesDecryptCipher;

    public InterProcessCommunication(String parentIdentifier, String parentHash, ErrorLogger logger) {
        this.parentIdentifier = parentIdentifier;
        this.hash = parentHash;
        this.logger = logger;
        try {
            this.aesDecryptCipher = Cipher.getInstance("AES");
            this.aesEncryptCipher = Cipher.getInstance("AES");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private CommunicationBackend getBackend() {
        if (this.backend == null) {
            boolean preferTcp = Boolean.getBoolean("install4j.tcpComm");
            if (Util.isAtLeastWindowsVista() && !preferTcp) {
                this.backend = new Win32CommunicationBackend();
            } else if (Util.isMacOS() || !Util.isWindows() && !preferTcp) {
                this.backend = new PipeCommunicationBackend();
            }
            if (this.backend == null) {
                this.backend = new TcpCommunicationBackend();
            }
        }
        return this.backend;
    }

    public String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean connect() {
        if (this.getBackend().connect(this.getParentIdentifier())) {
            this.connected = true;
            try {
                SecretKey aesKey;
                Cipher rsaCipher = Cipher.getInstance("RSA");
                if (this.getParentIdentifier() != null) {
                    byte[] rsaPublicBytes = this.getBackend().readDataBlock();
                    String hash = InterProcessCommunication.createHash(rsaPublicBytes);
                    if (!this.getHash().equals(hash)) {
                        this.logger.log("wrong public key hash " + this.getHash() + ", " + hash);
                        System.exit(1);
                    }
                    PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(rsaPublicBytes));
                    rsaCipher.init(2, publicKey);
                    aesKey = new SecretKeySpec(rsaCipher.doFinal(this.getBackend().readDataBlock()), "AES");
                } else {
                    KeyGenerator generator = KeyGenerator.getInstance("AES");
                    generator.init(128);
                    aesKey = generator.generateKey();
                    byte[] aesKeyToBeTransmitted = aesKey.getEncoded();
                    if (!this.getBackend().writeDataBlock(this.rsaKey.getPublic().getEncoded())) {
                        this.logger.log("helper key exchange failed 1");
                        return false;
                    }
                    rsaCipher.init(1, this.rsaKey.getPrivate());
                    if (!this.getBackend().writeDataBlock(rsaCipher.doFinal(aesKeyToBeTransmitted))) {
                        this.logger.log("helper key exchange failed 2");
                        return false;
                    }
                    this.rsaKey = null;
                }
                this.aesDecryptCipher.init(2, aesKey);
                this.aesEncryptCipher.init(1, aesKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                this.logger.log(e);
                return false;
            }
        }
        return this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Class<?> getBackendClass() {
        return this.getBackend().getClass();
    }

    public String createListener() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            this.rsaKey = keyPairGenerator.generateKeyPair();
            this.hash = InterProcessCommunication.createHash(this.rsaKey.getPublic().getEncoded());
            return this.getBackend().createListener();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDisconnected() {
        this.connected = false;
    }

    public byte[] readDataBlock() throws IOException {
        byte[] bytes = this.getBackend().readDataBlock();
        if (bytes == null) {
            throw new IOException("read failed");
        }
        try {
            return this.aesDecryptCipher.doFinal(bytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IOException(e);
        }
    }

    public void writeDataBlock(byte[] bytes) throws IOException {
        try {
            bytes = this.aesEncryptCipher.doFinal(bytes);
            if (!this.getBackend().writeDataBlock(bytes)) {
                throw new IOException("write failed");
            }
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IOException(e);
        }
    }

    private static String createHash(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return Base64.encodeForFiles(md.digest(bytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ErrorLogger {
        public void log(String var1);

        public void log(Throwable var1);
    }
}

