/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.UiUtil;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import com.install4j.runtime.installer.frontend.LookAndFeelHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.IconHelper;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class DarkModeSwitcherComponent
extends SystemFormComponent {
    private static final Icon ICON_LIGHT_MODE_16 = IconHelper.loadIcon("light_mode_16.png");
    private static final Icon ICON_DARK_MODE_16 = IconHelper.loadIcon("dark_mode_16.png");
    private boolean iconOnly = true;
    private JButton button;

    public boolean isIconOnly() {
        return this.replaceWithTextOverride("iconOnly", this.iconOnly);
    }

    public void setIconOnly(boolean iconOnly) {
        this.iconOnly = iconOnly;
    }

    @Override
    public JComponent createCenterComponent() {
        this.button = new JButton(){

            @Override
            public Dimension getMinimumSize() {
                if (DarkModeSwitcherComponent.this.isIconOnly()) {
                    return this.getIconSize();
                }
                return super.getMinimumSize();
            }

            @Override
            public Dimension getPreferredSize() {
                if (DarkModeSwitcherComponent.this.isIconOnly()) {
                    return this.getIconSize();
                }
                return super.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                if (DarkModeSwitcherComponent.this.isIconOnly()) {
                    return this.getIconSize();
                }
                return super.getMaximumSize();
            }

            private Dimension getIconSize() {
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = preferredSize.height;
                return preferredSize;
            }
        };
        if (this.isIconOnly()) {
            this.button.putClientProperty("JButton.buttonType", "toolBarButton");
        }
        this.button.addActionListener(e -> UiUtil.setDarkUi(!UiUtil.isDarkUi()));
        this.updateButton();
        LookAndFeelHelper.onLookAndFeelChange(this.button, this::updateButton);
        return this.button;
    }

    private void updateButton() {
        boolean visible = this.isDarkModeSwitchingSupported();
        this.setVisible(visible);
        this.button.setVisible(visible);
        boolean dark = UiUtil.isDarkUi();
        this.button.setIcon(dark ? ICON_LIGHT_MODE_16 : ICON_DARK_MODE_16);
        if (!this.isIconOnly()) {
            this.button.setText(dark ? Messages.getString(".ButtonLightMode") : Messages.getString(".ButtonDarkMode"));
        }
    }

    private boolean isDarkModeSwitchingSupported() {
        return UiUtil.getLookAndFeelEnhancer().isDarkModeSwitchingSupported();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isDarkModeSwitchingSupported()) {
            super.setVisible(visible);
        }
    }

    @Override
    public boolean isFillCenterHorizontal() {
        return false;
    }
}

