/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.BlobWithIO;
import java.io.IOException;
import java.io.InputStream;

class BlobInputStream
extends InputStream {
    private BlobWithIO blob;
    private int pointer;
    private int mark;

    BlobInputStream(BlobWithIO blobWithIO) {
        this.blob = blobWithIO;
        this.pointer = 0;
        this.mark = -1;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 != 1) {
            return -1;
        }
        return 0xFF & byArray[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        if (n2 < 0 || n2 >= byArray.length || n3 <= 0 || n2 + n3 > byArray.length) {
            throw new IOException("invalid offset/length");
        }
        try {
            int n4 = (int)this.blob.size();
            if (n4 <= this.pointer) {
                return -1;
            }
            int n5 = Math.min(n3, n4 - this.pointer);
            int n6 = this.blob.substr(this.pointer, byArray, n2, n5);
            if (n6 < 0) {
                return -1;
            }
            this.pointer += n6;
            return n6;
        }
        catch (Exception exception) {
            throw new IOException("I/O error during Blob read(): " + exception);
        }
    }

    @Override
    public long skip(long l8) throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        try {
            int n2 = (int)this.blob.size();
            int n3 = (long)this.pointer + l8 >= (long)n2 ? n2 : ((long)this.pointer + l8 <= 0L ? 0 : this.pointer + (int)l8);
            int n4 = n3 - this.pointer;
            this.pointer = n3;
            return n4;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Blob skip(): " + exception);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        try {
            return (int)this.blob.size() - this.pointer;
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Blob available(): " + exception);
        }
    }

    @Override
    public synchronized void mark(int n2) {
        this.mark = this.pointer;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.blob == null) {
            throw new IOException("InputStream is closed");
        }
        this.pointer = this.mark < 0 ? 0 : this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
        this.blob = null;
    }
}

