/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TreeTable;
import com.jidesoft.icons.RolloverIcon;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NavigationTreeTable
extends TreeTable
implements NavigationComponent,
RolloverIcon.IconRolloverSupport {
    private NavigationComponentHelper \u1e0e;
    private float \u1e0b = 0.0f;
    private Animator \u1e0a;
    private Animator \u1e0c;
    private boolean \u1e0d = true;
    public static final String PROPERTY_FADE_ICON = "fadeIcon";

    public NavigationTreeTable() {
        this.\u0299();
    }

    public NavigationTreeTable(int n2, int n3) {
        super(n2, n3);
        this.\u0299();
    }

    public NavigationTreeTable(TableModel tableModel) {
        super(tableModel);
        this.\u0299();
    }

    public NavigationTreeTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.\u0299();
    }

    public NavigationTreeTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.\u0299();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.\u0299();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.\u0299();
    }

    private void \u0299() {
        this.setAutoResizeMode(256);
        this.setFillsSelection(false);
        this.setShowGrid(false);
        this.setFillsGrids(false);
        this.setShowTreeLines(false);
        this.setShowLeafNodeTreeLines(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setExpandedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 0));
        this.setCollapsedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 1));
        this.\u1e0a = new Animator(this, 100, 30, 30);
        this.\u1e0a.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                float f2 = 1.0f * (float)(n2 - n3) / (float)n2;
                if (f2 <= NavigationTreeTable.this.getIconAlpha()) {
                    NavigationTreeTable.this.setIconAlpha(f2);
                }
                NavigationTreeTable.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(0.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this.\u1e0c = new Animator(this, 100, 5, 10);
        this.\u1e0c.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                float f2 = 1.0f * (float)n3 / (float)n2;
                if (f2 >= NavigationTreeTable.this.getIconAlpha()) {
                    NavigationTreeTable.this.setIconAlpha(f2);
                }
                NavigationTreeTable.this.repaint();
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(1.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this.\u1e0e = this.createNavigationHelper();
        this.\u1e0e.setup(this);
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationTreeTableHelper();
    }

    private Rectangle \u0140(int n2) {
        return this.getCellRect(n2, 0, false).union(this.getCellRect(n2, this.getColumnCount() - 1, false));
    }

    @Override
    public boolean isIconRollover(int n2, int n3, int n4, int n5) {
        Point point = this.\u1e0e.getMousePosition();
        return point != null && point.x >= n2 && point.x <= n2 + n4 && point.y >= n3 && point.y <= n3 + n5;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.\u1e0e.paint(graphics, this);
    }

    @Override
    public float getIconAlpha() {
        return this.\u1e0b;
    }

    public void setIconAlpha(float f2) {
        this.\u1e0b = f2;
    }

    @Override
    public boolean isIconFade() {
        return this.\u1e0d;
    }

    public void setFadeIcon(boolean bl) {
        boolean bl2 = this.\u1e0d;
        if (bl != this.\u1e0d) {
            this.\u1e0d = bl;
            this.firePropertyChange(PROPERTY_FADE_ICON, bl2, this.\u1e0d);
            this.repaint();
        }
    }

    public int getNavigationRolloverRow() {
        return this.\u1e0e.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n2) {
        int n3 = this.\u1e0e.getRolloverRow();
        if (n3 != n2) {
            this.\u1e0e.setRolloverRow(n2);
            Rectangle rectangle = this.\u0140(n3);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.\u0140(n2)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    public class NavigationTreeTableHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n2) {
            return NavigationTreeTable.this.\u0140(n2);
        }

        @Override
        public int rowAtPoint(Point point) {
            return NavigationTreeTable.this.rowAtPoint(point);
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationTreeTable.this.getSelectedRows();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (NavigationTreeTable.this.isIconFade() && !NavigationTreeTable.this.hasFocus()) {
                NavigationTreeTable.this.\u1e0c.stop();
                NavigationTreeTable.this.\u1e0a.start();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (NavigationTreeTable.this.isIconFade() && !NavigationTreeTable.this.hasFocus()) {
                NavigationTreeTable.this.\u1e0a.stop();
                NavigationTreeTable.this.\u1e0c.start();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (NavigationTreeTable.this.isIconFade()) {
                NavigationTreeTable.this.\u1e0a.stop();
                NavigationTreeTable.this.\u1e0c.start();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (NavigationTreeTable.this.isIconFade()) {
                NavigationTreeTable.this.\u1e0c.stop();
                NavigationTreeTable.this.\u1e0a.start();
            }
        }
    }
}

