/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.XMenuPainter;
import de.javasoft.swing.XMenu;
import de.javasoft.swing.plaf.basic.BasicXMenuUI;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public class SyntheticaXMenuUI
extends BasicXMenuUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaXMenuUI();
    }

    protected void installDefaults(JComponent jComponent) {
        super.installDefaults(jComponent);
        Font font = jComponent.getFont();
        if (font == null || font instanceof UIResource) {
            String string = SyntheticaLookAndFeel.getString("XMenu.fontStyle", jComponent);
            int n = string == null ? FontStyle.PLAIN.getStyleAsInt() : FontStyle.valueOf(string).getStyleAsInt();
            jComponent.setFont(new FontUIResource(SyntheticaLookAndFeel.getFontName(), n, SyntheticaLookAndFeel.getFontSize()));
            this.menuButton.setFont(jComponent.getFont());
        }
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
        SyntheticaState syntheticaState = this.createState(jComponent, ((AbstractButton)jComponent).isSelected());
        XMenuPainter.getInstance().paintBackground(jComponent, syntheticaState, graphics, n, n2, n3, n4);
    }

    protected void paintContentPaneBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
        XMenuPainter.getInstance().paintContentPaneBackground(jComponent, new SyntheticaState(0), graphics, n, n2, n3, n4);
    }

    protected void paintButtonBackground(JComponent jComponent, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
        SyntheticaState syntheticaState = this.createState(jComponent, !this.xMenu.isCollapsed());
        XMenuPainter.getInstance().paintButtonBackground(jComponent, syntheticaState, graphics, n, n2, n3, n4);
    }

    private SyntheticaState createState(JComponent jComponent, boolean bl) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SyntheticaState syntheticaState = new SyntheticaState();
        if (this.isMouseSensitive() ? abstractButton.getModel().isPressed() : ((XMenu)abstractButton).getMenuButton().getModel().isPressed()) {
            syntheticaState.setState(SyntheticaState.State.PRESSED);
        } else if (this.isMouseSensitive() ? abstractButton.getModel().isRollover() : ((XMenu)abstractButton).getMenuButton().getModel().isRollover()) {
            syntheticaState.setState(SyntheticaState.State.HOVER);
        }
        if (bl) {
            syntheticaState.setState(SyntheticaState.State.SELECTED);
        }
        if (!abstractButton.isEnabled()) {
            syntheticaState.setState(SyntheticaState.State.DISABLED);
        }
        return syntheticaState;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FontStyle {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        ITALIC_BOLD(3);

        private int fontStyle;

        private FontStyle(int n2) {
            this.fontStyle = n2;
        }

        private int getStyleAsInt() {
            return this.fontStyle;
        }
    }
}

