/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideSplitButtonUI;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatJideSplitButtonUI
extends BasicJideSplitButtonUI {
    protected String arrowType;
    protected Color buttonArrowColor;
    protected Color buttonDisabledArrowColor;

    public static ComponentUI createUI(JComponent c) {
        LookAndFeelFactory.installJideExtension();
        return new FlatJideSplitButtonUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.arrowType = UIManager.getString("Component.arrowType");
        this.buttonArrowColor = UIManager.getColor("JideSplitButton.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("JideSplitButton.buttonDisabledArrowColor");
    }

    protected int getRightMargin() {
        this._splitButtonMargin = UIScale.scale((int)14);
        this._splitButtonMarginOnMenu = UIScale.scale((int)20);
        return super.getRightMargin();
    }

    protected Rectangle getButtonRect(JComponent c, int orientation, int width, int height) {
        return c.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, width - this._splitButtonMargin + 1, height) : new Rectangle(this._splitButtonMargin - 1, 0, width - this._splitButtonMargin + 1, height);
    }

    protected Rectangle getDropDownRect(JComponent c, int orientation, int width, int height) {
        return c.getComponentOrientation().isLeftToRight() ? new Rectangle(width - this._splitButtonMargin, 0, this._splitButtonMargin, height) : new Rectangle(0, 0, this._splitButtonMargin, height);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (!model.isEnabled() || menuItem instanceof JideSplitButton && !((JideSplitButton)menuItem).isButtonEnabled()) {
            FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
            if (!menuItem.getComponentOrientation().isLeftToRight() && menuItem.getComponentOrientation().isHorizontal()) {
                Rectangle2D rectText = fm.getStringBounds(text, g);
                textRect.x = (int)((double)(menuItem.getWidth() - textRect.x) - rectText.getWidth() + (double)(4 + menuItem.getHeight() / 2 - 1));
            }
            g.setColor(UIDefaultsLookup.getColor((Object)"Button.disabledForeground"));
            this.drawStringUnderlineCharAt(menuItem, g, text, -1, textRect.x, textRect.y + fm.getAscent());
        } else {
            super.paintText(g, menuItem, textRect, text);
        }
    }

    protected void paintArrow(JMenuItem menuItem, Graphics g) {
        g.setColor(menuItem.isEnabled() ? this.buttonArrowColor : this.buttonDisabledArrowColor);
        int orientation = JideSwingUtilities.getOrientationOf((Component)menuItem);
        int menuWidth = orientation == 0 ? menuItem.getWidth() : menuItem.getHeight();
        int menuHeight = orientation == 0 ? menuItem.getHeight() : menuItem.getWidth();
        Rectangle r = this.getDropDownRect(menuItem, orientation, menuWidth, menuHeight);
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints((Graphics)g);
        FlatUIUtils.paintArrow((Graphics2D)((Graphics2D)g), (int)r.x, (int)r.y, (int)r.width, (int)r.height, (int)5, (boolean)FlatUIUtils.isChevron((String)this.arrowType), (int)6, (int)0, (int)0);
        FlatUIUtils.resetRenderingHints((Graphics)g, (Object[])oldRenderingHints);
    }
}

