/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MonthNameConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT = new ConverterContext("MonthName");
    public static final DateFormat CONCISE_FORMAT = new SimpleDateFormat("M");
    public static final DateFormat SHORT_FORMAT = new SimpleDateFormat("MM");
    public static final DateFormat MEDIUM_FORMAT = new SimpleDateFormat("MMM");
    public static final DateFormat LONG_FORMAT = new SimpleDateFormat("MMMMM");
    private DateFormat \u010c = MEDIUM_FORMAT;
    static final Calendar \u010d = Calendar.getInstance();

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object == null || !(object instanceof Integer)) {
            return "";
        }
        return this.\u010c.format(this.getCalendarByMonth((Integer)object).getTime());
    }

    protected Calendar getCalendarByMonth(int n2) {
        \u010d.set(2, n2);
        return \u010d;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = this.\u010c.parse(string);
            calendar.setTime(date);
        }
        catch (ParseException parseException) {
            try {
                Date date = SHORT_FORMAT.parse(string);
                calendar.setTime(date);
            }
            catch (ParseException parseException2) {
                try {
                    Date date = MEDIUM_FORMAT.parse(string);
                    calendar.setTime(date);
                }
                catch (ParseException parseException3) {
                    try {
                        Date date = LONG_FORMAT.parse(string);
                        calendar.setTime(date);
                    }
                    catch (ParseException parseException4) {
                        try {
                            Date date = CONCISE_FORMAT.parse(string);
                            calendar.setTime(date);
                        }
                        catch (ParseException parseException5) {
                            return null;
                        }
                    }
                }
            }
        }
        return calendar.get(2);
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this.\u010c;
    }

    public void setDefaultFormat(DateFormat dateFormat) {
        this.\u010c = dateFormat;
    }

    public static void main(String[] stringArray) {
        MonthNameConverter monthNameConverter = new MonthNameConverter();
        monthNameConverter.setDefaultFormat(LONG_FORMAT);
        for (int i2 = 0; i2 < 12; ++i2) {
            String string = monthNameConverter.toString(new Integer(i2), null);
            System.out.println(string);
            System.out.println(monthNameConverter.fromString(string, null));
        }
    }

    static {
        \u010d.set(5, 1);
    }
}

