/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.core.BaseStatement;
import com.amazon.redshift.core.TypeInfo;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftState;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> rsNameToSQLType;
    private Map<String, String> rsNameToJavaClass;
    private Map<Integer, String> oidToRsName;
    private Map<String, Integer> rsNameToOid;
    private Map<String, Class<? extends RedshiftObject>> rsNameToRsObject;
    private Map<Integer, Integer> rsArrayToRsType;
    private Map<Integer, Character> arrayOidToDelimiter;
    private BaseConnection conn;
    private final int unknownLength;
    private PreparedStatement getOidStatementSimple;
    private PreparedStatement getOidStatementComplexNonArray;
    private PreparedStatement getOidStatementComplexArray;
    private PreparedStatement getNameStatement;
    private PreparedStatement getArrayElementOidStatement;
    private PreparedStatement getArrayDelimiterStatement;
    private PreparedStatement getTypeInfoStatement;
    private PreparedStatement getAllTypeInfoStatement;
    public static final String GEOMETRY_NAME = "geometry";
    public static final int GEOMETRYOID = 3000;
    public static final int GEOMETRYHEXOID = 3999;
    public static final String SUPER_NAME = "super";
    public static final int SUPEROID = 4000;
    public static final String TID_NAME = "tid";
    public static final String TID_ARRAY_NAME = "_tid";
    public static final String XID_NAME = "xid";
    public static final String XID_ARRAY_NAME = "_xid";
    private static final Object[][] types = new Object[][]{{"oid", 26, -5, "java.lang.Long", 1028}, {"money", 790, 8, "java.lang.Double", 791}, {"double precision", 701, 8, "java.lang.Double", 1022}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"character varying", 1043, 12, "java.lang.String", 1015}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"time without time zone", 1083, 92, "java.sql.Time", 1183}, {"timestamp without time zone", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamp with time zone", 1184, 93, "java.sql.Timestamp", 1185}, {"geometry", 3999, -4, "[B", 0}, {"xid", 28, -5, "java.lang.Long", 1011}, {"tid", 27, 12, "java.lang.String", 1010}, {"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"int8", 20, -5, "java.lang.Long", 1016}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"time with time zone", 1266, 92, "java.sql.Time", 1270}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}, {"json", 114, 1111, "com.amazon.redshift.util.RedshiftObject", 199}, {"point", 600, 1111, "com.amazon.redshift.geometric.RedshiftPoint", 1017}, {"geometry", 3000, -4, "[B", 0}, {"super", 4000, -1, "java.lang.String", 0}};
    private static final HashMap<String, String> typeAliases = new HashMap();

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this.conn = conn;
        this.unknownLength = unknownLength;
        this.oidToRsName = new HashMap<Integer, String>((int)Math.round((double)types.length * 1.5));
        this.rsNameToOid = new HashMap<String, Integer>((int)Math.round((double)types.length * 1.5));
        this.rsNameToJavaClass = new HashMap<String, String>((int)Math.round((double)types.length * 1.5));
        this.rsNameToRsObject = new HashMap<String, Class<? extends RedshiftObject>>((int)Math.round((double)types.length * 1.5));
        this.rsArrayToRsType = new HashMap<Integer, Integer>((int)Math.round((double)types.length * 1.5));
        this.arrayOidToDelimiter = new HashMap<Integer, Character>((int)Math.round((double)types.length * 2.5));
        this.rsNameToSQLType = Collections.synchronizedMap(new HashMap((int)Math.round((double)types.length * 1.5)));
        for (Object[] type : types) {
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
        this.rsNameToJavaClass.put("hstore", Map.class.getName());
    }

    @Override
    public synchronized void addCoreType(String rsTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this.rsNameToJavaClass.put(rsTypeName, javaClass);
        this.rsNameToOid.put(rsTypeName, oid);
        this.oidToRsName.put(oid, rsTypeName);
        this.rsArrayToRsType.put(arrayOid, oid);
        this.rsNameToSQLType.put(rsTypeName, sqlType);
        Character delim = Character.valueOf(',');
        this.arrayOidToDelimiter.put(oid, delim);
        this.arrayOidToDelimiter.put(arrayOid, delim);
        String pgArrayTypeName = rsTypeName + "[]";
        this.rsNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this.rsNameToSQLType.put(pgArrayTypeName, 2003);
        this.rsNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + rsTypeName;
        if (!this.rsNameToJavaClass.containsKey(pgArrayTypeName)) {
            this.rsNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this.rsNameToSQLType.put(pgArrayTypeName, 2003);
            this.rsNameToOid.put(pgArrayTypeName, arrayOid);
            this.oidToRsName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends RedshiftObject> klass) throws SQLException {
        this.rsNameToRsObject.put(type, klass);
        this.rsNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getRSTypeNamesWithSQLTypes() {
        return this.rsNameToSQLType.keySet().iterator();
    }

    private String getSQLTypeQuery(boolean typnameParam) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT typinput='array_in'::regproc as is_array, typtype, typname ");
        sql.append("  FROM pg_catalog.pg_type ");
        sql.append("  LEFT JOIN (select ns.oid as nspoid, ns.nspname, r.r ");
        sql.append("          from pg_namespace as ns ");
        sql.append("          join ( select s.r, (current_schemas(false))[s.r] as nspname ");
        sql.append("                   from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r ");
        sql.append("         using ( nspname ) ");
        sql.append("       ) as sp ");
        sql.append("    ON sp.nspoid = typnamespace ");
        if (typnameParam) {
            sql.append(" WHERE typname = ? ");
        }
        sql.append(" ORDER BY sp.r, pg_type.oid DESC;");
        return sql.toString();
    }

    private int getSQLTypeFromQueryResult(ResultSet rs) throws SQLException {
        Integer type = null;
        boolean isArray = rs.getBoolean("is_array");
        String typtype = rs.getString("typtype");
        if (isArray) {
            type = 2003;
        } else if ("c".equals(typtype)) {
            type = 2002;
        } else if ("d".equals(typtype)) {
            type = 2001;
        } else if ("e".equals(typtype)) {
            type = 12;
        }
        if (type == null) {
            type = 1111;
        }
        return type;
    }

    public void cacheSQLTypes(RedshiftLogger logger) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            logger.log(LogLevel.DEBUG, "caching all SQL typecodes", new Object[0]);
        }
        if (this.getAllTypeInfoStatement == null) {
            this.getAllTypeInfoStatement = this.conn.prepareStatement(this.getSQLTypeQuery(false));
        }
        if (!((BaseStatement)((Object)this.getAllTypeInfoStatement)).executeWithFlags(16)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        ResultSet rs = this.getAllTypeInfoStatement.getResultSet();
        while (rs.next()) {
            String typeName = rs.getString("typname");
            Integer type = this.getSQLTypeFromQueryResult(rs);
            if (this.rsNameToSQLType.containsKey(typeName)) continue;
            this.rsNameToSQLType.put(typeName, type);
        }
        rs.close();
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getRSType(oid));
    }

    @Override
    public synchronized int getSQLType(String pgTypeName) throws SQLException {
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this.rsNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        if (this.getTypeInfoStatement == null) {
            this.getTypeInfoStatement = this.conn.prepareStatement(this.getSQLTypeQuery(true));
        }
        this.getTypeInfoStatement.setString(1, pgTypeName);
        if (!((BaseStatement)((Object)this.getTypeInfoStatement)).executeWithFlags(16)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        ResultSet rs = this.getTypeInfoStatement.getResultSet();
        Integer type = 1111;
        if (rs.next()) {
            type = this.getSQLTypeFromQueryResult(rs);
        }
        rs.close();
        this.rsNameToSQLType.put(pgTypeName, type);
        return type;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        String name;
        String schema;
        String fullName;
        PreparedStatement oidStatementComplex;
        String sql;
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        if (dotIndex == -1 && !hasQuote && !isArray) {
            if (this.getOidStatementSimple == null) {
                String sql2 = "SELECT pg_type.oid, typname   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this.getOidStatementSimple = this.conn.prepareStatement(sql2);
            }
            String lcName = pgTypeName.toLowerCase();
            this.getOidStatementSimple.setString(1, lcName);
            return this.getOidStatementSimple;
        }
        if (isArray) {
            if (this.getOidStatementComplexArray == null) {
                sql = "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM pg_catalog.pg_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                this.getOidStatementComplexArray = this.conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexArray;
        } else {
            if (this.getOidStatementComplexNonArray == null) {
                sql = "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this.getOidStatementComplexNonArray = this.conn.prepareStatement(sql);
            }
            oidStatementComplex = this.getOidStatementComplexNonArray;
        }
        String string = fullName = isArray ? pgTypeName.substring(0, pgTypeName.length() - 2) : pgTypeName;
        if (dotIndex == -1) {
            schema = null;
            name = fullName;
        } else if (fullName.startsWith("\"")) {
            if (fullName.endsWith("\"")) {
                String[] parts = fullName.split("\"\\.\"");
                schema = parts.length == 2 ? parts[0] + "\"" : null;
                name = parts.length == 2 ? "\"" + parts[1] : parts[0];
            } else {
                int lastDotIndex = fullName.lastIndexOf(46);
                name = fullName.substring(lastDotIndex + 1);
                schema = fullName.substring(0, lastDotIndex);
            }
        } else {
            schema = fullName.substring(0, dotIndex);
            name = fullName.substring(dotIndex + 1);
        }
        if (schema != null && schema.startsWith("\"") && schema.endsWith("\"")) {
            schema = schema.substring(1, schema.length() - 1);
        } else if (schema != null) {
            schema = schema.toLowerCase();
        }
        name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.toLowerCase();
        oidStatementComplex.setString(1, name);
        oidStatementComplex.setString(2, schema);
        oidStatementComplex.setBoolean(3, schema == null);
        return oidStatementComplex;
    }

    @Override
    public synchronized int getRSType(String pgTypeName) throws SQLException {
        Integer oid = this.rsNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            this.oidToRsName.put(oid, internalName);
            this.rsNameToOid.put(internalName, oid);
        }
        this.rsNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    @Override
    public synchronized String getRSType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String rsTypeName = this.oidToRsName.get(oid);
        if (rsTypeName != null) {
            return rsTypeName;
        }
        if (this.getNameStatement == null) {
            String sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getNameStatement = this.conn.prepareStatement(sql);
        }
        this.getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getNameStatement)).executeWithFlags(16)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        ResultSet rs = this.getNameStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                rsTypeName = name;
                this.rsNameToOid.put(schema + "." + name, oid);
            } else {
                rsTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this.rsNameToOid.put(schema + "." + name, oid);
                }
            }
            this.rsNameToOid.put(rsTypeName, oid);
            this.oidToRsName.put(oid, rsTypeName);
        }
        rs.close();
        return rsTypeName;
    }

    @Override
    public int getRSArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        return this.getRSType(elementTypeName + "[]");
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this.rsArrayToRsType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this.arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this.getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this.getArrayDelimiterStatement = this.conn.prepareStatement(sql);
        }
        this.getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        ResultSet rs = this.getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = Character.valueOf(s.charAt(0));
        this.arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getRSArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer rsType = this.rsArrayToRsType.get(oid);
        if (rsType != null) {
            return rsType;
        }
        if (this.getArrayElementOidStatement == null) {
            String sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this.getArrayElementOidStatement = this.conn.prepareStatement(sql);
        }
        this.getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this.getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        ResultSet rs = this.getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new RedshiftException(GT.tr("No results were returned by the query.", new Object[0]), RedshiftState.NO_DATA);
        }
        rsType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        this.rsArrayToRsType.put(oid, rsType);
        this.rsNameToOid.put(schema + "." + name, rsType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this.rsNameToOid.put(fullName, rsType);
        if (onPath && name.equals(name.toLowerCase())) {
            this.oidToRsName.put(rsType, name);
            this.rsNameToOid.put(name, rsType);
        } else {
            this.oidToRsName.put(rsType, fullName);
        }
        rs.close();
        return rsType;
    }

    @Override
    public synchronized Class<? extends RedshiftObject> getRSobject(String type) {
        return this.rsNameToRsObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getRSType(oid);
        String result = this.rsNameToJavaClass.get(pgTypeName);
        if (result != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this.rsNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = typeAliases.get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: 
            case 28: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 27: 
            case 1042: 
            case 1043: 
            case 4000: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod;
            }
            case 19: {
                return 64;
            }
        }
        return this.unknownLength;
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: 
            case 28: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch (oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 27: 
            case 1042: 
            case 1043: 
            case 4000: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this.unknownLength;
                }
                return typmod;
            }
            case 19: {
                return 64;
            }
            case 17: 
            case 25: {
                return this.unknownLength;
            }
        }
        return this.unknownLength;
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 4000: {
                return 0x400000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    static {
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
    }
}

