/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockbarManager;
import de.javasoft.swing.jydocking.DockbarSlidePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

class SlidePanelAnimation
implements Runnable,
ActionListener {
    private static int ANIMATION_INTERVAL = 20;
    private static int TOTAL_FRAME_COUNT = 5;
    private DockbarManager dockManager;
    private Timer timer;
    private float frameDelta;
    private int frameCount;
    private boolean hiding;
    private Runnable next;
    private Object lock;

    public SlidePanelAnimation(DockbarManager dockbarManager, boolean bl) {
        this.dockManager = dockbarManager;
        this.timer = new Timer(ANIMATION_INTERVAL, this);
        this.frameDelta = 100.0f / (float)this.getTotalFrameCount() / 100.0f;
        this.hiding = bl;
        this.lock = new Object();
    }

    public void run() {
        this.dockManager.setAnimating(true);
        this.timer.start();
        this.sleep();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.resetViewpaneSize();
        this.dockManager.revalidate();
        if (this.frameCount == this.getTotalFrameCount() - 1) {
            this.timer.stop();
            this.wakeUp();
            this.dockManager.setAnimating(false);
        } else {
            ++this.frameCount;
        }
    }

    private void resetViewpaneSize() {
        DockbarSlidePanel dockbarSlidePanel = this.dockManager.getSlidePanel();
        int n = this.dockManager.getPreferredViewpaneSize();
        if (this.frameCount == 0) {
            n = this.getStartSize(n);
        } else if (this.frameCount == this.getTotalFrameCount() - 1) {
            n = this.getEndSize(n);
        } else {
            int n2 = (int)((float)n * ((float)this.frameCount * this.frameDelta));
            n = this.hiding ? n - n2 : n2;
        }
        dockbarSlidePanel.setPrefSize(n);
    }

    private int getStartSize(int n) {
        if (this.hiding) {
            return n;
        }
        return 0;
    }

    private int getEndSize(int n) {
        if (this.hiding) {
            return 0;
        }
        return n;
    }

    private int getTotalFrameCount() {
        return TOTAL_FRAME_COUNT;
    }

    public Runnable getNext() {
        return this.next;
    }

    public void setNext(Runnable runnable) {
        this.next = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

