/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.filter;

import de.javasoft.swing.SimpleDropDownButton;
import de.javasoft.swing.filter.ColumnFilter;
import de.javasoft.swing.filter.ComparableRowFilterModel;
import de.javasoft.swing.filter.FilterButton;
import de.javasoft.swing.filter.IRowFilterModel;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;

public abstract class AbstractComparableColumnFilter<M>
extends ColumnFilter<M> {
    private static final Logger LOG = Logger.getLogger(AbstractComparableColumnFilter.class.getName());
    private SimpleDropDownButton ruleComponent;
    private ColumnFilter.PopupSupport popupSupport;

    public AbstractComparableColumnFilter(int columnIndex) {
        super(columnIndex);
    }

    protected AbstractComparableColumnFilter(int columnIndex, IRowFilterModel<M> filterModel) {
        super(columnIndex, filterModel);
    }

    @Override
    protected void matchRuleChanged(Object rule) {
        Object oldRule = this.getRowFilterModel().getMatchRule();
        super.matchRuleChanged(rule);
        this.updateMatchValueAfterMatchRuleChanged(oldRule);
    }

    protected void updateMatchValueAfterMatchRuleChanged(Object oldRule) {
        if (oldRule.getClass() != this.getRowFilterModel().getMatchRule().getClass()) {
            this.matchValueChanged();
        }
    }

    @Override
    protected void matchRuleChanged(Object oldValue, Object newValue) {
        this.getFilteringComponent();
        boolean selectionChanged = this.getPopupSupport().selectMatchRuleAction(this.getMatchRuleComponent().getPopupMenu(), newValue);
        if (selectionChanged) {
            this.updateMatchValueAfterMatchRuleChanged(oldValue);
        }
    }

    @Override
    protected void updateComponentsAfterMatchRuleChanged(Object rule) {
        Action target = this.ruleComponent.getAction();
        target.putValue("ShortDescription", this.getMatchRuleName(rule));
    }

    @Override
    protected IRowFilterModel<? extends M> createRowFilterModel(int columnIndex) {
        return new ComparableRowFilterModel(columnIndex);
    }

    @Override
    protected void doRelease() {
        this.getPopupSupport().uninstallMatchRulePopup(this.ruleComponent.getPopupMenu());
    }

    @Override
    protected void installActivated(JComponent filteringComponent) {
        this.getPopupSupport().installMatchRulePopup(this.ruleComponent);
        this.matchValueChanged(null, this.getRowFilterModel().getMatchValue());
    }

    protected ColumnFilter.PopupSupport getPopupSupport() {
        if (this.popupSupport == null) {
            this.popupSupport = this.createPopupSupport();
        }
        return this.popupSupport;
    }

    protected ColumnFilter.PopupSupport createPopupSupport() {
        return new ColumnFilter.PopupSupport(this);
    }

    protected SimpleDropDownButton getMatchRuleComponent() {
        if (this.ruleComponent == null) {
            this.ruleComponent = this.createMatchRuleComponent();
        }
        return this.ruleComponent;
    }

    protected SimpleDropDownButton createMatchRuleComponent() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        FilterButton dropDown = new FilterButton(action);
        return dropDown;
    }
}

