/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalLayout
implements LayoutManager {
    private int gap;

    public HorizontalLayout() {
        this(0);
    }

    public HorizontalLayout(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = dimension.height - insets.top - insets.bottom;
        if (container.getComponentOrientation().isLeftToRight()) {
            int n2 = insets.left;
            int n3 = 0;
            int n4 = container.getComponentCount();
            while (n3 < n4) {
                Component component = container.getComponent(n3);
                if (component.isVisible()) {
                    int n5 = component.getPreferredSize().width;
                    component.setBounds(n2, insets.top, n5, n);
                    n2 += n5 + this.gap;
                }
                ++n3;
            }
        } else {
            int n6 = container.getSize().width - insets.right;
            int n7 = 0;
            int n8 = container.getComponentCount();
            while (n7 < n8) {
                Component component = container.getComponent(n7);
                if (component.isVisible()) {
                    int n9 = component.getPreferredSize().width;
                    component.setBounds(n6 -= n9, insets.top, n9, n);
                    n6 -= this.gap;
                }
                ++n7;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = container.getComponentCount();
        while (n < n2) {
            Component component = container.getComponent(n);
            if (component.isVisible()) {
                Dimension dimension2 = component.getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width += dimension2.width + this.gap;
            }
            ++n;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }
}

