/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class VerticaHostnameVerifier
implements HostnameVerifier {
    private static final int TYPE_DNS_NAME = 2;
    private static final int TYPE_IP_ADDRESS = 7;
    private ILogger log = null;
    public static final Comparator<String> HOSTNAME_PATTERN_COMPARATOR = new Comparator<String>(){

        private int countChars(String string, char c) {
            int n = 0;
            int n2 = -1;
            while ((n2 = string.indexOf(c, n2 + 1)) != -1) {
                ++n;
            }
            return n;
        }

        @Override
        public int compare(String string, String string2) {
            int n;
            int n2;
            int n3;
            int n4 = this.countChars(string, '.');
            if (n4 != (n3 = this.countChars(string2, '.'))) {
                return n4 > n3 ? 1 : -1;
            }
            int n5 = this.countChars(string, '*');
            if (n5 != (n2 = this.countChars(string2, '*'))) {
                return n5 < n2 ? 1 : -1;
            }
            int n6 = string.length();
            if (n6 != (n = string2.length())) {
                return n6 > n ? 1 : -1;
            }
            return 0;
        }
    };

    public VerticaHostnameVerifier(ILogger iLogger) {
        this.log = iLogger;
        this.logDebug("Initialize default VerticaHostnameVerifier");
    }

    private void logDebug(String string) {
        if (this.log != null) {
            LogUtilities.logDebug(string, this.log);
        }
    }

    private void logDebug(String string, Exception exception) {
        if (this.log != null) {
            LogUtilities.logDebug(string, this.log);
            LogUtilities.logDebug(exception, this.log);
        }
    }

    public boolean verify(String string, SSLSession sSLSession) {
        boolean bl;
        LdapName ldapName;
        Object object;
        Object object2;
        ArrayList<String> arrayList22;
        List<ArrayList<String>> list;
        Serializable serializable;
        String string2;
        X509Certificate[] x509CertificateArray;
        try {
            x509CertificateArray = (X509Certificate[])sSLSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            this.logDebug("Unable to parse X509Certificate for hostname " + string, sSLPeerUnverifiedException);
            return false;
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            this.logDebug("No certificates found for hostname " + string);
            return false;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            string2 = string.substring(1, string.length() - 1);
            this.logDebug(String.format("hostname is ipv6 format: %s", string2));
        } else {
            try {
                serializable = Class.forName("java.net.IDN");
                list = ((Class)serializable).getMethod("toASCII", String.class);
                string2 = (String)((Method)((Object)list)).invoke(null, string);
                this.logDebug(String.format("Canonical host name for %s is %s", string, string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logDebug("IDN not supported in this Java runtime, unicode hostname is not supported; will fall back to use hostname:" + string + " directly");
                string2 = string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logDebug("Hostname " + string + " is invalid", illegalArgumentException);
                return false;
            }
            catch (Exception exception) {
                this.logDebug("unknown exception", exception);
                return false;
            }
        }
        serializable = x509CertificateArray[0];
        try {
            list = ((X509Certificate)serializable).getSubjectAlternativeNames();
            if (list == null) {
                list = Collections.emptyList();
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            this.logDebug("Unable to parse certificates for hostname " + string, certificateParsingException);
            return false;
        }
        boolean bl2 = false;
        for (ArrayList<String> arrayList22 : list) {
            if (arrayList22.size() != 2) {
                this.logDebug("Invalid subject alternative name object");
                continue;
            }
            object2 = (Integer)arrayList22.get(0);
            if (object2 == null) continue;
            if ((Integer)object2 != 7 && (Integer)object2 != 2) {
                this.logDebug("Invalid subject Alternative Name type");
                continue;
            }
            object = (String)arrayList22.get(1);
            if ((Integer)object2 == 7 && ((String)object).startsWith("*")) {
                this.logDebug("Wildcards should not be present in the IP Address field");
                continue;
            }
            bl2 |= (Integer)object2 == 2;
            if (!this.verifyHostName(string2, (String)object)) continue;
            this.logDebug(String.format("Server name validation pass for %s, subjectAltName %s", string, object));
            return true;
        }
        if (bl2) {
            this.logDebug("Server name validation failed: certificate for host " + string + " dNSName entries subjectAltName," + " but none of them match. Assuming server name validation failed");
            return false;
        }
        try {
            ldapName = new LdapName(((X509Certificate)serializable).getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException invalidNameException) {
            this.logDebug("Server name validation failed: unable to extract common name from X509Certificate for hostname " + string, invalidNameException);
            return false;
        }
        arrayList22 = new ArrayList<String>(1);
        object2 = ldapName.getRdns().iterator();
        while (object2.hasNext()) {
            object = (Rdn)object2.next();
            if (!"CN".equals(((Rdn)object).getType())) continue;
            arrayList22.add((String)((Rdn)object).getValue());
        }
        if (arrayList22.isEmpty()) {
            this.logDebug("Server name validation failed: certificate for hostname " + string + " has no DNS subjectAltNames," + " and it CommonName is missing as well");
            return false;
        }
        if (arrayList22.size() > 1) {
            Collections.sort(arrayList22, HOSTNAME_PATTERN_COMPARATOR);
        }
        if (!(bl = this.verifyHostName(string2, (String)(object2 = (String)arrayList22.get(arrayList22.size() - 1))))) {
            this.logDebug(String.format("Server name validation failed: hostname %s does not match common name %s", string, object2));
        }
        return bl;
    }

    public boolean verifyHostName(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.lastIndexOf(42);
        if (n == -1) {
            return string.equalsIgnoreCase(string2);
        }
        if (n > 0) {
            return false;
        }
        if (string2.indexOf(46) == -1) {
            return false;
        }
        if (string.length() < string2.length() - 1) {
            return false;
        }
        int n2 = string.length() - string2.length() + 1;
        if (string.lastIndexOf(46, n2 - 1) >= 0) {
            return false;
        }
        return string.regionMatches(true, n2, string2, 1, string2.length() - 1);
    }
}

