/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemEncodedStream;
import com.nuodb.jdbc.RemPreparedStatement;
import com.nuodb.jdbc.RemResultSetMetaData;
import com.nuodb.jdbc.RemStatement;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.TypeInfo;
import com.nuodb.jdbc.Utils;
import com.nuodb.jdbc.Value;
import com.nuodb.jdbc.logger.Logger;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class RemResultSet
implements ResultSet {
    private static final String READ_ONLY_MESSAGE = "Result set is read-only";
    private static final String FETCH_FORWARD_ONLY_MESSAGE = "Result set is forward-only";
    private final RemConnection connection;
    private final Logger logger;
    private final int handle;
    private int columnCount;
    private String[] columnNames;
    private Value[] values;
    private boolean lastValueNull;
    private RemResultSetMetaData metaData;
    private RemStatement statement;
    private EncodedDataStream pendingRows;
    private SQLWarning warnings;
    private volatile boolean closed = false;
    private volatile int currentRow = 0;
    private volatile boolean afterLast = false;
    private Map<Integer, TypeInfo> typeInfos;
    private int fetchSize;
    private int fetchDirection;
    private Integer holdability = null;

    RemResultSet(RemConnection connection, int handle, EncodedDataStream dataStream, RemStatement statement, boolean readColumnNames) throws java.sql.SQLException {
        this.connection = connection;
        this.handle = handle;
        this.columnCount = dataStream.getInt();
        this.statement = statement;
        this.logger = connection.getLogger();
        this.fetchSize = statement != null ? statement.getFetchSize() : 0;
        this.fetchDirection = statement != null ? statement.getFetchDirection() : 1000;
        this.values = new Value[this.columnCount];
        if (readColumnNames) {
            this.columnNames = new String[this.columnCount];
            for (int n = 0; n < this.columnCount; ++n) {
                this.columnNames[n] = dataStream.getString();
            }
        } else {
            this.columnNames = ((RemPreparedStatement)statement).columnNames;
        }
        this.pendingRows = dataStream;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Opened result set #%d", handle));
        }
    }

    @Override
    public boolean absolute(int row) throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public void afterLast() throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public void beforeFirst() throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public void cancelRowUpdates() throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void clearWarnings() throws java.sql.SQLException {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws java.sql.SQLException {
        RemResultSet remResultSet = this;
        synchronized (remResultSet) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Closing result set #%d", this.handle));
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(28);
        dataStream.encodeInt(this.handle);
        this.connection.sendAsync(dataStream);
        if (this.statement == null) {
            this.connection.metaDataResultSetClosed(this);
        } else {
            this.statement.resultSetClosed(this);
        }
        this.statement = null;
        this.metaData = null;
        this.typeInfos = null;
    }

    void checkOpen() throws java.sql.SQLException {
        if (this.closed) {
            throw new java.sql.SQLException("Result set is closed");
        }
    }

    void checkAccess() throws java.sql.SQLException {
        this.checkOpen();
        if (this.currentRow == 0) {
            throw new java.sql.SQLException("Before start of result set");
        }
        if (this.afterLast) {
            throw new java.sql.SQLException("After end of result set");
        }
    }

    @Override
    public void deleteRow() throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public int findColumn(String columnLabel) throws java.sql.SQLException {
        this.checkOpen();
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!this.columnNames[i].equalsIgnoreCase(columnLabel)) continue;
            return i + 1;
        }
        throw new java.sql.SQLException("Column not found: " + columnLabel);
    }

    @Override
    public boolean first() throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public Array getArray(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Array getArray(String columnLabel) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getAsciiStream(this.connection.getSQLContext());
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws java.sql.SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getBigDecimal(this.getTypeInfo(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws java.sql.SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws java.sql.SQLException {
        BigDecimal result = this.getValue(columnIndex).getBigDecimal();
        return result == null ? null : result.setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws java.sql.SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getInputStream();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws java.sql.SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getBlob(this.connection.getSQLContext());
    }

    @Override
    public Blob getBlob(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getBlob(this.connection.getSQLContext());
    }

    @Override
    public boolean getBoolean(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getBoolean();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getByte();
    }

    @Override
    public byte getByte(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getByte();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getBytes(this.connection.getSQLContext());
    }

    @Override
    public byte[] getBytes(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getBytes(this.connection.getSQLContext());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getCharacterStream(this.connection.getSQLContext());
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws java.sql.SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getClob(this.connection.getSQLContext());
    }

    @Override
    public Clob getClob(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getClob(this.connection.getSQLContext());
    }

    @Override
    public int getConcurrency() throws java.sql.SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getDate(this.connection.getSQLContext());
    }

    @Override
    public Date getDate(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getDate(this.connection.getSQLContext());
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws java.sql.SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws java.sql.SQLException {
        return this.getDate(columnLabel);
    }

    @Override
    public double getDouble(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getDouble();
    }

    @Override
    public double getDouble(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getDouble();
    }

    @Override
    public int getFetchDirection() throws java.sql.SQLException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws java.sql.SQLException {
        return this.fetchSize;
    }

    @Override
    public float getFloat(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getFloat();
    }

    @Override
    public float getFloat(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getFloat();
    }

    @Override
    public int getHoldability() throws java.sql.SQLException {
        if (this.connection.protocolVersion < 24) {
            return 2;
        }
        if (this.holdability == null) {
            RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
            dataStream.startMessage(132);
            dataStream.encodeInt(this.handle);
            this.connection.sendAndReceive(dataStream);
            this.holdability = dataStream.getInt();
        }
        return this.holdability;
    }

    @Override
    public int getInt(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getInt();
    }

    @Override
    public int getInt(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getInt();
    }

    @Override
    public long getLong(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getLong();
    }

    @Override
    public long getLong(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getLong();
    }

    @Override
    public ResultSetMetaData getMetaData() throws java.sql.SQLException {
        if (this.metaData == null) {
            this.metaData = new RemResultSetMetaData(this);
        }
        return this.metaData;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public String getNString(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getObject(this.getTypeInfo(columnIndex), this.connection.getSQLContext());
    }

    @Override
    public Object getObject(String columnLabel) throws java.sql.SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws java.sql.SQLException {
        if (map.isEmpty()) {
            return this.getObject(columnIndex);
        }
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws java.sql.SQLException {
        if (map.isEmpty()) {
            return this.getObject(columnLabel);
        }
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws java.sql.SQLException {
        TypeInfo typeInfo = this.getTypeInfo(columnIndex);
        return this.getValue(columnIndex).getRef(typeInfo);
    }

    private TypeInfo getTypeInfo(int columnIndex) throws java.sql.SQLException {
        this.checkColumn(columnIndex);
        if (this.typeInfos == null) {
            this.typeInfos = new HashMap<Integer, TypeInfo>();
            ResultSetMetaData resultSetMetaData = this.getMetaData();
            for (int index = 0; index < this.columnCount; ++index) {
                int column = index + 1;
                TypeInfo typeInfo = new TypeInfo(resultSetMetaData.getColumnType(column), resultSetMetaData.getColumnTypeName(column), resultSetMetaData.getScale(column));
                this.typeInfos.put(column, typeInfo);
            }
        }
        return this.typeInfos.get(columnIndex);
    }

    private void checkColumn(int columnIndex) throws java.sql.SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw new java.sql.SQLException(String.format("Column index of %d out of bounds. Valid range 1-%d", columnIndex, this.columnCount));
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws java.sql.SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public int getRow() throws java.sql.SQLException {
        return this.currentRow;
    }

    @Override
    public RowId getRowId(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws java.sql.SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public short getShort(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getShort();
    }

    @Override
    public short getShort(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getShort();
    }

    @Override
    public Statement getStatement() throws java.sql.SQLException {
        return this.statement;
    }

    private String getStringHelper(Value val, int fieldScale) throws java.sql.SQLException {
        int valScale = val.getScale();
        if (valScale < fieldScale) {
            return val.getZeroPaddedString(fieldScale - valScale, this.connection.getSQLContext());
        }
        return val.getString(this.connection.getSQLContext());
    }

    @Override
    public String getString(int columnIndex) throws java.sql.SQLException {
        if (this.getMetaData().getColumnType(columnIndex) == 2) {
            Object o = this.getObject(columnIndex);
            return o == null ? null : o.toString();
        }
        return this.getStringHelper(this.getValue(columnIndex), this.getMetaData().getScale(columnIndex));
    }

    @Override
    public String getString(String columnLabel) throws java.sql.SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getTime(this.connection.getSQLContext());
    }

    @Override
    public Time getTime(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getTime(this.connection.getSQLContext());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws java.sql.SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws java.sql.SQLException {
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws java.sql.SQLException {
        return this.getValue(columnIndex).getTimestamp(this.connection.getSQLContext());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws java.sql.SQLException {
        return this.getValue(columnLabel).getTimestamp(this.connection.getSQLContext());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws java.sql.SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws java.sql.SQLException {
        return this.getTimestamp(columnLabel);
    }

    @Override
    public int getType() throws java.sql.SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public URL getURL(String columnLabel) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws java.sql.SQLException {
        this.checkOpen();
        return this.warnings;
    }

    @Override
    public void insertRow() throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean isAfterLast() throws java.sql.SQLException {
        return this.afterLast;
    }

    @Override
    public boolean isBeforeFirst() throws java.sql.SQLException {
        return this.currentRow == 0;
    }

    @Override
    public boolean isClosed() throws java.sql.SQLException {
        return this.closed;
    }

    @Override
    public boolean isFirst() throws java.sql.SQLException {
        return this.currentRow == 1;
    }

    @Override
    public boolean isLast() throws java.sql.SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean last() throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public void moveToCurrentRow() throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public void moveToInsertRow() throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public boolean next() throws java.sql.SQLException {
        int maxRows;
        this.checkOpen();
        int n = maxRows = this.statement == null ? 0 : this.statement.getMaxRows();
        while (true) {
            if (maxRows > 0 && this.currentRow >= maxRows) {
                this.afterLast = true;
                return false;
            }
            if (!this.pendingRows.isEndOfMessage()) {
                int result = this.pendingRows.getInt();
                if (result == 0) {
                    this.afterLast = true;
                    return false;
                }
                ++this.currentRow;
                for (int n2 = 0; n2 < this.columnCount; ++n2) {
                    Value value = this.pendingRows.getValue();
                    value.setResultSet(this);
                    this.values[n2] = value;
                }
                this.clearWarnings();
                return true;
            }
            this.pendingRows = new RemEncodedStream(this.connection.protocolVersion);
            this.pendingRows.startMessage(27);
            this.pendingRows.encodeInt(this.handle);
            this.connection.sendAndReceive(this.pendingRows);
        }
    }

    @Override
    public boolean previous() throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public void refreshRow() throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean relative(int rows) throws java.sql.SQLException {
        throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
    }

    @Override
    public boolean rowDeleted() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws java.sql.SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws java.sql.SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws java.sql.SQLException {
        if (fetchDirection != 1000) {
            throw new java.sql.SQLException(FETCH_FORWARD_ONLY_MESSAGE);
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws java.sql.SQLException {
        if (fetchSize < 0) {
            throw new SQLException("Fetch size must be equal to or greater than 0", SQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.connection.protocolVersion >= 19) {
            this.checkOpen();
            RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
            dataStream.startMessage(123);
            dataStream.encodeInt(this.handle);
            dataStream.encodeInt(fetchSize);
            this.connection.sendAndReceive(dataStream);
        } else if (fetchSize != 0) {
            throw new SQLFeatureNotSupportedException("Non-default fetch size value is not supported");
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNString(int columnIndex, String string) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNString(String columnLabel, String string) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNull(int columnIndex) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateNull(String columnLabel) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateRow() throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateString(int columnIndex, String x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateString(String columnLabel, String x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws java.sql.SQLException {
        throw new java.sql.SQLException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean wasNull() throws java.sql.SQLException {
        return this.lastValueNull;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws java.sql.SQLException {
        Utils.notYetImplemented();
        return null;
    }

    Value getValue(int columnIndex) throws java.sql.SQLException {
        this.checkAccess();
        this.checkColumn(columnIndex);
        Value value = this.values[columnIndex - 1];
        this.lastValueNull = value == null || value.getType() == 0;
        return value;
    }

    Value getValue(String columnName) throws java.sql.SQLException {
        return this.getValue(this.findColumn(columnName));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws java.sql.SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws java.sql.SQLException {
        return null;
    }

    public RemConnection getConnection() {
        return this.connection;
    }

    public int getHandle() {
        return this.handle;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

