/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractGroupTableModel;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.IndexedRowTableModelWrapper;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.WrapperOfIndexdRowTableModelWrapper;
import com.jidesoft.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;

public class SortableTreeTableModel<T extends Row>
extends SortableTableModel
implements ITreeTableModel<T> {
    public static final int SORTABLE_NONE = 0;
    public static final int SORTABLE_ROOT_LEVEL = 1;
    public static final int SORTABLE_LEAF_LEVEL = 2;
    public static final int SORTABLE_NON_ROOT_LEVEL = 4;
    public static final int SORTABLE_NON_LEAF_LEVEL = 8;
    public static final int SORTABLE_ALL_LEVELS = 255;
    private int \u0d2f = 255;
    private int[] \u0d2e;
    public TableModel _actualTableModel;
    private List<ISortableTableModel.SortItem> \u0d2d;
    private static final long \u0d2b = 1560212793146645991L;
    private static final Logger \u0d2c = Logger.getLogger(SortableTreeTableModel.class.getName());

    public SortableTreeTableModel(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    protected void cacheComparators() {
        this.\u0d2d = new ArrayList<ISortableTableModel.SortItem>();
        this.\u0d2d.addAll(super.getSortingColumns());
        super.cacheComparators();
    }

    @Override
    public List<ISortableTableModel.SortItem> getSortingColumns() {
        if (this.\u0d2d != null && this.\u0d2d.size() > 0) {
            return this.\u0d2d;
        }
        return super.getSortingColumns();
    }

    @Override
    protected void sort() {
        try {
            this._actualTableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
            super.sort();
        }
        finally {
            this._actualTableModel = null;
        }
    }

    @Override
    protected int compare(int n2, int n3) {
        if (this._actualTableModel == null) {
            this._actualTableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
            if (this._actualTableModel == null) {
                return super.compare(n2, n3);
            }
        }
        if (this._actualTableModel instanceof DefaultGroupTableModel && !((DefaultGroupTableModel)this._actualTableModel).hasGroupColumns()) {
            return super.compare(n2, n3);
        }
        List<ISortableTableModel.SortItem> list = this.getSortingColumns();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ISortableTableModel.SortItem sortItem = list.get(i2);
            int n4 = sortItem.getColumn();
            if (n4 < 0 || n4 >= this.getColumnCount()) continue;
            int n5 = this.compare(n2, n3, n4);
            if (n5 == Integer.MAX_VALUE) {
                return 1;
            }
            if (n5 == Integer.MIN_VALUE) {
                return -1;
            }
            if (n5 == 0) continue;
            return sortItem.isAscending() ? n5 : -n5;
        }
        return n2 < n3 ? -1 : 1;
    }

    @Override
    public int compare(int n2, int n3, int n4) {
        if (this._actualTableModel == null) {
            this._actualTableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
            if (this._actualTableModel == null) {
                return super.compare(n2, n3, n4);
            }
        }
        if (this._actualTableModel instanceof AbstractGroupTableModel && !((AbstractGroupTableModel)this._actualTableModel).isGroupEnabled()) {
            return super.compare(n2, n3, n4);
        }
        int n5 = this.getSortableOption(n4);
        if (n5 == 0) {
            return 0;
        }
        if (!(this._actualTableModel instanceof IExpandableTreeTableModel)) {
            return 0;
        }
        IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)this._actualTableModel);
        Row row = iExpandableTreeTableModel.getRowAt(TableModelWrapperUtils.getActualRowAt(this._model, n2, (TableModel)((Object)iExpandableTreeTableModel)));
        Row row2 = iExpandableTreeTableModel.getRowAt(TableModelWrapperUtils.getActualRowAt(this._model, n3, (TableModel)((Object)iExpandableTreeTableModel)));
        return this.\u0101(row, row2, iExpandableTreeTableModel, n5, n4);
    }

    protected boolean shouldCompare(int n2, Row row, Row row2, boolean bl, boolean bl2, boolean bl3, int n3) {
        return bl && n2 == 1 || !bl && n2 == 4 || bl2 && bl3 && n2 == 2 || !bl2 && !bl3 && n2 == 8 || n2 == 255;
    }

    private int \u0101(Row row, Row row2, IExpandableTreeTableModel iExpandableTreeTableModel, int n2, int n3) {
        boolean bl;
        int n4;
        if (row == null && row2 == null) {
            return 0;
        }
        if (row != null && row2 == null) {
            return 1;
        }
        if (row == null) {
            return -1;
        }
        int n5 = row.getLevel();
        if (n5 > (n4 = row2.getLevel())) {
            while (n5 != n4) {
                row = (Row)((Object)row.getParent());
                --n5;
                if (row != row2) continue;
                return Integer.MAX_VALUE;
            }
        } else if (n4 > n5) {
            while (n4 != n5) {
                row2 = (Row)((Object)row2.getParent());
                --n4;
                if (row2 != row) continue;
                return Integer.MIN_VALUE;
            }
        }
        if (row.getParent() != row2.getParent()) {
            return this.\u0101((Row)((Object)row.getParent()), (Row)((Object)row2.getParent()), iExpandableTreeTableModel, n2, n3);
        }
        boolean bl2 = !(row instanceof Expandable) || !((Expandable)((Object)row)).hasChildren();
        boolean bl3 = !(row2 instanceof Expandable) || !((Expandable)((Object)row2)).hasChildren();
        boolean bl4 = bl = row.getParent() == iExpandableTreeTableModel.getRoot();
        if (this.shouldCompare(n2, row, row2, bl, bl2, bl3, n3)) {
            Object object = this.getValueAt(row, n3);
            Object object2 = this.getValueAt(row2, n3);
            return this.compare(object, object2, n3);
        }
        return 0;
    }

    protected Object getValueAt(Row row, int n2) {
        int n3;
        if (row == null) {
            return null;
        }
        int n4 = TableModelWrapperUtils.getActualColumnAt((TableModel)this, n2, IExpandableTreeTableModel.class);
        if (n4 >= 0) {
            return row.getValueAt(n4);
        }
        if (this.getActualModel() instanceof ITreeTableModel && (n3 = ((ITreeTableModel)((Object)this.getActualModel())).getRowIndex(row)) >= 0 && n3 < this.getActualModel().getRowCount()) {
            return this.getActualModel().getValueAt(n3, n2);
        }
        return null;
    }

    public int getDefaultSortableOption() {
        return this.\u0d2f;
    }

    public void setDefaultSortableOption(int n2) {
        this.\u0d2f = n2;
    }

    public void setSortableOption(int n2, int n3) {
        if (this.\u0d2e == null || this.\u0d2e.length != this.getActualModel().getColumnCount()) {
            this.\u0d2e = new int[this.getActualModel().getColumnCount()];
            Arrays.fill(this.\u0d2e, -1);
        }
        if (this.\u0d2e != null && n2 >= 0 && n2 < this.\u0d2e.length) {
            this.\u0d2e[n2] = n3;
        }
    }

    public int getSortableOption(int n2) {
        if (this.\u0d2e != null && n2 >= 0 && n2 < this.\u0d2e.length) {
            int n3 = this.\u0d2e[n2];
            if (n3 == -1) {
                return this.getDefaultSortableOption();
            }
            return n3;
        }
        return this.getDefaultSortableOption();
    }

    @Override
    protected int[] append(int n2, int n3) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
        TableModel tableModel2 = TableModelWrapperUtils.getNextInnerTableModel(this);
        if (tableModel instanceof IExpandableTreeTableModel) {
            int n4;
            if (this._indexes == null) {
                return new int[]{n2, n3};
            }
            Row row = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(TableModelWrapperUtils.getActualRowAt(tableModel2, n2, IExpandableTreeTableModel.class));
            while (row == null && n2 < n3) {
                if (\u0d2c.isLoggable(Level.FINE)) {
                    \u0d2c.fine("SortableTreeTableModel \" append() get invalid row index input " + n2 + ", " + n3 + ".");
                }
                row = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(TableModelWrapperUtils.getActualRowAt(tableModel2, ++n2, IExpandableTreeTableModel.class));
            }
            if (row == null) {
                if (\u0d2c.isLoggable(Level.FINE)) {
                    \u0d2c.fine("SortableTreeTableModel \" append() have to return null array.");
                }
                return new int[0];
            }
            Row row2 = (Row)((Object)row.getParent());
            int n5 = ((IExpandableTreeTableModel)((Object)tableModel)).getRowIndex(row2);
            int n6 = TableModelWrapperUtils.getRowAt(this, n5);
            int n7 = n3 - n2 + 1;
            int n8 = n6 >= 0 && n6 < this.getRowCount() || n5 == -1 ? ("true".equals(SecurityUtils.getProperty("jide.sortableTableModel.append", "true")) ? n6 + TableModelWrapperUtils.getVisibleChildrenCount(this.getActualModel(), row2) - n7 + 1 : n6 + 1) : this.getRowCount();
            for (int i2 = 0; i2 < this._indexes.length; ++i2) {
                n4 = this._indexes[i2];
                if (n4 < n2) continue;
                this._indexes[i2] = n4 + n7;
            }
            int[] nArray = (int[])this._indexes.clone();
            this._indexes = new int[nArray.length + n7];
            System.arraycopy(nArray, 0, this._indexes, 0, n8);
            for (n4 = 0; n4 < n7; ++n4) {
                this._indexes[n8 + n4] = n2 + n4;
            }
            System.arraycopy(nArray, n8, this._indexes, n8 + n7, nArray.length - n8);
            return new int[]{n8, n8 + n7 - 1};
        }
        return super.append(n2, n3);
    }

    @Override
    public Row getRowAt(int n2) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return null;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        int n3 = TableModelWrapperUtils.getActualRowAt((TableModel)this, n2, tableModel);
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            n3 = indexedRowTableModelWrapper.getActualRowAt(n3);
        }
        return iTreeTableModel.getRowAt(n3);
    }

    @Override
    public int getRowIndex(T t2) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return -1;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        int n2 = iTreeTableModel.getRowIndex(t2);
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            n2 = indexedRowTableModelWrapper.getVisualRowAt(n2);
        }
        return this.getVisualRowAt(n2);
    }

    @Override
    public Object getRoot() {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return -1;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        return iTreeTableModel.getRoot();
    }
}

