/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gauge;

import com.jidesoft.chart.axis.NumericTickCalculator;
import com.jidesoft.chart.axis.SimpleNumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.gauge.AbstractGaugeTickStyle;
import com.jidesoft.range.NumericRange;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.UIManager;

public class AbstractNumericGaugeAxis<TickStyle extends AbstractGaugeTickStyle> {
    public static final String PROPERTY_RANGE = "Range";
    public static final String PROPERTY_MAJOR_TICK_STYLE = "MajorTickStyle";
    public static final String PROPERTY_MINOR_TICK_STYLE = "MinorTickStyle";
    public static final String PROPERTY_MAJOR_TICK = "MajorTick";
    public static final String PROPERTY_MINOR_TICK = "MinorTick";
    private NumericTickCalculator \u0106;
    protected NumericRange range;
    private TickStyle \u0103;
    private TickStyle \u0104;
    protected double majorTickInterval;
    protected double minorTickInterval;
    private Font \u0102 = UIManager.getFont("Label.font");
    private Color \u0105 = Color.black;
    private Tick[] \u0108;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private NumberFormat \u0107 = null;

    public AbstractNumericGaugeAxis() {
        this(0.0, 100.0, 10.0, 2.0);
    }

    public AbstractNumericGaugeAxis(double d2, double d3) {
        this(d2, d3, (d3 - d2) / 10.0, (d3 - d2) / 20.0);
    }

    public AbstractNumericGaugeAxis(double d2, double d3, double d4, double d5) {
        this.minorTickInterval = d5;
        this.range = new NumericRange(d2, d3);
        this.majorTickInterval = d4;
        this.updateTicks();
    }

    public void setRange(double d2, double d3) {
        NumericRange numericRange = this.range;
        this.range = new NumericRange(d2, d3);
        this.\u0108 = null;
        this.support.firePropertyChange(PROPERTY_RANGE, numericRange, this.range);
    }

    public void setRange(NumericRange numericRange) {
        NumericRange numericRange2 = this.range;
        this.range = numericRange;
        this.\u0108 = null;
        this.support.firePropertyChange(PROPERTY_RANGE, numericRange2, numericRange);
    }

    public NumericRange getRange() {
        return this.range;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public double getMajorTickInterval() {
        return this.majorTickInterval;
    }

    public void setMajorTickInterval(double d2) {
        double d3 = this.majorTickInterval;
        this.majorTickInterval = d2;
        this.updateTicks();
        this.support.firePropertyChange(PROPERTY_MAJOR_TICK, d3, d2);
    }

    public double getMinorTickInterval() {
        return this.minorTickInterval;
    }

    public void setMinorTickInterval(double d2) {
        double d3 = this.minorTickInterval;
        this.minorTickInterval = d2;
        this.updateTicks();
        this.support.firePropertyChange(PROPERTY_MINOR_TICK, d3, d2);
    }

    public NumberFormat getNumberFormat() {
        return this.\u0107;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.\u0107 = numberFormat;
    }

    protected void updateTicks() {
        assert (this.range != null);
        if (this.range.minimum() == this.range.maximum()) {
            this.\u0108 = new Tick[0];
        } else {
            this.\u0106 = this.createTickCalculator(this.range.minimum(), this.range.maximum(), this.majorTickInterval, this.minorTickInterval);
            this.\u0108 = this.\u0106 == null ? new Tick[0] : this.\u0106.calculateTicks(this.range);
        }
    }

    protected NumericTickCalculator createTickCalculator(double d2, double d3, double d4, double d5) {
        SimpleNumericTickCalculator simpleNumericTickCalculator = new SimpleNumericTickCalculator(this.range.minimum(), d4, d5);
        if (this.\u0107 != null) {
            simpleNumericTickCalculator.setNumberFormat(this.\u0107);
        }
        return simpleNumericTickCalculator;
    }

    public List<Tick> ticks() {
        assert (this.range != null);
        if (this.\u0108 == null) {
            this.updateTicks();
        }
        return Arrays.asList(this.\u0108);
    }

    public double minimum() {
        return this.range.minimum();
    }

    public double maximum() {
        return this.range.maximum();
    }

    public TickStyle getMajorTickStyle() {
        return this.\u0103;
    }

    public void setMajorTickStyle(TickStyle TickStyle) {
        TickStyle TickStyle2 = this.\u0103;
        this.\u0103 = TickStyle;
        this.support.firePropertyChange(PROPERTY_MAJOR_TICK_STYLE, TickStyle2, TickStyle);
    }

    public TickStyle getMinorTickStyle() {
        return this.\u0104;
    }

    public void setMinorTickStyle(TickStyle TickStyle) {
        TickStyle TickStyle2 = this.\u0104;
        this.\u0104 = TickStyle;
        this.support.firePropertyChange(PROPERTY_MINOR_TICK_STYLE, TickStyle2, TickStyle);
    }

    public Font getTickLabelFont() {
        return this.\u0102;
    }

    public void setTickLabelFont(Font font) {
        this.\u0102 = font;
    }

    public Color getTickLabelColor() {
        return this.\u0105;
    }

    public void setTickLabelColor(Color color) {
        this.\u0105 = color;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#<AbstractGaugeAxis");
        stringBuilder.append(" range=").append(this.range);
        stringBuilder.append('>');
        return stringBuilder.toString();
    }
}

