/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.JYButtonIcon;
import de.javasoft.swing.WidgetUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.synth.SynthContext;

public class JYScrollPaneMap
extends JButton {
    private JScrollPane scroller;
    private JComponent view;
    private Icon icon;
    private JPopupMenu popupMenu;
    private PopupContent popupContent;
    private BufferedImage previewImage;
    private Rectangle startRect;
    private Rectangle previewRect;
    private Point startPoint;
    private Point oldPoint;
    private double scaleFactor;
    private MouseHandler mouseHandler;
    private PropertyChangeListener propertyChangeListener;
    private ContainerAdapter viewPortViewListener;

    public JYScrollPaneMap(JScrollPane jScrollPane) {
        this.scroller = jScrollPane;
        this.view = this.getView(this.scroller);
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setName("JYScrollPaneMap");
        this.install();
    }

    private JComponent getView(JScrollPane jScrollPane) {
        Component component = jScrollPane.getViewport().getView();
        return component instanceof JComponent ? (JComponent)component : null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getDisabledIcon() {
        return this.getIcon();
    }

    public void updateUI() {
        super.updateUI();
        this.setDefaults();
    }

    protected void setDefaults() {
        Insets insets = SyntheticaLookAndFeel.getInsets("JYScrollPaneMap.insets", (Component)this, new Insets(2, 2, 0, 0));
        this.setBorder(new WidgetUtils.OrientationAwareEmptyBorderUIResource(insets));
        this.icon = this.createIcon();
    }

    protected Icon createIcon() {
        String string = "JYScrollPaneMap.icon";
        return new JYButtonIcon(this, string, 12, 12){

            public void paintFallback2DIcon(SynthContext synthContext, SyntheticaState syntheticaState, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                graphics2D.setPaint(JYScrollPaneMap.this.getIconPaintColor(syntheticaState));
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(1.0f, 1.0f);
                generalPath.lineTo(10.0f, 1.0f);
                generalPath.lineTo(10.0f, 10.0f);
                generalPath.lineTo(1.0f, 10.0f);
                generalPath.lineTo(1.0f, 1.0f);
                generalPath.moveTo(3.0f, 4.0f);
                generalPath.lineTo(8.0f, 4.0f);
                generalPath.lineTo(8.0f, 7.0f);
                generalPath.lineTo(3.0f, 7.0f);
                generalPath.closePath();
                graphics2D.draw(generalPath);
            }

            protected BasicStroke createStroke(SynthContext synthContext) {
                return new BasicStroke(1.2f);
            }
        };
    }

    private Color getIconPaintColor(SyntheticaState syntheticaState) {
        Color color = UIManager.getColor("Label.foreground");
        if (syntheticaState.isSet(SyntheticaState.State.DISABLED)) {
            color = new Color(0xAAAAAA);
        } else if (!syntheticaState.isSet(SyntheticaState.State.PRESSED) && syntheticaState.isSet(SyntheticaState.State.HOVER)) {
            int n = 0xAA000000 | color.getRGB() & 0xFFFFFF;
            color = new Color(n, true);
        }
        return color;
    }

    private void install() {
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("componentOrientation".equals(string)) {
                    JYScrollPaneMap.this.scroller.setCorner("LOWER_LEADING_CORNER", null);
                    JYScrollPaneMap.this.scroller = (JScrollPane)propertyChangeEvent.getSource();
                    JYScrollPaneMap.this.view = JYScrollPaneMap.this.getView(JYScrollPaneMap.this.scroller);
                    JYScrollPaneMap.this.install();
                    JYScrollPaneMap.this.scroller.setCorner("LOWER_TRAILING_CORNER", JYScrollPaneMap.this);
                } else if ("LOWER_RIGHT_CORNER".equals(string) || "LOWER_LEFT_CORNER".equals(string)) {
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object == JYScrollPaneMap.this && object2 != JYScrollPaneMap.this) {
                        JYScrollPaneMap.this.uninstall();
                    }
                }
            }
        };
        this.scroller.addPropertyChangeListener(this.propertyChangeListener);
        this.viewPortViewListener = new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                if (JYScrollPaneMap.this.popupMenu.isVisible()) {
                    JYScrollPaneMap.this.popupMenu.setVisible(false);
                }
                JYScrollPaneMap.this.view = JYScrollPaneMap.this.getView(JYScrollPaneMap.this.scroller);
            }
        };
        this.scroller.getViewport().addContainerListener(this.viewPortViewListener);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setName("JYScrollPaneMap.popup");
        this.popupMenu.setLayout(new BorderLayout());
        this.popupContent = new PopupContent();
        this.popupMenu.add((Component)this.popupContent, "Center");
        this.popupMenu.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("visible".equals(propertyChangeEvent.getPropertyName()) && !JYScrollPaneMap.this.popupMenu.isVisible()) {
                    JYScrollPaneMap.this.popupMenu.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    private void uninstall() {
        if (this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseHandler);
        this.scroller.removePropertyChangeListener(this.propertyChangeListener);
        this.scroller.getViewport().removeContainerListener(this.viewPortViewListener);
        this.scroller = null;
        this.view = null;
    }

    private void showPopup(Point point) {
        Point point2;
        if (this.view == null) {
            return;
        }
        Dimension dimension = this.getPreviewSize(this.view.getParent());
        double d = this.view.getWidth();
        double d2 = this.view.getHeight();
        double d3 = dimension.getWidth() / d;
        double d4 = dimension.getHeight() / d2;
        this.scaleFactor = Math.min(d3, d4);
        this.previewImage = WidgetUtils.createPreviewImage(this.view, this.scaleFactor, true);
        this.startRect = this.view.getVisibleRect();
        Insets insets = this.popupContent.getInsets();
        this.startRect.x = (int)(this.scaleFactor * (double)this.startRect.x + (double)insets.left);
        this.startRect.y = (int)(this.scaleFactor * (double)this.startRect.y + (double)insets.right);
        this.startRect.width = (int)((double)this.startRect.width * this.scaleFactor);
        this.startRect.height = (int)((double)this.startRect.height * this.scaleFactor);
        this.previewRect = this.startRect;
        Dimension dimension2 = this.popupMenu.getPreferredSize();
        Point point3 = this.getLocationOnScreen();
        Point point4 = new Point((this.getWidth() - dimension2.width) / 2, (this.getHeight() - dimension2.height) / 2);
        this.popupMenu.show(this, point4.x, point4.y);
        Window window = SwingUtilities.getWindowAncestor(this.popupMenu);
        if (window.getClass().getName().endsWith(".Popup$HeavyWeightWindow")) {
            point2 = window.getLocation();
            point4 = new Point(point2.x - point3.x, point2.y - point3.y);
        } else {
            point4 = SwingUtilities.convertPoint(this.popupMenu, new Point(0, 0), this);
        }
        point2 = new Point(point3.x + point4.x + this.previewRect.x + this.previewRect.width / 2, point3.y + point4.y + this.previewRect.y + this.previewRect.height / 2);
        try {
            new Robot().mouseMove(point2.x, point2.y);
            this.startPoint = point2;
        }
        catch (Exception exception) {
            this.startPoint = point;
            point4.x += this.startPoint.x - point2.x;
            point4.y += this.startPoint.y - point2.y;
            this.popupMenu.show(this, point4.x, point4.y);
        }
        this.oldPoint = new Point(this.startPoint);
        this.popupMenu.setCursor(Cursor.getPredefinedCursor(13));
    }

    private Dimension getPreviewSize(Container container) {
        Dimension dimension = SyntheticaLookAndFeel.getDim("JYScrollPaneMap.minPreviewSize", this, new Dimension(140, 70));
        if (container instanceof JViewport) {
            Dimension dimension2 = SyntheticaLookAndFeel.getDim("JYScrollPaneMap.maxPreviewSize", this, new Dimension(300, 200));
            Rectangle rectangle = ((JViewport)container).getViewRect();
            int n = Math.max(Math.min(rectangle.width / 3, dimension2.width), dimension.width);
            int n2 = Math.max(Math.min(rectangle.height / 3, dimension2.height), dimension.height);
            return new Dimension(n, n2);
        }
        return dimension;
    }

    private void scroll(int n, int n2) {
        if (this.view == null) {
            return;
        }
        Rectangle rectangle = this.view.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x + n, rectangle.y + n2, rectangle.width, rectangle.height);
        this.view.scrollRectToVisible(rectangle2);
        this.syncRectangle();
    }

    private void syncRectangle() {
        JViewport jViewport = this.scroller.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        Insets insets = this.popupContent.getInsets();
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = (int)(this.scaleFactor * (double)rectangle.x + (double)insets.left);
        rectangle2.y = (int)(this.scaleFactor * (double)rectangle.y + (double)insets.top);
        rectangle2.width = (int)((double)rectangle.width * this.scaleFactor);
        rectangle2.height = (int)((double)rectangle.height * this.scaleFactor);
        Rectangle rectangle3 = new Rectangle();
        Rectangle.union(this.previewRect, rectangle2, rectangle3);
        rectangle3.grow(2, 2);
        this.previewRect = rectangle2;
        this.popupContent.paintImmediately(rectangle3);
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, JYScrollPaneMap.this);
            JYScrollPaneMap.this.showPopup(point);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!JYScrollPaneMap.this.popupMenu.isVisible()) {
                return;
            }
            JYScrollPaneMap.this.popupMenu.setVisible(false);
            JYScrollPaneMap.this.startRect = JYScrollPaneMap.this.previewRect;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JYScrollPaneMap.this.startPoint == null || !JYScrollPaneMap.this.popupMenu.isShowing()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            Rectangle rectangle = new Rectangle(JYScrollPaneMap.this.popupMenu.getLocationOnScreen(), JYScrollPaneMap.this.popupMenu.getSize());
            if (!rectangle.contains(point)) {
                return;
            }
            int n = (int)((double)(point.x - ((JYScrollPaneMap)JYScrollPaneMap.this).oldPoint.x) / JYScrollPaneMap.this.scaleFactor);
            int n2 = (int)((double)(point.y - ((JYScrollPaneMap)JYScrollPaneMap.this).oldPoint.y) / JYScrollPaneMap.this.scaleFactor);
            JYScrollPaneMap.this.scroll(n, n2);
            JYScrollPaneMap.this.oldPoint = point;
        }
    }

    private class PopupContent
    extends JComponent {
        private PopupContent() {
        }

        public Dimension getPreferredSize() {
            if (JYScrollPaneMap.this.previewImage == null || JYScrollPaneMap.this.previewRect == null) {
                return new Dimension();
            }
            Insets insets = this.getInsets();
            return new Dimension(JYScrollPaneMap.this.previewImage.getWidth(null) + insets.left + insets.right, JYScrollPaneMap.this.previewImage.getHeight(null) + insets.top + insets.bottom);
        }

        protected void paintComponent(Graphics graphics) {
            if (JYScrollPaneMap.this.previewImage == null || JYScrollPaneMap.this.previewRect == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = this.getWidth() - insets.left - insets.right;
            int n4 = this.getHeight() - insets.top - insets.bottom;
            graphics2D.drawImage((Image)JYScrollPaneMap.this.previewImage, n, n2, null);
            Area area = new Area(new Rectangle(n, n2, n3, n4));
            area.subtract(new Area(JYScrollPaneMap.this.previewRect));
            graphics2D.setColor(SyntheticaLookAndFeel.getColor("JYScrollPaneMap.previewRect.background", JYScrollPaneMap.this, new Color(-2134061876, true)));
            graphics2D.fill(area);
            graphics2D.setColor(SyntheticaLookAndFeel.getColor("JYScrollPaneMap.previewRect.foreground", JYScrollPaneMap.this, UIManager.getColor("Label.foreground")));
            graphics2D.draw(JYScrollPaneMap.this.previewRect);
            graphics2D.dispose();
        }
    }
}

