/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSprite {
    private static boolean optimizedDrawingEnabled = Defs.booleanProperty("org.icepdf.core.text.optimized", true);
    private static final boolean OPTIMIZED_DRAWING_TYPE_3_ENABLED = Defs.booleanProperty("org.icepdf.core.text.optimized.type3", true);
    private ArrayList<GlyphText> glyphTexts;
    Rectangle2D.Float bounds;
    private AffineTransform graphicStateTransform;
    private AffineTransform tmTransform;
    private Color strokeColor;
    private int rmode;
    private FontFile font;
    private String fontName;
    private int fontSize;
    private static final String TYPE_3 = "Type3";

    public TextSprite(FontFile font, int contentLength, AffineTransform graphicStateTransform, AffineTransform tmTransform) {
        this.glyphTexts = new ArrayList(contentLength);
        this.graphicStateTransform = graphicStateTransform;
        this.tmTransform = tmTransform;
        this.font = font;
        if (optimizedDrawingEnabled && !OPTIMIZED_DRAWING_TYPE_3_ENABLED) {
            optimizedDrawingEnabled = font.getFormat() == null || !font.getFormat().equals(TYPE_3);
        }
        this.bounds = new Rectangle2D.Float();
    }

    public GlyphText addText(String cid, String unicode, float x, float y, float width) {
        float w = width;
        float h = (float)(this.font.getAscent() + this.font.getDescent());
        double descent = this.font.getDescent();
        double ascent = this.font.getAscent();
        if (h <= 0.0f) {
            h = (float)this.font.getMaxCharBounds().getHeight();
        }
        if (w <= 0.0f) {
            w = (float)this.font.getMaxCharBounds().getWidth();
        }
        if (h <= 0.0f) {
            Rectangle2D bounds = this.font.getEstringBounds(cid, 0, 1);
            h = bounds != null && bounds.getHeight() > 0.0 ? (float)bounds.getHeight() : this.font.getSize();
            if (ascent == 0.0) {
                ascent = h;
            }
        }
        Rectangle2D.Float glyphBounds = w < 0.0f || this.font.getSize() < 0.0f ? new Rectangle2D.Float(x + width, y - (float)descent, -w, h) : new Rectangle2D.Float(x, y - (float)ascent, w, h);
        this.bounds.add(glyphBounds);
        GlyphText glyphText = new GlyphText(x, y, glyphBounds, cid, unicode);
        glyphText.normalizeToUserSpace(this.graphicStateTransform, this.tmTransform);
        this.glyphTexts.add(glyphText);
        return glyphText;
    }

    public ArrayList<GlyphText> getGlyphSprites() {
        return this.glyphTexts;
    }

    public AffineTransform getGraphicStateTransform() {
        return this.graphicStateTransform;
    }

    public void setGraphicStateTransform(AffineTransform graphicStateTransform) {
        this.graphicStateTransform = graphicStateTransform;
        for (GlyphText sprite : this.glyphTexts) {
            sprite.normalizeToUserSpace(this.graphicStateTransform, this.tmTransform);
        }
    }

    public void setRMode(int rmode) {
        if (rmode >= 0) {
            this.rmode = rmode;
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder(this.glyphTexts.size());
        for (GlyphText glyphText : this.glyphTexts) {
            text.append(glyphText.getUnicode());
        }
        return text.toString();
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        for (GlyphText glyphText : this.glyphTexts) {
            this.font.drawEstring(g2d, glyphText.getCid(), glyphText.getX(), glyphText.getY(), 0L, this.rmode, this.strokeColor);
        }
    }

    public Area getGlyphOutline() {
        Area glyphOutline = null;
        for (GlyphText glyphText : this.glyphTexts) {
            if (glyphOutline != null) {
                glyphOutline.add(new Area(this.font.getEstringOutline(glyphText.getCid(), glyphText.getX(), glyphText.getY())));
                continue;
            }
            glyphOutline = new Area(this.font.getEstringOutline(glyphText.getCid(), glyphText.getX(), glyphText.getY()));
        }
        return glyphOutline;
    }

    public FontFile getFont() {
        return this.font;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean intersects(Shape shape) {
        return !optimizedDrawingEnabled || shape != null && shape.intersects(this.bounds);
    }
}

