/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.db.oracle;

import com.jidesoft.utils.SystemInfo;
import com.onseven.dbvis.util.o.b;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class OraTNSUtil {
    public static final String TNS_DIR_PROPERTY = "oracle.net.tns_admin";
    private static final Logger LOG = Logger.getLogger(OraTNSUtil.class.getName());

    public static String[] getAliases(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (!Pattern.matches("^[^\\s\\(\\)\\=#].*$", string) || !string.contains("=")) continue;
            arrayList.add(string.substring(0, string.indexOf("=")).trim());
        }
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        LOG.fine("Loaded " + arrayList.size() + " aliases from " + file.getAbsolutePath());
        String[] stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    public static String[] getAliases() throws IOException {
        String[] stringArray = new String[]{};
        String string = System.getProperty(TNS_DIR_PROPERTY);
        if (string != null) {
            stringArray = OraTNSUtil.getAliases(new File(string, "tnsnames.ora"));
        }
        return stringArray;
    }

    public static String getAliasesErrorMessage() {
        return b.b(OraTNSUtil.class, "OraTNSUtil.ErrorMessage", new Object[0]);
    }

    public static String getTNSDirectory() {
        Object object;
        String string = null;
        CaseInsensitiveMap caseInsensitiveMap = System.getenv();
        if (SystemInfo.isWindows()) {
            caseInsensitiveMap = new CaseInsensitiveMap(caseInsensitiveMap);
        }
        String string2 = caseInsensitiveMap.get("ORACLE_HOME");
        String string3 = (String)caseInsensitiveMap.get("TNS_ADMIN");
        if (string3 != null) {
            object = new File(string3, "tnsnames.ora");
            if (((File)object).exists()) {
                string = new File(string3).getAbsolutePath();
                return string;
            }
            LOG.log(Level.INFO, "Could not read tnsnames.ora '" + ((File)object).getAbsolutePath() + "' using TNS_ADMIN. Trying ORACLE_HOME");
        } else {
            LOG.log(Level.INFO, "The TNS_ADMIN environment variable is not set. Trying ORACLE_HOME");
        }
        if (string2 != null) {
            object = System.getProperty("file.separator");
            String string4 = (String)object + "network" + (String)object + "admin";
            File file = new File(string2 + string4, "tnsnames.ora");
            if (file.exists()) {
                string = new File(string2 + string4).getAbsolutePath();
            } else {
                LOG.log(Level.INFO, "Could not find tnsnames.ora file '" + file.getAbsolutePath() + "' using ORACLE_HOME");
            }
        } else {
            LOG.log(Level.INFO, "The ORACLE_HOME environment variable is not set. TNS names cannot be used for Oracle connections");
        }
        return string;
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Aliases: " + OraTNSUtil.getAliases(new File(stringArray[0])));
    }
}

