/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaDefaultTableCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -4003145629974364170L;
    private Constructor<?> constructor;
    private Object value;
    private boolean respectNumberLocale;

    public SyntheticaDefaultTableCellEditor() {
        this(new JTextField());
    }

    public SyntheticaDefaultTableCellEditor(JTextField jTextField) {
        this(jTextField, null);
    }

    public SyntheticaDefaultTableCellEditor(JTextField jTextField, Boolean bl) {
        super(jTextField);
        this.getComponent().setName("Table.editor");
        this.respectNumberLocale = bl != null ? bl : SyntheticaLookAndFeel.getBoolean("Synthetica.table.cellEditor.respectNumberLocale", null, false);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = null;
        JComponent jComponent = (JComponent)this.getComponent();
        jComponent.setBorder(this.createCellFocusBorder(jTable));
        jComponent.setOpaque(SyntheticaLookAndFeel.getBoolean("Synthetica.table.cellEditor.opaque", jTable));
        try {
            Class<Object> clazz = jTable.getColumnClass(n2);
            if (this.respectNumberLocale && Number.class.isAssignableFrom(clazz)) {
                object = NumberFormat.getInstance().format(object);
            }
            if (clazz == Object.class) {
                clazz = String.class;
            }
            this.constructor = clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean stopCellEditing() {
        String string = (String)super.getCellEditorValue();
        if (string != null && string.length() == 0) {
            if (this.constructor.getDeclaringClass() == String.class) {
                this.value = "";
            }
            super.stopCellEditing();
        }
        try {
            if (this.respectNumberLocale && Number.class.isAssignableFrom(this.constructor.getDeclaringClass())) {
                string = "" + NumberFormat.getNumberInstance().parse(string);
            }
            this.value = this.constructor.newInstance(string);
        }
        catch (Exception exception) {
            JComponent jComponent = (JComponent)this.getComponent();
            jComponent.setBorder(this.createErrorCellFocusBorder((JTable)jComponent.getParent()));
            return false;
        }
        return super.stopCellEditing();
    }

    protected Border createCellFocusBorder(JTable jTable) {
        Color color = SyntheticaLookAndFeel.getColor("Synthetica.table.focusCellHighlightBorder.color", jTable);
        return new CellFocusBorder(SyntheticaLookAndFeel.getColor("Synthetica.table.cellEditor.focus.color", jTable, color));
    }

    protected Border createErrorCellFocusBorder(JTable jTable) {
        return new CellFocusBorder(SyntheticaLookAndFeel.getColor("Synthetica.table.cellEditor.focus.errorColor", jTable, new Color(0xE70000)));
    }

    public static class CellFocusBorder
    implements Border {
        private Color color = Color.GRAY;

        public CellFocusBorder(Color color) {
            if (color != null) {
                this.color = color;
            }
        }

        public Insets getBorderInsets(Component component) {
            int n = this.getBorderSize(component);
            if (component.getParent() instanceof JTable) {
                JLabel jLabel = new JLabel();
                jLabel.setName("Table.cellRenderer");
                SynthStyle synthStyle = SynthLookAndFeel.getStyleFactory().getStyle(jLabel, Region.LABEL);
                Insets insets = synthStyle.getInsets(new SynthContext(jLabel, Region.LABEL, synthStyle, 0), null);
                return insets;
            }
            return new Insets(n, n, n, n);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.color);
            int n5 = this.getBorderSize(component);
            int n6 = 0;
            while (n6 < n5) {
                graphics2D.draw(this.createShape(n + n6, n2 + n6, n3 - n6 * 2 - 1, n4 - n6 * 2 - 1));
                ++n6;
            }
        }

        private int getBorderSize(Component component) {
            return SyntheticaLookAndFeel.getInt("Synthetica.table.cellEditor.focus.size", component, 1);
        }

        private Shape createShape(float f, float f2, float f3, float f4) {
            return new Rectangle2D.Float(f, f2, f3, f4);
        }
    }

    public static class NumberEditor
    extends SyntheticaDefaultTableCellEditor {
        private static final long serialVersionUID = 966057265129092767L;

        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }
}

