/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFInput;
import org.freehep.graphicsio.font.truetype.TTFLocaTable;
import org.freehep.graphicsio.font.truetype.TTFMaxPTable;
import org.freehep.graphicsio.font.truetype.TTFVersionTable;

public class TTFGlyfTable
extends TTFVersionTable {
    private static final boolean READ_GLYPHS = false;
    public Glyph[] glyphs;
    private long[] offsets;

    public String getTag() {
        return "glyf";
    }

    public void readTable() throws IOException {
        this.glyphs = new Glyph[((TTFMaxPTable)this.getTable((String)"maxp")).numGlyphs];
        this.offsets = ((TTFLocaTable)this.getTable((String)"loca")).offset;
    }

    public Glyph getGlyph(int i) throws IOException {
        if (this.glyphs[i] != null) {
            return this.glyphs[i];
        }
        this.ttf.pushPos();
        this.ttf.seek(this.offsets[i]);
        short numberOfContours = this.ttf.readShort();
        this.glyphs[i] = numberOfContours >= 0 ? new SimpleGlyph(numberOfContours) : new CompositeGlyph();
        this.glyphs[i].read();
        this.ttf.popPos();
        return this.glyphs[i];
    }

    public String toString() {
        String str = super.toString();
        for (int i = 0; i < this.glyphs.length; ++i) {
            str = str + "\n  #" + i + ": " + this.glyphs[i];
        }
        return str;
    }

    public class CompositeGlyph
    extends Glyph {
        private static final int ARGS_WORDS = 0;
        private static final int ARGS_XY = 1;
        private static final int SCALE = 3;
        private static final int XY_SCALE = 6;
        private static final int TWO_BY_TWO = 7;
        private static final int MORE_COMPONENTS = 5;
        private GeneralPath shape;
        private int noComponents;

        public String getType() {
            return "Composite Glyph";
        }

        public GeneralPath getShape() {
            return this.shape;
        }

        public void read() throws IOException {
            super.read();
            this.shape = new GeneralPath();
            this.noComponents = 0;
            boolean more = true;
            while (more) {
                short arg2;
                short arg1;
                ++this.noComponents;
                TTFGlyfTable.this.ttf.readUShortFlags();
                more = TTFGlyfTable.this.ttf.flagBit(5);
                int glyphIndex = TTFGlyfTable.this.ttf.readUShort();
                if (TTFGlyfTable.this.ttf.flagBit(0)) {
                    arg1 = TTFGlyfTable.this.ttf.readShort();
                    arg2 = TTFGlyfTable.this.ttf.readShort();
                } else {
                    arg1 = TTFGlyfTable.this.ttf.readChar();
                    arg2 = TTFGlyfTable.this.ttf.readChar();
                }
                AffineTransform t = new AffineTransform();
                if (TTFGlyfTable.this.ttf.flagBit(1)) {
                    t.translate(arg1, arg2);
                } else {
                    System.err.println("TTFGlyfTable: ARGS_ARE_POINTS not implemented.");
                }
                if (TTFGlyfTable.this.ttf.flagBit(3)) {
                    double scale = TTFGlyfTable.this.ttf.readF2Dot14();
                    t.scale(scale, scale);
                } else if (TTFGlyfTable.this.ttf.flagBit(6)) {
                    double scaleX = TTFGlyfTable.this.ttf.readF2Dot14();
                    double scaleY = TTFGlyfTable.this.ttf.readF2Dot14();
                    t.scale(scaleX, scaleY);
                } else if (TTFGlyfTable.this.ttf.flagBit(7)) {
                    System.err.println("TTFGlyfTable: WE_HAVE_A_TWO_BY_TWO not implemented.");
                }
                GeneralPath appendGlyph = (GeneralPath)TTFGlyfTable.this.getGlyph(glyphIndex).getShape().clone();
                appendGlyph.transform(t);
                this.shape.append(appendGlyph, false);
            }
        }

        public String toString() {
            return super.toString() + ", " + this.noComponents + " components";
        }
    }

    public class SimpleGlyph
    extends Glyph {
        private static final int ON_CURVE = 0;
        private static final int X_SHORT = 1;
        private static final int Y_SHORT = 2;
        private static final int REPEAT_FLAG = 3;
        private static final int X_SAME = 4;
        private static final int Y_SAME = 5;
        private static final int X_POSITIVE = 4;
        private static final int Y_POSITIVE = 5;
        public int numberOfContours;
        public int[] endPtsOfContours;
        public int[] instructions;
        public int[] flags;
        public int[] xCoordinates;
        public int[] yCoordinates;
        public boolean[] onCurve;
        public GeneralPath shape;

        public SimpleGlyph(int numberOfContours) {
            this.numberOfContours = numberOfContours;
            this.endPtsOfContours = new int[numberOfContours];
        }

        public String getType() {
            return "Simple Glyph";
        }

        public void read() throws IOException {
            int i;
            int i2;
            super.read();
            for (i2 = 0; i2 < this.endPtsOfContours.length; ++i2) {
                this.endPtsOfContours[i2] = TTFGlyfTable.this.ttf.readUShort();
            }
            this.instructions = new int[TTFGlyfTable.this.ttf.readUShort()];
            for (i2 = 0; i2 < this.instructions.length; ++i2) {
                this.instructions[i2] = TTFGlyfTable.this.ttf.readByte();
            }
            int numberOfPoints = this.endPtsOfContours[this.endPtsOfContours.length - 1] + 1;
            this.flags = new int[numberOfPoints];
            this.xCoordinates = new int[numberOfPoints];
            this.yCoordinates = new int[numberOfPoints];
            this.onCurve = new boolean[numberOfPoints];
            int repeatCount = 0;
            int repeatFlag = 0;
            for (int i3 = 0; i3 < numberOfPoints; ++i3) {
                if (repeatCount > 0) {
                    this.flags[i3] = repeatFlag;
                    --repeatCount;
                } else {
                    this.flags[i3] = TTFGlyfTable.this.ttf.readRawByte();
                    if (TTFInput.flagBit(this.flags[i3], 3)) {
                        repeatCount = TTFGlyfTable.this.ttf.readByte();
                        repeatFlag = this.flags[i3];
                    }
                }
                TTFInput.checkZeroBit(this.flags[i3], 6, "flags");
                TTFInput.checkZeroBit(this.flags[i3], 7, "flags");
                this.onCurve[i3] = TTFInput.flagBit(this.flags[i3], 0);
            }
            int last = 0;
            for (i = 0; i < numberOfPoints; ++i) {
                if (TTFInput.flagBit(this.flags[i], 1)) {
                    if (TTFInput.flagBit(this.flags[i], 4)) {
                        last = this.xCoordinates[i] = last + TTFGlyfTable.this.ttf.readByte();
                        continue;
                    }
                    last = this.xCoordinates[i] = last - TTFGlyfTable.this.ttf.readByte();
                    continue;
                }
                last = TTFInput.flagBit(this.flags[i], 4) ? (this.xCoordinates[i] = last) : (this.xCoordinates[i] = last + TTFGlyfTable.this.ttf.readShort());
            }
            last = 0;
            for (i = 0; i < numberOfPoints; ++i) {
                if (TTFInput.flagBit(this.flags[i], 2)) {
                    if (TTFInput.flagBit(this.flags[i], 5)) {
                        last = this.yCoordinates[i] = last + TTFGlyfTable.this.ttf.readByte();
                        continue;
                    }
                    last = this.yCoordinates[i] = last - TTFGlyfTable.this.ttf.readByte();
                    continue;
                }
                last = TTFInput.flagBit(this.flags[i], 5) ? (this.yCoordinates[i] = last) : (this.yCoordinates[i] = last + TTFGlyfTable.this.ttf.readShort());
            }
        }

        public String toString() {
            String str = super.toString() + ", " + this.numberOfContours + " contours, endPts={";
            for (int i = 0; i < this.numberOfContours; ++i) {
                str = str + (i == 0 ? "" : ",") + this.endPtsOfContours[i];
            }
            str = str + "}, " + this.instructions.length + " instructions";
            return str;
        }

        public String toDetailedString() {
            String str = this.toString() + "\n  instructions = {";
            for (int i = 0; i < this.instructions.length; ++i) {
                str = str + Integer.toHexString(this.instructions[i]) + " ";
            }
            return str + "}";
        }

        public GeneralPath getShape() {
            if (this.shape != null) {
                return this.shape;
            }
            this.shape = new GeneralPath(1);
            int p = 0;
            for (int i = 0; i < this.endPtsOfContours.length; ++i) {
                int startIndex = p++;
                this.shape.moveTo(this.xCoordinates[startIndex], this.yCoordinates[startIndex]);
                boolean lastOnCurve = true;
                while (p <= this.endPtsOfContours[i]) {
                    if (this.onCurve[p]) {
                        if (lastOnCurve) {
                            this.shape.lineTo(this.xCoordinates[p], this.yCoordinates[p]);
                        } else {
                            this.shape.quadTo(this.xCoordinates[p - 1], this.yCoordinates[p - 1], this.xCoordinates[p], this.yCoordinates[p]);
                        }
                        lastOnCurve = true;
                    } else {
                        if (!lastOnCurve) {
                            int x1 = this.xCoordinates[p - 1];
                            int y1 = this.yCoordinates[p - 1];
                            int x2 = (int)((double)(x1 + this.xCoordinates[p]) / 2.0);
                            int y2 = (int)((double)(y1 + this.yCoordinates[p]) / 2.0);
                            this.shape.quadTo(x1, y1, x2, y2);
                        }
                        lastOnCurve = false;
                    }
                    ++p;
                }
                if (!this.onCurve[p - 1]) {
                    this.shape.quadTo(this.xCoordinates[p - 1], this.yCoordinates[p - 1], this.xCoordinates[startIndex], this.yCoordinates[startIndex]);
                    continue;
                }
                if (this.xCoordinates[p - 1] == this.xCoordinates[startIndex] && this.yCoordinates[p - 1] == this.yCoordinates[startIndex]) continue;
                this.shape.closePath();
            }
            return this.shape;
        }
    }

    public abstract class Glyph {
        public int xMin;
        public int yMin;
        public int xMax;
        public int yMax;

        public abstract String getType();

        public abstract GeneralPath getShape();

        public void read() throws IOException {
            this.xMin = TTFGlyfTable.this.ttf.readFWord();
            this.yMin = TTFGlyfTable.this.ttf.readFWord();
            this.xMax = TTFGlyfTable.this.ttf.readFWord();
            this.yMax = TTFGlyfTable.this.ttf.readFWord();
        }

        public Rectangle getBBox() {
            return new Rectangle(this.xMin, this.yMin, this.xMax - this.xMin, this.yMax - this.yMin);
        }

        public String toString() {
            return "[" + this.getType() + "] (" + this.xMin + "," + this.yMin + "):(" + this.xMax + "," + this.yMax + ")";
        }

        public String toDetailedString() {
            return this.toString();
        }
    }
}

