/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class ByteUtils {
    public static byte[] overwrite(byte[] origBytes, int pos, byte[] newBytes) {
        return ByteUtils.overwrite(origBytes, pos, newBytes, 0, newBytes.length);
    }

    public static byte[] overwrite(byte[] origBytes, int pos, byte[] newBytes, int newPos, int newLength) {
        if (pos > origBytes.length) {
            throw new IndexOutOfBoundsException(MessageFormat.format("position {0} exceeds the length of the bytes {1}", pos, origBytes.length));
        }
        int newSize = pos + newLength < origBytes.length ? origBytes.length : pos + newLength;
        byte[] result = new byte[newSize];
        System.arraycopy(origBytes, 0, result, 0, origBytes.length);
        System.arraycopy(newBytes, newPos, result, pos, newLength);
        return result;
    }

    public static byte[] drainStream(InputStream in) throws IOException {
        return ByteUtils.drainStream(in, 1024, Integer.MAX_VALUE);
    }

    public static byte[] drainStream(InputStream in, int initialBufSize, int maxLength) throws IOException {
        int offset = 0;
        byte[] buf = new byte[Math.min(initialBufSize, maxLength)];
        while (true) {
            byte[] result;
            int bytesRead;
            if ((bytesRead = in.read(buf, offset, Math.min(maxLength, buf.length - offset))) == -1) {
                IOUtils.close(in);
                result = new byte[offset];
                System.arraycopy(buf, 0, result, 0, offset);
                return result;
            }
            offset += bytesRead;
            if ((maxLength -= bytesRead) == 0) {
                result = new byte[offset];
                System.arraycopy(buf, 0, result, 0, offset);
                return result;
            }
            if (offset != buf.length) continue;
            byte[] newbuf = new byte[buf.length * 2];
            System.arraycopy(buf, 0, newbuf, 0, buf.length);
            buf = newbuf;
        }
    }
}

