/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.apache.http.client.protocol;

import com.amazon.redshift.shaded.apache.http.HttpEntity;
import com.amazon.redshift.shaded.apache.http.HttpEntityEnclosingRequest;
import com.amazon.redshift.shaded.apache.http.HttpException;
import com.amazon.redshift.shaded.apache.http.HttpRequest;
import com.amazon.redshift.shaded.apache.http.HttpRequestInterceptor;
import com.amazon.redshift.shaded.apache.http.HttpVersion;
import com.amazon.redshift.shaded.apache.http.ProtocolVersion;
import com.amazon.redshift.shaded.apache.http.annotation.Immutable;
import com.amazon.redshift.shaded.apache.http.client.config.RequestConfig;
import com.amazon.redshift.shaded.apache.http.client.protocol.HttpClientContext;
import com.amazon.redshift.shaded.apache.http.protocol.HttpContext;
import com.amazon.redshift.shaded.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

