/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.http.impl.client;

import com.amazon.redshift.amazonaws.annotation.ThreadSafe;
import com.amazon.redshift.amazonaws.util.AWSRequestMetrics;
import com.amazon.redshift.shaded.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.amazon.redshift.shaded.apache.http.protocol.HttpContext;
import java.io.IOException;

@ThreadSafe
public class SdkHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    public static final SdkHttpRequestRetryHandler Singleton = new SdkHttpRequestRetryHandler();

    private SdkHttpRequestRetryHandler() {
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        AWSRequestMetrics awsRequestMetrics;
        boolean retry = super.retryRequest(exception, executionCount, context);
        if (retry && (awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.class.getSimpleName())) != null) {
            awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.HttpClientRetryCount);
        }
        return retry;
    }
}

