/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.ExpandableCell;
import com.jidesoft.grid.MarginExpandablePanel;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class PropertyTableCellRenderer
extends DefaultTableCellRenderer {
    protected MarginExpandablePanel _cellRenderer;
    protected TableCellRenderer _actualCellRenderer;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        PropertyTableModel propertyTableModel = (PropertyTableModel)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), PropertyTableModel.class);
        if (propertyTableModel == null) {
            return this.getActualCellRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
        }
        if (!(jTable instanceof CategorizedTable)) {
            return this.getActualCellRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
        }
        n2 = TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n2, propertyTableModel);
        Object t2 = propertyTableModel.getRowAt(n2);
        CategorizedTable categorizedTable = (CategorizedTable)jTable;
        if (this._cellRenderer == null) {
            this._cellRenderer = this.createMarginExpandablePanel(categorizedTable);
        }
        this._cellRenderer.setPaintMarginBackground(categorizedTable.isPaintMarginBackground());
        if (t2 != null) {
            if (jTable.convertColumnIndexToModel(n3) == 0) {
                if (t2 instanceof ExpandableCell) {
                    this._cellRenderer.setExpandableCell((ExpandableCell)t2);
                }
                this._cellRenderer.setSelected(bl);
                this._cellRenderer.setHasFocus(bl2);
                if (!propertyTableModel.isCategoryRow(n2) || categorizedTable.isUseTableRendererForCategoryRow()) {
                    TableCellRenderer tableCellRenderer = this.getActualCellRenderer();
                    if (tableCellRenderer != null) {
                        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, !(tableCellRenderer instanceof DefaultTableCellRenderer.UIResource) && bl2, n2, n3);
                        this.customizeCellRenderer((Property)t2, component);
                        this._cellRenderer.setActualRenderer(component);
                    }
                } else {
                    this._cellRenderer.setActualRenderer(null);
                }
                return this._cellRenderer;
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n2, n3);
            if (propertyTableModel.isCategoryRow(n2)) {
                Font font = jTable.getFont().deriveFont(1);
                if (bl) {
                    JideSwingUtilities.installColorsAndFont(component, jTable.getSelectionBackground(), jTable.getSelectionForeground(), font);
                } else {
                    JideSwingUtilities.installColorsAndFont(component, jTable.getGridColor(), categorizedTable.getDisabledForeground(), font);
                }
            } else if (((Property)t2).isEditable()) {
                JideSwingUtilities.installColorsAndFont(component, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
            } else {
                JideSwingUtilities.installColorsAndFont(component, jTable.getBackground(), categorizedTable.getDisabledForeground(), jTable.getFont());
            }
            return component;
        }
        Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n2, n3);
        if (propertyTableModel.isCategoryRow(n2)) {
            component.setBackground(jTable.getGridColor());
        } else {
            component.setBackground(Color.white);
        }
        return component;
    }

    protected MarginExpandablePanel createMarginExpandablePanel(CategorizedTable categorizedTable) {
        return new MarginExpandablePanel(categorizedTable);
    }

    protected void customizeCellRenderer(Property property, Component component) {
        if (property.isPreferred()) {
            Font font = component.getFont().deriveFont(1);
            component.setFont(font);
        }
    }

    public TableCellRenderer getActualCellRenderer() {
        return this._actualCellRenderer;
    }

    public void setActualCellRenderer(TableCellRenderer tableCellRenderer) {
        this._actualCellRenderer = tableCellRenderer;
    }

    public void releaseCellRenderer() {
        if (this._cellRenderer != null) {
            this._cellRenderer.setExpandableCell(null);
        }
    }
}

