/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Blob;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.Value;
import java.sql.SQLException;

public class ValueBytes
extends Value {
    byte[] value;

    public ValueBytes() {
    }

    public ValueBytes(byte[] val) {
        this.value = val;
    }

    public ValueBytes(Object x) {
        this.value = (byte[])x;
    }

    public ValueBytes(Blob blob) throws SQLException {
        this.value = blob.getBytes();
    }

    public ValueBytes(java.sql.Blob blob) throws SQLException {
        this.value = blob.getBytes(0L, (int)blob.length());
    }

    @Override
    int getType() {
        return 14;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeBytes(this.value);
    }

    @Override
    Object getObject() {
        return this.getBytes(null);
    }

    @Override
    byte[] getBytes(SQLContext sqlContext) {
        return this.value;
    }

    @Override
    String getString() {
        return new String(this.value);
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    @Override
    byte getByte() throws SQLException {
        this.throwConversionNotImplemented("byte");
        return 0;
    }

    @Override
    short getShort() throws SQLException {
        this.throwConversionNotImplemented("short");
        return 0;
    }

    @Override
    int getInt() throws SQLException {
        this.throwConversionNotImplemented("int");
        return 0;
    }

    @Override
    long getLong() throws SQLException {
        this.throwConversionNotImplemented("long");
        return 0L;
    }

    @Override
    double getDouble() throws SQLException {
        this.throwConversionNotImplemented("double");
        return 0.0;
    }

    @Override
    float getFloat() throws SQLException {
        this.throwConversionNotImplemented("float");
        return 0.0f;
    }
}

