/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryDataFactory;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.GenericSQLWriter;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk1.AccessMetaData;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk1.Metadatasource_t;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk3.AccessMetaDataLite;
import com.ibm.db2.cmx.runtime.internal.repository.util.StreamUtils;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class MetadataSourceWriter {
    public static MetadataSourceWriter getInstance(String string) {
        return new MetadataSourceWriter(string);
    }

    private MetadataSourceWriter(String string) {
    }

    public int createEntry(Connection connection, String string, String string2) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        Metadatasource_t metadatasource_t = new Metadatasource_t();
        int n2 = -1;
        metadatasource_t.setSource(string);
        metadatasource_t.setSourcefile(string2);
        try {
            accessMetaDataLite.insertMSW(metadatasource_t);
            n2 = metadatasource_t.getMetadatasrc_key();
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return n2;
    }

    public void setContent(Connection connection, int n2, InputStream inputStream) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.copyStream(inputStream, byteArrayOutputStream);
            byteArrayOutputStream.close();
            accessMetaDataLite.updateMSW(byteArrayOutputStream.toByteArray(), n2);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), iOException);
        }
    }

    public void setContent(Connection connection, int n2, InputStream inputStream, int n3) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.copyStream(inputStream, byteArrayOutputStream);
            byteArrayOutputStream.close();
            accessMetaDataLite.updateMSW(byteArrayOutputStream.toByteArray(), n3, n2);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setContentFrom(Connection connection, int n2, int n3) throws MetadataException {
        int n4;
        block11: {
            AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
            n4 = 0;
            boolean bl2 = false;
            try {
                String string = connection.getMetaData().getDatabaseProductName().toUpperCase();
                boolean bl3 = bl2 = string.startsWith("INFORMIX") || string.startsWith("IDS");
                if (bl2) {
                    String string2 = "select MDS1.CONTENT, MDS1.IMPORT_TIME, MDS1.CONTENT_LENGTH from METADATASOURCE_T as MDS1 where MDS1.METADATASRC_KEY = ?";
                    String string3 = "update METADATASOURCE_T SET CONTENT = ?, IMPORT_TIME = ?, CONTENT_LENGTH = ? where METADATASRC_KEY = ?";
                    PreparedStatement preparedStatement = null;
                    ResultSet resultSet = null;
                    try {
                        preparedStatement = connection.prepareStatement(string2);
                        preparedStatement.setInt(1, n2);
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            Object[] objectArray = new Object[]{resultSet.getBlob(1), resultSet.getTimestamp(2), new Integer(resultSet.getInt(3)), new Integer(n3)};
                            n4 = GenericSQLWriter.executeSQLUpdate(connection, string3, objectArray);
                        }
                        break block11;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                try {
                    n4 = accessMetaDataLite.updateMSW(n2, n2, n2, n3);
                }
                catch (DataRuntimeException dataRuntimeException) {
                    throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
                }
            }
            catch (SQLException sQLException) {
                throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), sQLException);
            }
        }
        return n4;
    }

    public int createEntry(Connection connection, String string, String string2, byte[] byArray, int n2) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        int n3 = -1;
        try {
            Metadatasource_t metadatasource_t = new Metadatasource_t();
            metadatasource_t.setSource(string);
            metadatasource_t.setSourcefile(string2);
            metadatasource_t.setContent(byArray);
            metadatasource_t.setContent_length(n2);
            accessMetaDataLite.insertMSW2(metadatasource_t);
            n3 = metadatasource_t.getMetadatasrc_key();
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return n3;
    }

    public int createEntry(Connection connection, String string, String string2, byte[] byArray, int n2, long l8) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        int n3 = -1;
        try {
            Metadatasource_t metadatasource_t = new Metadatasource_t();
            metadatasource_t.setSource(string);
            metadatasource_t.setSourcefile(string2);
            metadatasource_t.setContent(byArray);
            metadatasource_t.setContent_length(n2);
            metadatasource_t.setImport_time(new Timestamp(l8));
            accessMetaDataLite.insertMSW_all(metadatasource_t);
            n3 = metadatasource_t.getMetadatasrc_key();
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return n3;
    }

    public void replaceEntry(Connection connection, int n2, String string, String string2, byte[] byArray, int n3) throws MetadataException {
        block7: {
            int n4 = 0;
            boolean bl2 = false;
            try {
                String string3 = connection.getMetaData().getDatabaseProductName().toUpperCase();
                boolean bl3 = bl2 = string3.startsWith("INFORMIX") || string3.startsWith("IDS");
                if (bl2) {
                    String string4 = "update METADATASOURCE_T SET \"SOURCE\"=?, SOURCEFILE=?, CONTENT=?, CONTENT_LENGTH=?, IMPORT_TIME=current year to fraction(4)  where METADATASRC_KEY = ?";
                    Object[] objectArray = new Object[]{string, string2, byArray, new Integer(n3), new Integer(n2)};
                    n4 = GenericSQLWriter.executeSQLUpdate(connection, string4, objectArray);
                    if (n4 <= 0) {
                        throw new MetadataException(null, null);
                    }
                    break block7;
                }
                AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
                try {
                    n4 = accessMetaDataLite.updateMSW2(string, string2, byArray, n3, n2);
                    if (n4 <= 0) {
                        throw new MetadataException(null, null);
                    }
                }
                catch (DataRuntimeException dataRuntimeException) {
                    throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
                }
            }
            catch (SQLException sQLException) {
                throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), sQLException);
            }
        }
    }

    public int replaceEntry(Connection connection, String string, String string2, char c10, char c11, String string3, String string4, byte[] byArray, int n2) throws MetadataException {
        int n3;
        block7: {
            AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
            n3 = 0;
            boolean bl2 = false;
            try {
                String string5 = connection.getMetaData().getDatabaseProductName().toUpperCase();
                boolean bl3 = bl2 = string5.startsWith("INFORMIX") || string5.startsWith("IDS");
                if (bl2) {
                    String string6 = null;
                    Object[] objectArray = null;
                    if (string2 != null) {
                        string6 = "update METADATASOURCE_T SET \"SOURCE\"=?, SOURCEFILE=?, CONTENT=?, CONTENT_LENGTH=?, IMPORT_TIME=current year to fraction(4) where METADATASRC_KEY IN (select MDGM.METADATASRC_KEY from METADATAGROUP_T MDG, METADATAGROUPMEMBERS_T MDGM where MDGM.METADATAGROUP_KEY = MDG.METADATAGROUP_KEY and MDGM.MEMBER_TYPE = ? and MDG.NAME = ? and MDG.TYPE_ = ? and MDG.\"VERSION\" = ? )";
                        objectArray = new Object[8];
                        objectArray[7] = string2;
                    } else {
                        string6 = "update METADATASOURCE_T SET \"SOURCE\"=?, SOURCEFILE=?, CONTENT=?, CONTENT_LENGTH=?, IMPORT_TIME=current year to fraction(4) where METADATASRC_KEY IN (select MDGM.METADATASRC_KEY from METADATAGROUP_T MDG, METADATAGROUPMEMBERS_T MDGM where MDGM.METADATAGROUP_KEY = MDG.METADATAGROUP_KEY and MDGM.MEMBER_TYPE = ? and MDG.NAME = ? and MDG.TYPE_ = ? and MDG.\"VERSION\" IS NULL )";
                        objectArray = new Object[]{string3, string4, byArray, new Integer(n2), String.valueOf(c11), string, String.valueOf(c10)};
                    }
                    n3 = GenericSQLWriter.executeSQLUpdate(connection, string6, objectArray);
                    break block7;
                }
                try {
                    n3 = string2 != null ? accessMetaDataLite.updateMSW(string3, string4, byArray, n2, String.valueOf(c11), string, String.valueOf(c10), string2) : accessMetaDataLite.updateMSW(string3, string4, byArray, n2, String.valueOf(c11), string, String.valueOf(c10));
                }
                catch (DataRuntimeException dataRuntimeException) {
                    throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
                }
            }
            catch (SQLException sQLException) {
                throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), sQLException);
            }
        }
        return n3;
    }

    public int removeEntry(Connection connection, int n2) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        int n3 = 0;
        try {
            n3 = accessMetaDataLite.deleteMSW(n2);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return n3;
    }

    public void removeEntriesForApp(Connection connection, String string, String string2, boolean bl2) throws MetadataException {
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        try {
            if (bl2) {
                accessMetaData.deleteMSW_VNN(string);
            } else if (string2 != null) {
                accessMetaData.deleteMSW(string, string2);
            } else {
                accessMetaData.deleteMSW_VN(string);
            }
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
    }

    public void removeOrphanedEntries(Connection connection) {
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        accessMetaData.deleteMSW();
    }

    public void removeEntriesForProject(Connection connection, String string) throws MetadataException {
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        try {
            accessMetaData.deleteMSW(string);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
    }

    public int removeEntriesForGroup(Connection connection, String string, String string2) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        int n2 = 0;
        try {
            n2 = string2 != null ? accessMetaDataLite.deleteMSW2(string, string2) : accessMetaDataLite.deleteMSW2(string);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_WRITE_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return n2;
    }
}

