/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.SchemaDoesNotExistException;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositorySetupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.manager.ConnectionManager;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryUtility;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.TableNames;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.RepositorySetupException;
import com.ibm.db2.cmx.runtime.internal.repository.util.SQLUtilities;
import com.ibm.db2.cmx.runtime.internal.repository.util.StreamUtils;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.tools.StaticBinder;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.jcc.DB2Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RepositorySetupManagerImpl
implements RepositorySetupManager {
    private static final String STMT_TERMINATOR = ";";
    private String givenSchema = null;
    String[] AllTables = new String[]{"METADATASOURCE_T", "METADATAGROUP_T", "METADATAGROUPMEMBERS_T", "CONTACT_T", "CAPTUREDATA_T", "SCHEMA_VERSION_T", "APP_T", "PROJECT_T", "DBINFO_T", "STMT_T", "DEPTAB_T", "STACK_T", "SRCINFO_T", "METADATASOURCE_STMT_T", "SRC_STMT_T"};
    String[] COTables = new String[]{"METADATASOURCE_T", "METADATAGROUP_T", "METADATAGROUPMEMBERS_T", "CONTACT_T", "CAPTUREDATA_T", "SCHEMA_VERSION_T"};
    String[][] AllColumns = new String[][]{{"METADATASRC_KEY", "SOURCE", "IMPORT_TIME", "CONTENT_LENGTH", "CONTENT", "SOURCEFILE"}, {"METADATAGROUP_KEY", "NAME", "VERSION", "ACTIVE", "TYPE_", "CONTACT_KEY"}, {"METADATAGROUP_KEY", "MEMBER_TYPE", "METADATASRC_KEY", "CHILDGROUP_KEY", "CHILDGROUP_NAME", "CHILDGROUP_TYPE"}, {"CONTACT_KEY", "CONTACT"}, {"CAPTUREDATA_KEY", "GROUP_NAME", "GROUP_VERSION", "UPDATE_TIME", "CONTENT", "CONTENT_LENGTH", "STATE", "STATE_TRANSITION_TIME"}, {"COMPONENT", "VERSION", "RELEASE", "MOD"}, {"APP_KEY", "NAME", "VERSION"}, {"PROJECT_KEY", "NAME"}, {"DBPKG_KEY", "DBPKGROOT", "COLLECTIONID", "CONTOKEN", "VERSION", "IS_BINDABLE"}, {"STMT_KEY", "EXPRESSION", "QUERYTEXT", "QUERYTEXTTYPE", "STATEMENTTYPE", "EXPRESSIONTYPE", "PROCESSEDSQLTEXT", "TOTALCOST", "CARDINALITY", "JOINCOUNT", "SECTIONNUM", "ID", "TBSCANCOUNT", "IXSCANCOUNT", "DBPKG_KEY", "IS_BINDABLE", "DEFAULTSCHEMA", "PATH", "SPECREG", "EXECOUNT", "LASTUSEDTS"}, {"SCHEMANAME", "TABLENAME", "COLUMNNAME", "STMT_KEY"}, {"STACK_ID", "METADATASRC_KEY"}, {"STACK_ID", "STACKTRACEORDER", "PATH", "VERSION", "LINENO", "CLASSNAME", "METHODNAME", "METHODSIGNATURE", "NATIVEMETHOD", "JAVA_PKGNAME", "LANGUAGE", "PROJECT_KEY", "LABEL", "LABEL_TYPE"}, {"METADATASRC_KEY", "STMT_KEY", "APP_KEY", "PROJECT_KEY"}, {"STMT_KEY", "STMT_OP", "STACK_ID", "APP_KEY"}};
    String[] idsColumnsUPC = new String[]{"APP_KEY", "CAPTUREDATA_KEY", "CONTACT_KEY", "DBPKG_KEY", "EXPRESSION", "LABEL", "LANGUAGE", "LINENO", "METADATAGROUP_KEY", "METADATASRC_KEY", "MOD", "PATH", "PROJECT_KEY", "RELEASE", "SOURCE", "STACK_ID", "STMT_KEY", "VERSION"};
    HashSet<String> existingTablespaces;
    private Connection c = null;
    public static final String sqlDelimeters_ = " \n\t\r\f'\"{},()\\[]:=+-*/<>!&|;.";
    static final Pattern dropTsPattern = Pattern.compile("\\s*DROP\\s+TABLESPACE\\s+([^\\s]+)", 2);
    static final String dao_pkg1AMD_ = "com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk1.AccessMetaData";
    static final String dao_pkg2AMDA_ = "com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk2.AccessMetaDataAppl";
    static final String dao_pkg3AMDL_ = "com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk3.AccessMetaDataLite";
    static final String dao_db2AMDRF_ = "com.ibm.db2.cmx.runtime.internal.repository.sql.db2.DB2AsyncRefreshMaintenance";

    public RepositorySetupManagerImpl(Connection connection) {
        this.c = connection;
    }

    public void setGivenSchema(String string) {
        boolean bl2 = false;
        if (string != null) {
            try {
                String string2 = this.c.getMetaData().getDatabaseProductName().toUpperCase();
                bl2 = string2.startsWith("INFORMIX") || string2.startsWith("IDS");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.givenSchema = bl2 ? string.toLowerCase() : string;
        }
    }

    public String getGivenSchema() {
        return this.givenSchema;
    }

    @Override
    public String getDefaultOrGivenSchema() {
        boolean bl2 = false;
        if (this.getGivenSchema() != null) {
            return this.getGivenSchema();
        }
        try {
            String string = this.c.getMetaData().getDatabaseProductName().toUpperCase();
            bl2 = string.startsWith("INFORMIX") || string.startsWith("IDS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (bl2) {
            this.givenSchema = "IBMPDQ".toLowerCase();
            return "IBMPDQ".toLowerCase();
        }
        this.givenSchema = "IBMPDQ";
        return "IBMPDQ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createRepository(String string, RepositorySetupManager.CreateType createType, boolean bl2, PrintWriter printWriter) throws RepositorySetupException, SQLException {
        Object object;
        Object object2;
        Object object3;
        RepositoryVersionImpl repositoryVersionImpl = null;
        boolean bl3 = false;
        ConnectionManager.ConnectionType connectionType = ConnectionManager.getConnectionType(this.c);
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2) || connectionType.equals((Object)ConnectionManager.ConnectionType.Derby)) {
            object3 = null;
            try {
                block26: {
                    object3 = this.c.createStatement();
                    try {
                        object3.executeUpdate("create schema " + string);
                    }
                    catch (SQLException sQLException) {
                        object2 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
                        if (!((String)object2).startsWith("DSN08") && !((String)object2).startsWith("DSN07") && !((String)object2).matches("DSN09\\d\\d[0-4]") && !((String)object2).matches("DSN10\\d\\d[0-1]")) break block26;
                        object3.execute("set current sqlid ='" + string + "'");
                    }
                }
                object3.execute("set current schema " + string);
            }
            finally {
                if (object3 != null) {
                    object3.close();
                    this.c.commit();
                }
            }
        }
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.Oracle)) {
            object3 = this.c.createStatement();
            try {
                object3.executeUpdate("alter session set current_schema=" + string);
            }
            catch (SQLException sQLException) {
                String string2 = Messages.getText("ERR_ORA_SET_SCHEMA_IBMPDQ", new Object[]{PossibleArgs.REPOSITORY_SCHEMA, string});
                throw new RepositorySetupException(string2, sQLException);
            }
            finally {
                if (object3 != null) {
                    object3.close();
                    this.c.commit();
                }
            }
        } else if (connectionType.equals((Object)ConnectionManager.ConnectionType.Informix) && !((String)(object3 = this.c.getMetaData().getUserName())).equalsIgnoreCase(string)) {
            String string3 = Messages.getText("ERR_MANAGEREPOSITORY_BAD_USERID_FOR_CREATE_REPOSITORY", string, object3);
            throw new RepositorySetupException(string3, null);
        }
        try {
            repositoryVersionImpl = RepositoryUtility.getPQRepositoryVersion(this.c, string);
        }
        catch (Exception exception) {
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_REPOSITORY", new Object[0]), exception);
        }
        boolean bl4 = false;
        if (RepositorySetupManager.CreateType.OnlyIfDownlevel.equals((Object)createType) && repositoryVersionImpl != null) {
            try {
                object = RepositoryUtility.getSetupVersion();
                object2 = new RepositoryVersionImpl(repositoryVersionImpl.getComponent(), object[0], object[1], object[2]);
                bl4 = repositoryVersionImpl.compareTo((RepositoryVersion)object2) < 0;
            }
            catch (IOException iOException) {
                throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_REPOSITORY", new Object[0]), iOException);
            }
        }
        try {
            if (repositoryVersionImpl != null && (RepositorySetupManager.CreateType.Always.equals((Object)createType) || RepositorySetupManager.CreateType.OnlyIfDownlevel.equals((Object)createType) && bl4)) {
                this.removeRepository(string, printWriter, repositoryVersionImpl);
                this.c.commit();
                ConnectionManager.restoreConnection(this.c);
                this.c.commit();
            }
            if (RepositorySetupManager.CreateType.Always.equals((Object)createType) || RepositorySetupManager.CreateType.OnlyIfDownlevel.equals((Object)createType) && bl4 || repositoryVersionImpl == null) {
                object = this.getCreateScriptInternal(bl2);
                object2 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
                if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2) && ((String)object2).startsWith("DSN")) {
                    object = this.replaceDBNameInCreateDropScript((List<String>)object, string);
                }
                SQLUtilities.runScript(this.c, string, (List<String>)object, false, null, printWriter);
                this.c.commit();
                bl3 = true;
            }
        }
        catch (Exception exception) {
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_SETUP_REPOSITORY", new Object[0]), exception);
        }
        return bl3;
    }

    @Override
    public PureQueryUtility.UtilityResult getScriptOrExecuteRepositoryUpgrade(String string, RepositoryVersion repositoryVersion, DatabaseMetaData databaseMetaData, boolean bl2, boolean bl3, List<String> list, PrintWriter printWriter) throws RepositorySetupException, IOException, MetadataException, SQLException {
        Object object;
        PureQueryUtility.UtilityResult utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
        boolean bl4 = repositoryVersion.isFullRepository();
        String string2 = this.getCurrentSchemaAndSet(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        if (repositoryVersion.getVersion() == 2 && repositoryVersion.getRelease() == 2 && repositoryVersion.getMod() == 4) {
            arrayList.addAll(this.getUpgradeScript225(bl4));
        }
        arrayList.addAll(this.getUpgradeScript(bl4, repositoryVersion));
        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 6);
        int n2 = repositoryVersion.compareTo(repositoryVersionImpl);
        String[] stringArray = null;
        ArrayList<String> arrayList2 = null;
        try {
            arrayList2 = this.getPackageGranteeIds(string, n2, this.c);
        }
        catch (SQLException sQLException) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("ERR_REPOSITORY_AUTHORIZATION_INFO_NOT_FOUND", "executePackage", sQLException.toString());
            return utilityResult;
        }
        boolean bl5 = arrayList2 != null && !arrayList2.isEmpty();
        String string3 = databaseMetaData.getUserName();
        int n3 = arrayList2.indexOf(string3);
        if (n3 < 0) {
            n3 = arrayList2.indexOf(string3.toUpperCase());
        }
        if (n3 >= 0) {
            arrayList2.remove(n3);
        }
        if (!arrayList2.isEmpty()) {
            stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        }
        String[] stringArray2 = null;
        try {
            stringArray2 = this.getTableGranteeIds(string, databaseMetaData, bl5, n2);
        }
        catch (SQLException sQLException) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("ERR_REPOSITORY_AUTHORIZATION_INFO_NOT_FOUND", "tableAccess", sQLException.toString());
            return utilityResult;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            String string4;
            String string5;
            if (n2 <= 0) {
                if (bl2) {
                    object = "log_t";
                    string5 = "log";
                } else {
                    object = "LOG_T";
                    string5 = "LOG";
                }
                string4 = RepositorySetupManagerImpl.getGrantRevokeStmt(true, "SELECT, INSERT, UPDATE, DELETE", false, (String)object, stringArray2);
                arrayList.add(string4);
                string4 = RepositorySetupManagerImpl.getGrantRevokeStmt(true, "SELECT", false, string5, stringArray2);
                arrayList.add(string4);
            }
            object = "METADATAGROUP_REFRESH_SEQ";
            string5 = "SCHEMA_VERSION_T";
            if (bl2) {
                object = ((String)object).toLowerCase();
                string5 = string5.toLowerCase();
            }
            string4 = RepositorySetupManagerImpl.getGrantRevokeSequenceStmt(true, bl2, (String)object, stringArray2);
            arrayList.add(string4);
            string4 = RepositorySetupManagerImpl.getGrantRevokeStmt(true, "SELECT, INSERT, UPDATE, DELETE", false, string5, stringArray2);
            arrayList.add(string4);
        }
        if (bl3) {
            try {
                SQLUtilities.runScript(this.c, string, arrayList, false, null, printWriter);
                this.c.commit();
            }
            catch (Exception exception) {
                throw new RepositorySetupException(Messages.getText("ERR_CANNOT_UPGRADE_REPOSITORY", new Object[0]), exception);
            }
        } else {
            list.addAll(arrayList);
        }
        if (bl5) {
            if (bl3) {
                int n4 = this.bindStaticPackages(string, repositoryVersion, true, printWriter);
                switch (n4) {
                    case 0: {
                        utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
                        break;
                    }
                    case 63: {
                        utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
                        break;
                    }
                    case 127: {
                        utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
                        return utilityResult;
                    }
                    case 255: {
                        utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
                        return utilityResult;
                    }
                }
            } else {
                list.add("commit work");
                object = this.getBindStaticPackages(string, repositoryVersion, true);
                if (object != null && !object.isEmpty()) {
                    for (int i10 = 0; i10 < object.size(); ++i10) {
                        list.add("-- " + (String)object.get(i10));
                    }
                }
            }
            arrayList = new ArrayList();
            if (stringArray != null && stringArray.length > 0) {
                arrayList.add(string2);
                List<String> list2 = RepositorySetupManagerImpl.getUpgrade227GrantExecutePackageScript(repositoryVersion, string, stringArray);
                if (list2 != null && !list2.isEmpty()) {
                    arrayList.addAll(list2);
                }
                if (bl3) {
                    try {
                        SQLUtilities.runScript(this.c, string, arrayList, false, null, printWriter);
                        this.c.commit();
                    }
                    catch (Exception exception) {
                        throw new RepositorySetupException(Messages.getText("ERR_PARTIAL_UPGRADE_REPOSITORY", "executePackage", "pureQuery Runtime"), exception);
                    }
                } else {
                    list.addAll(arrayList);
                }
            }
        }
        return utilityResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCreateScriptInternal(boolean bl2) throws RepositorySetupException, IOException {
        int n2;
        Object object;
        Object object2;
        URL uRL = null;
        try {
            if (this.c == null) {
                uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2RepositorySetup.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2LiteRepositorySetup.sql");
            } else {
                object2 = this.c.getMetaData().getDatabaseProductName().toUpperCase();
                if (((String)object2).contains("ORACLE")) {
                    uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/Oracle/oraRepositorySetup.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/Oracle/oraLiteRepositorySetup.sql");
                } else if (((String)object2).startsWith("INFORMIX") || ((String)object2).startsWith("IDS")) {
                    uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/IDS/idsRepositorySetup.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/IDS/idsLiteRepositorySetup.sql");
                } else if (((String)object2).contains("DERBY")) {
                    uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/derbyRepositorySetup.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/derbyLiteRepositorySetup.sql");
                } else {
                    object = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
                    uRL = bl2 ? (((String)object).startsWith("DSN") ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zV8RepositorySetup.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2RepositorySetup.sql")) : (((String)object).startsWith("DSN") ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zV8LiteRepositorySetup.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2LiteRepositorySetup.sql"));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_CREATE_SCRIPT", new Object[0]), sQLException);
        }
        object2 = null;
        object = null;
        try {
            object = uRL.openStream();
            object2 = StreamUtils.getScript((InputStream)object);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
        for (n2 = object2.size() - 1; n2 >= 0; --n2) {
            if (object2.get(n2) != null && ((String)object2.get(n2)).trim().length() != 0) continue;
            object2.remove(n2);
        }
        for (n2 = object2.size() - 1; n2 >= 0; --n2) {
            if (!((String)object2.get(n2)).startsWith("{upgrades}")) continue;
            List<String> list = this.getUpgradeScript(bl2, null);
            object2.remove(n2);
            object2.addAll(n2, list);
            break;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentSchemaAndSet(String string) throws RepositorySetupException, SQLException {
        String string2 = null;
        ConnectionManager.ConnectionType connectionType = ConnectionManager.getConnectionType(this.c);
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2) || connectionType.equals((Object)ConnectionManager.ConnectionType.Derby)) {
            Statement statement = null;
            String string3 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
            try {
                block15: {
                    statement = this.c.createStatement();
                    try {
                        if (!string3.startsWith("DSN")) {
                            statement.executeUpdate("create schema " + string);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!string3.startsWith("DSN08") && !string3.startsWith("DSN07") && !string3.matches("DSN09\\d\\d[0-4]") && !string3.matches("DSN10\\d\\d[0-1]")) break block15;
                        statement.execute("set current sqlid ='" + string + "'");
                    }
                }
                string2 = "set current schema " + string;
                statement.execute(string2);
            }
            finally {
                if (statement != null) {
                    statement.close();
                    this.c.commit();
                }
            }
        }
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.Oracle)) {
            Statement statement = this.c.createStatement();
            try {
                string2 = "alter session set current_schema=" + string;
                statement.executeUpdate(string2);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                if (statement != null) {
                    statement.close();
                    this.c.commit();
                }
            }
        }
        return string2;
    }

    @Override
    public List<String> getCreateScript(boolean bl2, String string) throws RepositorySetupException, IOException, SQLException {
        String string2 = this.getCurrentSchemaAndSet(string);
        List<String> list = this.getCreateScriptInternal(bl2);
        list.add(0, string2);
        ConnectionManager.ConnectionType connectionType = ConnectionManager.getConnectionType(this.c);
        String string3 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2) && string3.startsWith("DSN")) {
            list = this.replaceDBNameInCreateDropScript(list, string);
        }
        return this.addStmtTerminator(list);
    }

    private List<String> replaceDBNameInCreateDropScript(List<String> list, String string) {
        int n2 = list.size();
        String string2 = "PDQDSN";
        int n3 = string.length() > 6 ? 6 : string.length();
        String string3 = string.substring(0, n3);
        if (string3.equals("IBMPDQ")) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i10 = 0; i10 < n2; ++i10) {
            String string4 = list.get(i10);
            if (string4 != null && string4.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, sqlDelimeters_);
                String string5 = null;
                boolean bl2 = false;
                while (stringTokenizer.hasMoreTokens() && !bl2) {
                    string5 = stringTokenizer.nextToken();
                    if (!string5.equals(string2)) continue;
                    string4 = string4.replace(string2, "PQ" + string3);
                    bl2 = true;
                }
            }
            arrayList.add(string4);
        }
        return arrayList;
    }

    @Override
    public List<String> getUpgradeScript(boolean bl2, RepositoryVersion repositoryVersion) throws RepositorySetupException, IOException {
        List<String> list = null;
        List<String> list2 = null;
        RepositoryVersionImpl repositoryVersionImpl = null;
        int n2 = -1;
        if (repositoryVersion != null) {
            repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 6);
            n2 = repositoryVersion.compareTo(repositoryVersionImpl);
        }
        if (n2 < 0) {
            list = this.createVersionBasedScript(bl2, "Setup_2.2.6.sql");
            if (repositoryVersion != null) {
                list.add("commit work");
            }
        }
        if (n2 <= 0) {
            list2 = this.createVersionBasedScript(bl2, "Setup_2.2.7.sql");
            if (repositoryVersion == null) {
                for (int i10 = list2.size() - 1; i10 >= 0; --i10) {
                    if (!list2.get(i10).startsWith("ALTER TABLE") && !list2.get(i10).startsWith("commit work")) continue;
                    list2.remove(i10);
                }
            }
        }
        if (null == list) {
            list = list2;
        } else {
            list.addAll(list2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> createVersionBasedScript(boolean bl2, String string) throws RepositorySetupException, IOException {
        Object object;
        Object object2;
        URL uRL = null;
        try {
            uRL = this.c == null ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2Repository" + string) : (((String)(object2 = this.c.getMetaData().getDatabaseProductName().toUpperCase())).contains("ORACLE") ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/Oracle/oraRepository" + string) : (((String)object2).startsWith("INFORMIX") || ((String)object2).startsWith("IDS") ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/IDS/idsRepository" + string) : (((String)object2).contains("DERBY") ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/derbyRepository" + string) : (((String)(object = this.c.getMetaData().getDatabaseProductVersion().toUpperCase())).startsWith("DSN") ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zV8Repository" + string) : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2Repository" + string)))));
        }
        catch (SQLException sQLException) {
            if (string.startsWith("Setup")) {
                throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_CREATE_SCRIPT", new Object[0]), sQLException);
            }
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_DELETE_SCRIPT", new Object[0]), sQLException);
        }
        object2 = null;
        object = null;
        try {
            object = uRL.openStream();
            object2 = StreamUtils.getScript((InputStream)object);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
        for (int i10 = object2.size() - 1; i10 >= 0; --i10) {
            if (object2.get(i10) != null && ((String)object2.get(i10)).trim().length() != 0) continue;
            object2.remove(i10);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUpgradeScript225(boolean bl2) throws RepositorySetupException, IOException {
        Object object;
        Object object2;
        URL uRL = null;
        try {
            if (this.c == null) {
                uRL = this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2RepositorySetup_2.2.5.sql");
            } else {
                object2 = this.c.getMetaData().getDatabaseProductName().toUpperCase();
                if (!(((String)object2).contains("ORACLE") || ((String)object2).startsWith("INFORMIX") || ((String)object2).startsWith("IDS") || ((String)object2).contains("DERBY"))) {
                    object = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
                    uRL = ((String)object).startsWith("DSN") ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zV8RepositorySetup_2.2.5.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2RepositorySetup_2.2.5.sql");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_CREATE_SCRIPT", new Object[0]), sQLException);
        }
        if (uRL == null) {
            return new ArrayList<String>();
        }
        object2 = null;
        object = null;
        try {
            object = uRL.openStream();
            object2 = StreamUtils.getScript((InputStream)object);
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
        for (int i10 = object2.size() - 1; i10 >= 0; --i10) {
            if (object2.get(i10) != null && ((String)object2.get(i10)).trim().length() != 0) continue;
            object2.remove(i10);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDropScriptInternal(boolean bl2, String string, RepositoryVersion repositoryVersion) throws RepositorySetupException, IOException {
        Object object;
        int n2;
        List<String> list;
        URL uRL = null;
        String string2 = null;
        try {
            if (this.c == null) {
                uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2RepositoryDrop.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2LiteRepositoryDrop.sql");
            } else {
                string2 = this.c.getMetaData().getDatabaseProductName().toUpperCase();
                if (string2.startsWith("ORACLE")) {
                    uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/Oracle/oraRepositoryDrop.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/Oracle/oraLiteRepositoryDrop.sql");
                } else if (string2.startsWith("INFORMIX") || string2.startsWith("IDS")) {
                    uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/IDS/idsRepositoryDrop.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/IDS/idsLiteRepositoryDrop.sql");
                } else if (string2.contains("DERBY")) {
                    uRL = bl2 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/derbyRepositoryDrop.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/derbyLiteRepositoryDrop.sql");
                } else {
                    list = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
                    boolean bl3 = false;
                    if (repositoryVersion != null) {
                        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 4);
                        boolean bl4 = bl3 = repositoryVersion.compareTo(repositoryVersionImpl) == 0;
                    }
                    uRL = bl2 ? (((String)((Object)list)).startsWith("DSN") ? (bl3 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zRepositoryDropM4.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zRepositoryDrop.sql")) : (bl3 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2RepositoryDropM4.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2RepositoryDrop.sql"))) : (((String)((Object)list)).startsWith("DSN") ? (bl3 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zLiteRepositoryDropM4.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2zLiteRepositoryDrop.sql")) : (bl3 ? this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2LiteRepositoryDropM4.sql") : this.getClass().getResource("/com/ibm/pdq/runtime/internal/repository/config/sql/current/DB2/db2LiteRepositoryDrop.sql")));
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_DELETE_SCRIPT", new Object[0]), sQLException);
        }
        list = null;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            list = StreamUtils.getScript(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            if (list.get(n2) != null && ((String)list.get(n2)).trim().length() != 0) continue;
            list.remove(n2);
        }
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            if (!((String)list.get(n2)).startsWith("{upgrades}")) continue;
            object = this.getDropScriptInternal226Plus(bl2, repositoryVersion, string);
            list.remove(n2);
            if (null == object) break;
            list.addAll(n2, (Collection<String>)object);
            break;
        }
        if (this.existingTablespaces != null) {
            for (n2 = list.size() - 1; n2 >= 0; --n2) {
                String[] stringArray;
                object = (String)list.get(n2);
                if (!this.isDropTablespace((String)object, stringArray = new String[1]) || this.isExistingTablespace(stringArray[0])) continue;
                list.remove(n2);
            }
        }
        if (string2 != null && string2.startsWith("DB2")) {
            list = this.qualifyDropPackageStmts(string, list, repositoryVersion);
        }
        return list;
    }

    private List<String> getDropScriptInternal226Plus(boolean bl2, RepositoryVersion repositoryVersion, String string) throws RepositorySetupException, IOException {
        List<String> list = null;
        List<String> list2 = null;
        int n2 = -1;
        if (repositoryVersion == null && this.c != null) {
            try {
                repositoryVersion = RepositoryUtility.getPQRepositoryVersion(this.c, string);
            }
            catch (Exception exception) {
                throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_REPOSITORY", new Object[0]), exception);
            }
        }
        if (null != repositoryVersion) {
            RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 6);
            n2 = repositoryVersionImpl.compareTo(repositoryVersion);
        }
        if (n2 <= 0) {
            list = this.createVersionBasedScript(bl2, "Drop_2.2.6.sql");
            if (n2 < 0) {
                list2 = this.createVersionBasedScript(bl2, "Drop_2.2.7.sql");
                list.addAll(list2);
            }
        }
        return list;
    }

    @Override
    public List<Exception> removeRepository(String string, PrintWriter printWriter, RepositoryVersion repositoryVersion) throws RepositorySetupException, SQLException {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        boolean bl2 = true;
        try {
            if (repositoryVersion != null) {
                bl2 = repositoryVersion.isFullRepository();
            }
            this.existingTablespaces = this.getTablespaces();
        }
        catch (Exception exception) {
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DETERMINE_REPOSITORY", new Object[0]), exception);
        }
        try {
            List<String> list = this.getDropScriptInternal(bl2, string, repositoryVersion);
            ConnectionManager.ConnectionType connectionType = ConnectionManager.getConnectionType(this.c);
            String string2 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
            if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2)) {
                if (string2.startsWith("DSN")) {
                    list = this.replaceDBNameInCreateDropScript(list, string);
                } else if (string2.startsWith("SQL")) {
                    list = this.commentDropStmts(list);
                }
                SQLUtilities.runScript(this.c, string, list, true, arrayList, printWriter);
            }
        }
        catch (Exception exception) {
            throw new RepositorySetupException(Messages.getText("ERR_CANNOT_DELETE_REPOSITORY", new Object[0]), exception);
        }
        this.getOrExecuteSchemaStmtToDrop(true, string);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrExecuteSchemaStmtToDrop(boolean bl2, String string) throws SQLException {
        String string2;
        block6: {
            String string3 = this.c.getMetaData().getDatabaseProductName().toUpperCase();
            string2 = "";
            try {
                String string4 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
                if (string3.contains("DB2") && string4.startsWith("DSN") || (!string3.contains("DB2") || !string4.startsWith("SQL")) && !string3.contains("DERBY") && !string3.contains("ORACLE")) break block6;
                string2 = "drop schema " + string + " restrict";
                if (!bl2) break block6;
                Statement statement = this.c.createStatement();
                try {
                    statement.executeUpdate(string2);
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                boolean bl3;
                Logger logger = Log.getLogger();
                boolean bl4 = bl3 = logger != null && logger.isLoggable(Level.WARNING);
                if (!bl3) break block6;
                String string5 = "Exception dropping schema " + string + " after deleting repository";
                logger.logp(Level.WARNING, "RepositorySetupManagerImpl", "getOrExecuteSchemaStmtToDrop", string5);
            }
        }
        return string2;
    }

    @Override
    public List<String> getDropScript(boolean bl2, String string, RepositoryVersion repositoryVersion) throws RepositorySetupException, IOException, SQLException {
        String string2 = this.getCurrentSchemaAndSet(string);
        List<String> list = this.getDropScriptInternal(bl2, string, repositoryVersion);
        ConnectionManager.ConnectionType connectionType = ConnectionManager.getConnectionType(this.c);
        String string3 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2) && string3.startsWith("DSN")) {
            list = this.replaceDBNameInCreateDropScript(list, string);
        }
        list.add(0, string2);
        list.add(this.getOrExecuteSchemaStmtToDrop(false, string));
        if (connectionType.equals((Object)ConnectionManager.ConnectionType.DB2) && string3.startsWith("SQL")) {
            list = this.commentDropStmts(list);
        }
        return this.addStmtTerminator(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> getTablespaces() {
        block9: {
            if (this.c == null) {
                return null;
            }
            try {
                String string = this.c.getMetaData().getDatabaseProductName().toUpperCase();
                if (!string.contains("DB2")) break block9;
                String string2 = this.c.getMetaData().getDatabaseProductVersion().toUpperCase();
                HashSet<String> hashSet = new HashSet<String>();
                ResultSet resultSet = null;
                Statement statement = null;
                try {
                    statement = this.c.createStatement();
                    resultSet = string2.startsWith("DSN") ? statement.executeQuery("SELECT NAME FROM SYSIBM.SYSTABLESPACE") : statement.executeQuery("SELECT TBSPACE FROM SYSIBM.SYSTABLESPACES");
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        if (string3 == null) continue;
                        hashSet.add(string3.toUpperCase());
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                return hashSet;
            }
            catch (SQLException sQLException) {
                ToolsLogger.getLogger().log(Level.FINE, sQLException.getMessage());
            }
        }
        return null;
    }

    private boolean isDropTablespace(String string, String[] stringArray) {
        Matcher matcher = dropTsPattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            int n2 = (string2 = string2.toUpperCase()).indexOf(46);
            if (n2 > -1) {
                string2 = string2.substring(n2 + 1);
            }
            stringArray[0] = string2;
            return true;
        }
        return false;
    }

    private boolean isExistingTablespace(String string) {
        if (this.existingTablespaces == null) {
            return false;
        }
        return this.existingTablespaces.contains(string);
    }

    private static String getGrantRevokeStmt(boolean bl2, String string, boolean bl3, String string2, String[] stringArray) {
        String string3 = "";
        string3 = bl2 ? string3 + "GRANT " : string3 + "REVOKE ";
        string3 = bl3 ? string3 + "EXECUTE ON PACKAGE IBMPDQ." + string2 : string3 + string + " ON \"" + string2 + "\"";
        string3 = bl2 ? string3 + " TO " : string3 + " FROM ";
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            if (i10 > 0) {
                string3 = string3 + ", ";
            }
            string3 = string3 + stringArray[i10];
        }
        return string3;
    }

    private static String getGrantRevokeSequenceStmt(boolean bl2, boolean bl3, String string, String[] stringArray) {
        String string2 = "";
        string2 = bl2 ? string2 + "GRANT " : string2 + "REVOKE ";
        string2 = bl3 ? string2 + "SELECT ON " : string2 + "USAGE ON SEQUENCE ";
        string2 = string2 + "\"" + string + "\"";
        string2 = bl2 ? string2 + " TO " : string2 + " FROM ";
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            if (i10 > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + stringArray[i10];
        }
        return string2;
    }

    private static List<String> getUpgrade227GrantExecutePackageScript(RepositoryVersion repositoryVersion, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 7);
        int n2 = repositoryVersion.compareTo(repositoryVersionImpl);
        if (n2 < 0) {
            String[] stringArray2 = new String[]{"AMDRF1", "AMDRF2", "AMDRF3", "AMDRF4"};
            int n3 = stringArray2.length;
            for (int i10 = 0; i10 < n3; ++i10) {
                String string2 = RepositorySetupManagerImpl.getGrantRevokeStmt(true, "EXECUTE", true, stringArray2[i10], stringArray);
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private List<String> getGrantRevokeAccessScriptInternal(RepositoryVersion repositoryVersion, String string, boolean bl2, String string2, boolean bl3, String[] stringArray) throws RepositorySetupException, IOException, SQLException {
        ArrayList<String> arrayList;
        block37: {
            String string3;
            int n2;
            int n3;
            String string4;
            String[] stringArray2;
            String[] stringArray3;
            String[] stringArray4;
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            int n4;
            boolean bl4;
            block36: {
                int n5;
                int n6;
                Object object;
                arrayList = new ArrayList<String>();
                if (stringArray.length == 0) {
                    return arrayList;
                }
                bl4 = false;
                boolean bl5 = repositoryVersion.isFullRepository();
                try {
                    object = this.c.getMetaData().getDatabaseProductName().toUpperCase();
                    bl4 = ((String)object).startsWith("INFORMIX") || ((String)object).startsWith("IDS");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                object = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 6);
                n4 = repositoryVersion.compareTo((RepositoryVersion)object);
                String string5 = "";
                if (n4 > 0 && !string.equalsIgnoreCase("IBMPDQ")) {
                    string5 = string + "_";
                }
                String string6 = string5 + "AMD";
                String string7 = string5 + "AMDA";
                String string8 = string5 + "AMDL";
                String string9 = string5 + "AMDRF";
                String[] stringArray5 = new String[]{"METADATASOURCE_T", "CAPTUREDATA_T", "METADATAGROUP_T", "METADATAGROUPMEMBERS_T", "CONTACT_T"};
                String[] stringArray6 = new String[]{string6 + "1", string6 + "2", string6 + "3", string6 + "4", string7 + "1", string7 + "2", string7 + "3", string7 + "4", string8 + "1", string8 + "2", string8 + "3", string8 + "4", string9 + "1", string9 + "2", string9 + "3", string9 + "4"};
                String[] stringArray7 = new String[]{string7 + "1", string7 + "2", string7 + "3", string7 + "4", string9 + "1", string9 + "2", string9 + "3", string9 + "4"};
                String[] stringArray8 = new String[]{string7 + "1", string7 + "2", string7 + "3", string7 + "4", string8 + "1", string8 + "2", string8 + "3", string8 + "4", string9 + "1", string9 + "2", string9 + "3", string9 + "4"};
                String[] stringArray9 = new String[]{string6 + "1", string6 + "2", string6 + "3", string6 + "4", string8 + "1", string8 + "2", string8 + "3", string8 + "4", string9 + "1", string9 + "2", string9 + "3", string9 + "4"};
                String[] stringArray10 = new String[]{string8 + "1", string8 + "2", string8 + "3", string8 + "4", string9 + "1", string9 + "2", string9 + "3", string9 + "4"};
                Object[] objectArray4 = new String[]{"METADATASOURCE_T", "METADATAGROUP_T", "METADATAGROUPMEMBERS_T", "CONTACT_T", "SCHEMA_VERSION_T"};
                Object[] objectArray5 = new String[]{"METADATASOURCE", "METADATAGROUP", "METADATAGROUPMEMBERS", "CONTACT", "SCHEMA_VERSION", "CAPTUREDATA"};
                objectArray3 = null;
                objectArray2 = null;
                objectArray = new String[]{"CAPTUREDATA_T"};
                String[] stringArray11 = new String[]{"CAPTUREDATA_T", "LOG_T"};
                String[] stringArray12 = new String[]{"CAPTUREDATA_T", "LOG_T", "SCHEMA_VERSION_T"};
                ArrayList<String> arrayList2 = new ArrayList<String>(5);
                if (bl5) {
                    for (n6 = 0; n6 < TableNames.AllTables.length; ++n6) {
                        arrayList2.add(TableNames.AllTables[n6]);
                    }
                } else {
                    for (n6 = 0; n6 < stringArray5.length; ++n6) {
                        arrayList2.add(stringArray5[n6]);
                    }
                }
                arrayList2.add("SCHEMA_VERSION_T");
                if (n4 < 0) {
                    objectArray3 = objectArray4;
                    objectArray2 = objectArray5;
                } else {
                    arrayList2.add("LOG_T");
                    objectArray3 = new String[objectArray4.length + 1];
                    objectArray2 = new String[objectArray5.length + 1];
                    for (n6 = 0; n6 < objectArray4.length; ++n6) {
                        objectArray3[n6] = objectArray4[n6];
                    }
                    for (n6 = 0; n6 < objectArray5.length; ++n6) {
                        objectArray2[n6] = objectArray5[n6];
                    }
                    objectArray3[objectArray3.length - 1] = "LOG_T";
                    objectArray2[objectArray2.length - 1] = "LOG";
                    objectArray = n4 == 0 ? stringArray11 : stringArray12;
                }
                n6 = arrayList2.size();
                stringArray4 = new String[n6];
                stringArray3 = new String[n6];
                for (n5 = 0; n5 < n6; ++n5) {
                    stringArray4[n5] = (String)arrayList2.get(n5);
                    stringArray3[n5] = stringArray4[n5].substring(0, stringArray4[n5].length() - 2);
                }
                if (bl4) {
                    for (n5 = 0; n5 < stringArray4.length; ++n5) {
                        stringArray4[n5] = stringArray4[n5].toLowerCase();
                        stringArray3[n5] = stringArray3[n5].toLowerCase();
                    }
                    for (n5 = 0; n5 < objectArray3.length; ++n5) {
                        objectArray3[n5] = objectArray3[n5].toLowerCase();
                    }
                    for (n5 = 0; n5 < objectArray2.length; ++n5) {
                        objectArray2[n5] = objectArray2[n5].toLowerCase();
                    }
                    for (n5 = 0; n5 < objectArray.length; ++n5) {
                        objectArray[n5] = objectArray[n5].toLowerCase();
                    }
                    if (string.equals("IBMPDQ")) {
                        string = "IBMPDQ".toLowerCase();
                    }
                }
                stringArray2 = new String[]{"METADATAGROUP_REFRESH_SEQ"};
                string4 = this.getCurrentSchemaAndSet(string);
                if (!bl3) break block36;
                String[] stringArray13 = null;
                stringArray13 = string2 == null || string2.equalsIgnoreCase("manager") ? (bl5 ? stringArray6 : stringArray8) : (string2.equalsIgnoreCase("remainingAdminPrivileges") ? (bl5 ? stringArray9 : stringArray10) : stringArray7);
                int n7 = stringArray13.length;
                if (n4 <= 0) {
                    n7 -= 4;
                }
                for (int i10 = 0; i10 < n7; ++i10) {
                    String string10 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "EXECUTE", bl3, stringArray13[i10], stringArray);
                    arrayList.add(string10);
                }
                break block37;
            }
            arrayList.add(string4);
            if (string2 == null || string2.equalsIgnoreCase("manager")) {
                n3 = stringArray4.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string3 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "SELECT, INSERT, UPDATE, DELETE", bl3, stringArray4[n2], stringArray);
                    arrayList.add(string3);
                }
                n3 = stringArray3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string3 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "SELECT", bl3, stringArray3[n2], stringArray);
                    arrayList.add(string3);
                }
            } else if (string2.equalsIgnoreCase("remainingAdminPrivileges")) {
                n3 = objectArray3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string3 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "INSERT, UPDATE, DELETE", bl3, (String)objectArray3[n2], stringArray);
                    arrayList.add(string3);
                }
                Arrays.sort(objectArray3);
                Arrays.sort(objectArray);
                n3 = stringArray4.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (Arrays.binarySearch(objectArray3, stringArray4[n2]) >= 0 || Arrays.binarySearch(objectArray, stringArray4[n2]) >= 0) continue;
                    string3 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "SELECT, INSERT, UPDATE, DELETE", bl3, stringArray4[n2], stringArray);
                    arrayList.add(string3);
                }
                n3 = stringArray3.length;
                Arrays.sort(objectArray2);
                for (n2 = 0; n2 < n3; ++n2) {
                    if (Arrays.binarySearch(objectArray2, stringArray3[n2]) >= 0) continue;
                    string3 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "SELECT", bl3, stringArray3[n2], stringArray);
                    arrayList.add(string3);
                }
            } else {
                String string11;
                for (n3 = 0; n3 < objectArray3.length; ++n3) {
                    string11 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "SELECT", bl3, (String)objectArray3[n3], stringArray);
                    arrayList.add(string11);
                }
                for (n3 = 0; n3 < objectArray2.length; ++n3) {
                    string11 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "SELECT", bl3, objectArray2[n3], stringArray);
                    arrayList.add(string11);
                }
                n3 = objectArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    string3 = RepositorySetupManagerImpl.getGrantRevokeStmt(bl2, "SELECT, INSERT, UPDATE, DELETE", bl3, (String)objectArray[n2], stringArray);
                    arrayList.add(string3);
                }
            }
            if (n4 <= 0) break block37;
            if (bl4) {
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    stringArray2[n3] = stringArray2[n3].toLowerCase();
                }
            }
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                String string12 = RepositorySetupManagerImpl.getGrantRevokeSequenceStmt(bl2, bl4, stringArray2[n3], stringArray);
                arrayList.add(string12);
            }
        }
        return arrayList;
    }

    @Override
    public void grantRevokeAccess(RepositoryVersion repositoryVersion, String string, boolean bl2, String string2, boolean bl3, String[] stringArray, PrintWriter printWriter) throws RepositorySetupException, IOException, SQLException {
        try {
            if (bl2) {
                SQLUtilities.runScript(this.c, string, this.getGrantRevokeAccessScriptInternal(repositoryVersion, string, bl2, string2, bl3, stringArray), false, null, printWriter);
            } else {
                ArrayList<Exception> arrayList = new ArrayList<Exception>();
                SQLUtilities.runScript(this.c, string, this.getGrantRevokeAccessScriptInternal(repositoryVersion, string, bl2, "application", bl3, stringArray), false, null, printWriter);
                SQLUtilities.runScript(this.c, string, this.getGrantRevokeAccessScriptInternal(repositoryVersion, string, bl2, "remainingAdminPrivileges", bl3, stringArray), true, arrayList, printWriter);
            }
        }
        catch (SchemaDoesNotExistException schemaDoesNotExistException) {
            String string3 = Messages.getText("ERR_CANNOT_SET_DEFAULT_SCHEMA", string);
            throw new RepositorySetupException(string3, schemaDoesNotExistException);
        }
        this.c.commit();
    }

    @Override
    public List<String> getGrantRevokeAccessScript(RepositoryVersion repositoryVersion, String string, boolean bl2, String string2, boolean bl3, String[] stringArray) throws RepositorySetupException, IOException, SQLException {
        List<String> list = this.getGrantRevokeAccessScriptInternal(repositoryVersion, string, bl2, string2, bl3, stringArray);
        return this.addStmtTerminator(list);
    }

    @Override
    public List<String> addStmtTerminator(List<String> list) {
        int n2 = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i10 = 0; i10 < n2; ++i10) {
            String string = list.get(i10);
            if (!string.startsWith("--")) {
                string = string + STMT_TERMINATOR;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> commentDropStmts(List<String> list) {
        int n2 = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i10 = 0; i10 < n2; ++i10) {
            String string = list.get(i10);
            if (string.startsWith("drop bufferpool") || string.startsWith("drop tablespace")) {
                string = "-- " + string + STMT_TERMINATOR;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> qualifyDropPackageStmts(String string, List<String> list, RepositoryVersion repositoryVersion) {
        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 6);
        int n2 = repositoryVersion.compareTo(repositoryVersionImpl);
        String string2 = "";
        if (n2 > 0 && !string.equalsIgnoreCase("IBMPDQ")) {
            string2 = string + "_";
        }
        int n3 = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n3);
        for (int i10 = 0; i10 < n3; ++i10) {
            String string3 = list.get(i10);
            if (string3.length() > 12 && string3.substring(0, 13).equalsIgnoreCase("drop package ")) {
                String string4 = string3.substring(13).trim();
                string3 = "drop package IBMPDQ." + string2 + string4;
            }
            arrayList.add(string3);
        }
        return arrayList;
    }

    @Override
    public List<String> getBindStaticPackages(String string, RepositoryVersion repositoryVersion, boolean bl2) throws SQLException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 6);
        int n2 = repositoryVersion.compareTo(repositoryVersionImpl);
        String string3 = "";
        if (n2 > 0 && !string.equalsIgnoreCase("DB2PM") && !string.equalsIgnoreCase("IBMPDQ")) {
            string3 = " -repositorySchema " + string;
        }
        String string4 = "java -classpath db2jcc.jar;db2jcc_license_cu.jar;pdq.jar;pdqmgmt.jar com.ibm.db2.cmx.tools.StaticBinder" + string3 + " -url " + this.c.getMetaData().getURL() + " -username " + this.c.getMetaData().getUserName() + " -password password -bindOptions \"QUALIFIER " + string + "\" -interface " + dao_pkg2AMDA_;
        arrayList.add(string4);
        String string5 = "java -classpath db2jcc.jar;db2jcc_license_cu.jar;pdq.jar;pdqmgmt.jar com.ibm.db2.cmx.tools.StaticBinder" + string3 + " -url " + this.c.getMetaData().getURL() + " -username " + this.c.getMetaData().getUserName() + " -password password -bindOptions \"QUALIFIER " + string + "\" -interface " + dao_pkg3AMDL_;
        arrayList.add(string5);
        if (repositoryVersion.isFullRepository()) {
            string2 = "java -classpath db2jcc.jar;db2jcc_license_cu.jar;pdq.jar;pdqmgmt.jar com.ibm.db2.cmx.tools.StaticBinder" + string3 + " -url " + this.c.getMetaData().getURL() + " -username " + this.c.getMetaData().getUserName() + " -password password -bindOptions \"QUALIFIER " + string + "\" -interface " + dao_pkg1AMD_;
            arrayList.add(string2);
        }
        if (bl2 || n2 > 0) {
            string2 = "java -classpath db2jcc.jar;db2jcc_license_cu.jar;pdq.jar;pdqmgmt.jar com.ibm.db2.cmx.tools.StaticBinder" + string3 + " -url " + this.c.getMetaData().getURL() + " -username " + this.c.getMetaData().getUserName() + " -password password -bindOptions \"QUALIFIER " + string + "\" -interface " + dao_db2AMDRF_;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public int bindStaticPackages(String string, RepositoryVersion repositoryVersion, boolean bl2, PrintWriter printWriter) throws MetadataException {
        int n2;
        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(repositoryVersion.getComponent(), 2, 2, 6);
        int n3 = repositoryVersion.compareTo(repositoryVersionImpl);
        String string2 = "";
        if (n3 > 0 && !string.equalsIgnoreCase("DB2PM") && !string.equalsIgnoreCase("IBMPDQ")) {
            string2 = "-repositorySchema " + string + " ";
        }
        String[] stringArray = new String[]{"defaultOptions", string2 + "-bindOptions \"QUALIFIER " + string + "\""};
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(stringArray);
        StaticBinder staticBinder = new StaticBinder();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n4 = staticBinder.bind((DB2Connection)this.c, dao_pkg2AMDA_, false, arrayList, null, true, printWriter);
        n5 = staticBinder.bind((DB2Connection)this.c, dao_pkg3AMDL_, false, arrayList, null, true, printWriter);
        if (n4 <= 63 && n5 <= 63) {
            n2 = 1;
            n2 = repositoryVersion.isFullRepository() ? 1 : 0;
            if (n2 != 0) {
                n6 = staticBinder.bind((DB2Connection)this.c, dao_pkg1AMD_, false, arrayList, null, true, printWriter);
            }
        }
        if (bl2 || n3 > 0) {
            n7 = staticBinder.bind((DB2Connection)this.c, dao_db2AMDRF_, false, arrayList, null, true, printWriter);
        }
        if (n5 > (n2 = n4)) {
            n2 = n5;
        }
        if (n6 > n2) {
            n2 = n6;
        }
        if (n7 > n2) {
            n2 = n7;
        }
        return n2;
    }

    private void prepareAllTablesAllViews(boolean bl2, String[] stringArray, String[] stringArray2) {
        if (bl2) {
            for (int i10 = 0; i10 < this.AllTables.length; ++i10) {
                stringArray[i10] = this.AllTables[i10];
                stringArray2[i10] = this.AllTables[i10].substring(0, this.AllTables[i10].length() - 2);
            }
        } else {
            for (int i11 = 0; i11 < this.COTables.length; ++i11) {
                stringArray[i11] = this.COTables[i11];
                stringArray2[i11] = this.COTables[i11].substring(0, this.COTables[i11].length() - 2);
            }
        }
    }

    @Override
    public boolean validate(String string, List<String> list, List<String> list2, List<String> list3) throws SQLException, MetadataException {
        boolean bl2 = true;
        String[] stringArray = null;
        String[] stringArray2 = null;
        boolean bl3 = true;
        RepositoryVersion repositoryVersion = this.getRepositoryVersion(string);
        if (repositoryVersion != null) {
            bl3 = repositoryVersion.isFullRepository();
        }
        if (bl3) {
            stringArray = new String[this.AllTables.length];
            stringArray2 = new String[this.AllTables.length];
        } else {
            stringArray = new String[this.COTables.length];
            stringArray2 = new String[this.COTables.length];
        }
        this.prepareAllTablesAllViews(bl3, stringArray, stringArray2);
        DatabaseMetaData databaseMetaData = this.c.getMetaData();
        String string2 = databaseMetaData.getDatabaseProductName().toUpperCase();
        boolean bl4 = string2.startsWith("INFORMIX") || string2.startsWith("IDS");
        String[] stringArray3 = new String[]{"VIEW"};
        for (int i10 = 0; i10 < stringArray2.length; ++i10) {
            String string3 = stringArray2[i10];
            if (this.validate(databaseMetaData, string, string3, list, list3, stringArray3, this.AllColumns[i10], bl4)) continue;
            bl2 = false;
        }
        String[] stringArray4 = new String[]{"TABLE"};
        for (int i11 = 0; i11 < stringArray.length; ++i11) {
            String string4 = stringArray[i11];
            if (this.validate(databaseMetaData, string, string4, list2, list3, stringArray4, this.AllColumns[i11], bl4)) continue;
            bl2 = false;
        }
        return bl2;
    }

    private boolean validate(DatabaseMetaData databaseMetaData, String string, String string2, List<String> list, List<String> list2, String[] stringArray, String[] stringArray2, boolean bl2) throws SQLException {
        boolean bl3 = true;
        String string3 = bl2 ? string2.toLowerCase() : string2;
        ResultSet resultSet = databaseMetaData.getTables(null, string, string3, stringArray);
        if (resultSet.next()) {
            resultSet.close();
            HashSet<String> hashSet = new HashSet<String>();
            ResultSet resultSet2 = databaseMetaData.getColumns(null, string, string3, "%");
            while (resultSet2.next()) {
                hashSet.add(resultSet2.getString(4));
            }
            for (int i10 = 0; i10 < stringArray2.length; ++i10) {
                String string4 = stringArray2[i10];
                if (bl2 && Arrays.binarySearch(this.idsColumnsUPC, string4) < 0) {
                    string4 = string4.toLowerCase();
                }
                if (hashSet.contains(string4)) continue;
                list2.add(string2 + "." + stringArray2[i10]);
                bl3 = false;
            }
        } else {
            list.add(string2);
            bl3 = false;
        }
        return bl3;
    }

    @Override
    public List<String> validate(String string) throws MetadataException {
        String string2;
        int n2;
        String string3;
        int n3;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        String[] stringArray2 = null;
        boolean bl2 = false;
        try {
            DatabaseMetaData databaseMetaData = this.c.getMetaData();
            object = databaseMetaData.getDatabaseProductName().toUpperCase();
            bl2 = ((String)object).startsWith("INFORMIX") || ((String)object).startsWith("IDS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean bl3 = true;
        object = this.getRepositoryVersion(string);
        if (object != null) {
            bl3 = object.isFullRepository();
        }
        if (bl3) {
            stringArray = new String[this.AllTables.length];
            stringArray2 = new String[this.AllTables.length];
        } else {
            stringArray = new String[this.COTables.length];
            stringArray2 = new String[this.COTables.length];
        }
        this.prepareAllTablesAllViews(bl3, stringArray, stringArray2);
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            string3 = "SELECT ";
            for (n2 = 0; n2 < this.AllColumns[n3].length; ++n2) {
                if (n2 > 0) {
                    string3 = string3 + ", ";
                }
                string2 = this.AllColumns[n3][n2];
                if (bl2 && Arrays.binarySearch(this.idsColumnsUPC, string2) >= 0) {
                    string2 = '\"' + string2 + '\"';
                }
                string3 = string3 + string2;
            }
            string3 = string3 + " FROM ";
            string3 = string3 + string + "." + stringArray2[n3] + STMT_TERMINATOR;
            arrayList.add(string3);
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            string3 = "SELECT ";
            for (n2 = 0; n2 < this.AllColumns[n3].length; ++n2) {
                if (n2 > 0) {
                    string3 = string3 + ", ";
                }
                string2 = this.AllColumns[n3][n2];
                if (bl2 && Arrays.binarySearch(this.idsColumnsUPC, string2) >= 0) {
                    string2 = '\"' + string2 + '\"';
                }
                string3 = string3 + string2;
            }
            string3 = string3 + " FROM ";
            string3 = string3 + string + "." + stringArray[n3] + STMT_TERMINATOR;
            arrayList.add(string3);
        }
        return arrayList;
    }

    @Override
    public RepositoryVersion getRepositoryVersion(String string) throws MetadataException {
        RepositoryVersionImpl repositoryVersionImpl = null;
        try {
            repositoryVersionImpl = RepositoryUtility.getPQRepositoryVersion(this.c, string);
        }
        catch (Exception exception) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), exception);
        }
        return repositoryVersionImpl;
    }

    public RepositoryVersion getRepositoryVersion(Connection connection, ConnectionManager.ConnectionInfo connectionInfo) throws MetadataException {
        RepositoryVersionImpl repositoryVersionImpl = null;
        try {
            repositoryVersionImpl = RepositoryUtility.getPQRepositoryVersion(connection, connectionInfo);
        }
        catch (Exception exception) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), exception);
        }
        return repositoryVersionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getPackageGranteeIds(String string, int n2, Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Statement statement = null;
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string2 = null;
        String string3 = null;
        try {
            string2 = databaseMetaData.getDatabaseProductName().toUpperCase();
            string3 = databaseMetaData.getDatabaseProductVersion().toUpperCase();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (string2 != null && string3 != null) {
            try {
                if (string2.startsWith("DB2")) {
                    String string4 = "";
                    if (n2 > 0 && !string.equalsIgnoreCase("IBMPDQ")) {
                        string4 = string + "_";
                    }
                    String string5 = string4 + "AMDA2";
                    String string6 = string3.startsWith("DSN") ? "SELECT DISTINCT GRANTEE FROM SYSIBM.SYSPACKAUTH WHERE COLLID = 'IBMPDQ' AND NAME = '" + string5 + "' AND EXECUTEAUTH <> ' '" : "SELECT DISTINCT GRANTEE FROM SYSCAT.PACKAGEAUTH WHERE PKGSCHEMA = 'IBMPDQ' AND PKGNAME = '" + string5 + "' AND EXECUTEAUTH <> 'N'";
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(string6);
                    while (resultSet.next()) {
                        String string7 = resultSet.getString(1);
                        arrayList.add(string7);
                    }
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
        }
        return arrayList;
    }

    private String[] getTableGranteeIds(String string, DatabaseMetaData databaseMetaData, boolean bl2, int n2) throws SQLException {
        Object object;
        String string2 = databaseMetaData.getUserName();
        TreeSet<String[]> treeSet = new TreeSet<String[]>();
        ResultSet resultSet = databaseMetaData.getTablePrivileges(null, string, "CAPTUREDATA_T");
        while (resultSet.next()) {
            object = resultSet.getString("GRANTEE");
            if (object.equalsIgnoreCase(string2) || object.equalsIgnoreCase(string)) continue;
            treeSet.add((String[])object);
        }
        resultSet.close();
        if (bl2) {
            object = "";
            if (n2 > 0 && !string.equalsIgnoreCase("IBMPDQ")) {
                object = string + "_";
            }
            String string3 = (String)object + "AMD";
            String string4 = (String)object + "AMDA";
            String string5 = (String)object + "AMDL";
            String string6 = (String)object + "AMDRF";
            String[] stringArray = new String[]{string3 + "1", string3 + "2", string3 + "3", string3 + "4", string4 + "1", string4 + "2", string4 + "3", string4 + "4", string5 + "1", string5 + "2", string5 + "3", string5 + "4", string6 + "1", string6 + "2", string6 + "3", string6 + "4"};
            int n3 = stringArray.length;
            for (int i10 = 0; i10 < n3; ++i10) {
                treeSet.remove(stringArray[i10]);
            }
        }
        object = null;
        if (!treeSet.isEmpty()) {
            object = treeSet.toArray(new String[treeSet.size()]);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRepositorySchemas(Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = null;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        if (databaseMetaData != null) {
            try {
                arrayList2 = new ArrayList<String>();
                resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_SCHEM");
                    resultSet2 = databaseMetaData.getTables(null, string, null, new String[]{"TABLE"});
                    while (resultSet2.next()) {
                        String string2 = resultSet2.getString("TABLE_NAME");
                        arrayList.add(string2);
                    }
                    if (!arrayList.contains("METADATASOURCE_T") || !arrayList.contains("CAPTUREDATA_T") || !arrayList.contains("METADATAGROUP_T")) continue;
                    arrayList2.add(string);
                    arrayList.clear();
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (resultSet2 != null) {
                    resultSet2.close();
                }
            }
        }
        return arrayList2;
    }
}

