/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerDownloadEvent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import com.install4j.runtime.installer.helper.content.TransferFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;

public class Downloader
extends TransferFileHandler {
    private MessageDigest md;

    public Downloader(Context context, ProgressInterface progressInterface) {
        super(context, progressInterface);
    }

    public Downloader(int mode, ProgressInterface progressInterface) {
        super(mode, progressInterface);
    }

    @Override
    protected void init(ProgressInterface progressInterface) {
        super.init(progressInterface);
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
        }
    }

    public void setMessageDigest(MessageDigest md) {
        this.md = md;
    }

    public byte[] digest() {
        return this.md.digest();
    }

    @Override
    protected void connectionInitialized(URLConnection connection) {
        super.connectionInitialized(connection);
        this.setFileSize(connection.getContentLengthLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(File outputFile, long defaultFileSize, boolean deleteOnExit) throws IOException, UserCanceledException {
        Set<InstallerDownloadEvent.DownloadProgressListener> progressListeners;
        File parentFile = outputFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        this.initProgress(defaultFileSize);
        URLConnection connection = this.getConnection();
        Context context = this.getContext();
        ContextInt contextInt = ContextImpl.getContextInt(context);
        if (contextInt != null) {
            InstallerDownloadEvent downloadEvent = new InstallerDownloadEvent(contextInt.getEventSource(), context, EventType.BEFORE_DOWNLOAD, connection.getURL(), outputFile, this.getTotalSize());
            contextInt.fireInstallerEvent(downloadEvent);
            progressListeners = downloadEvent.getDownloadProgressListeners();
        } else {
            progressListeners = Collections.emptySet();
        }
        try {
            this.updateProgress(true, progressListeners);
            this.md.reset();
            DigestOutputStream out = new DigestOutputStream(new FileOutputStream(outputFile), this.md);
            try {
                long count = FileUtil.pumpStream(connection.getInputStream(), out, new FileUtil.CopyProgressListener(){

                    @Override
                    public boolean progressPerformed(long val) {
                        Downloader.this.addProgress(val);
                        if (Downloader.this.isCancelled()) {
                            return false;
                        }
                        Downloader.this.updateProgress(false, progressListeners);
                        return true;
                    }
                });
                if (this.isCancelled()) {
                    if (context != null && contextInt != null) {
                        Logger.getInstance().info(contextInt.getEventSource(), "Download was canceled by the user");
                    }
                    this.fireAfterDownloadEvent(contextInt, EventType.AFTER_DOWNLOAD, outputFile, false);
                    throw new UserCanceledException();
                }
                long fileSize = this.getFileSize();
                if (count != fileSize && fileSize != -1L) {
                    throw new IOException("file size not correct: " + count + ", expected: " + fileSize);
                }
                this.updateProgress(true, progressListeners);
                this.fireAfterDownloadEvent(contextInt, EventType.AFTER_DOWNLOAD, outputFile, true);
            }
            finally {
                try {
                    ((OutputStream)out).close();
                    connection.getInputStream().close();
                }
                catch (Throwable throwable) {}
                if (deleteOnExit) {
                    outputFile.deleteOnExit();
                }
            }
        }
        catch (IOException e) {
            if (this.getMode() == 3) {
                System.err.println(e.getMessage());
            }
            this.fireAfterDownloadEvent(contextInt, EventType.AFTER_DOWNLOAD, outputFile, false);
            this.resetLastTransfer();
            outputFile.delete();
            throw e;
        }
        catch (UserCanceledException e) {
            if (!outputFile.delete() && outputFile.exists()) {
                outputFile.deleteOnExit();
            }
            throw e;
        }
    }

    private void fireAfterDownloadEvent(ContextInt contextInt, EventType eventType, File outputFile, boolean success) {
        if (contextInt != null) {
            contextInt.fireInstallerEvent(new InstallerDownloadEvent(contextInt.getEventSource(), this.getContext(), eventType, success, this.getConnection().getURL(), outputFile, this.getTotalSize()));
        }
    }

    @Override
    public Downloader connect(String urlString) throws IOException, UserCanceledException {
        return (Downloader)super.connect(urlString);
    }

    @Override
    public Downloader connect(String urlString, HttpRequestHandler.ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        return (Downloader)super.connect(urlString, connectionPreparer);
    }

    protected void updateProgress(boolean force, Set<InstallerDownloadEvent.DownloadProgressListener> progressListeners) {
        this.updateProgress(force);
        for (InstallerDownloadEvent.DownloadProgressListener progressListener : progressListeners) {
            progressListener.downloadCompleted(this.getTotalProgress());
        }
    }
}

