/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.FlatLaf;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class TriStateCheckBox
extends JCheckBox {
    private State state;
    private boolean thirdStateEnabled = true;

    public TriStateCheckBox() {
        this((String)null);
    }

    public TriStateCheckBox(String text) {
        this(text, State.INDETERMINATE);
    }

    public TriStateCheckBox(String text, State initialState) {
        super(text);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public boolean isSelected() {
                return TriStateCheckBox.this.state != State.UNSELECTED;
            }

            @Override
            public void setSelected(boolean b) {
                switch (TriStateCheckBox.this.state) {
                    case INDETERMINATE: {
                        TriStateCheckBox.this.setState(State.SELECTED);
                        break;
                    }
                    case SELECTED: {
                        TriStateCheckBox.this.setState(State.UNSELECTED);
                        break;
                    }
                    case UNSELECTED: {
                        TriStateCheckBox.this.setState(TriStateCheckBox.this.thirdStateEnabled ? State.INDETERMINATE : State.SELECTED);
                    }
                }
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
            }
        });
        this.setState(initialState);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (this.state == state) {
            return;
        }
        State oldState = this.state;
        this.state = state;
        this.putClientProperty("JButton.selectedState", state == State.INDETERMINATE ? "indeterminate" : null);
        this.firePropertyChange("state", (Object)oldState, (Object)state);
        this.repaint();
    }

    public boolean isThirdStateEnabled() {
        return this.thirdStateEnabled;
    }

    public void setThirdStateEnabled(boolean thirdStateEnabled) {
        this.thirdStateEnabled = thirdStateEnabled;
        if (this.state == State.INDETERMINATE) {
            this.setState(State.UNSELECTED);
        }
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? State.SELECTED : State.UNSELECTED);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.state == State.INDETERMINATE && !this.isThirdStateSupported()) {
            g.setColor(Color.magenta);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    private boolean isThirdStateSupported() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf instanceof FlatLaf || laf.getClass().getName().equals("com.apple.laf.AquaLookAndFeel");
    }

    public static enum State {
        INDETERMINATE,
        SELECTED,
        UNSELECTED;

    }
}

